/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import site.iway.androidhelpers.UnitHelper;
import site.iway.androidhelpers.ViewHelper;
import site.iway.javahelpers.MathHelper;

public class ViewSelector {
    private ViewGroup mViewGroup;
    private Context mContext;
    private boolean mEnableTouchSelect;
    private boolean mMultipleSelect;
    private boolean mContainSplitter;
    private float mTouchDownX;
    private float mTouchDownY;

    public ViewSelector(ViewGroup viewGroup, boolean enableTouchSelect, boolean multipleSelectMode, boolean containSplitter) {
        this.mViewGroup = viewGroup;
        this.mContext = viewGroup.getContext();
        this.mEnableTouchSelect = enableTouchSelect;
        this.mMultipleSelect = multipleSelectMode;
        this.mContainSplitter = containSplitter;
    }

    public int[] getSelectIndices() {
        ArrayList<Integer> selectedIndices = new ArrayList<Integer>();
        int childCount = this.mViewGroup.getChildCount();
        for (int i = 0; i < childCount; i += this.mContainSplitter ? 2 : 1) {
            View child = this.mViewGroup.getChildAt(i);
            boolean selected = child.isSelected();
            if (!selected) continue;
            selectedIndices.add(i);
        }
        int size = selectedIndices.size();
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (Integer)selectedIndices.get(i);
        }
        return array;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mEnableTouchSelect) {
            block0 : switch (event.getAction()) {
                case 0: {
                    this.mTouchDownX = event.getRawX();
                    this.mTouchDownY = event.getRawY();
                    break;
                }
                case 1: {
                    float dx = event.getRawX() - this.mTouchDownX;
                    float dy = event.getRawY() - this.mTouchDownY;
                    double distance = MathHelper.distance((double)dx, (double)dy);
                    double range = UnitHelper.dipToPx(this.mContext, 5.0f);
                    if (!(distance < range)) break;
                    int childCount = this.mViewGroup.getChildCount();
                    for (int childIndex = childCount - 1; childIndex >= 0; --childIndex) {
                        boolean selected;
                        boolean hittable;
                        View child = this.mViewGroup.getChildAt(childIndex);
                        boolean hitView = ViewHelper.isMotionEventInView(event, child);
                        boolean bl = this.mContainSplitter ? childIndex % 2 == 0 : (hittable = true);
                        if (!hitView || !hittable) continue;
                        boolean bl2 = selected = !child.isSelected();
                        if (this.mMultipleSelect) {
                            child.setSelected(selected);
                            break block0;
                        }
                        for (int i = 0; i < childCount; i += this.mContainSplitter ? 2 : 1) {
                            if (i == childIndex) {
                                this.mViewGroup.getChildAt(i).setSelected(selected);
                                continue;
                            }
                            this.mViewGroup.getChildAt(i).setSelected(false);
                        }
                        break block0;
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }
}

