/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.LinkedList;

public class ViewRecycler {
    private LayoutInflater mLayoutInflater;
    private LinkedList<View> mViews;
    private int mLayoutResId;

    public ViewRecycler(Context context, int layoutResId) {
        String serviceName = "layout_inflater";
        Object service = context.getSystemService(serviceName);
        this.mLayoutInflater = (LayoutInflater)service;
        this.mViews = new LinkedList();
        this.mLayoutResId = layoutResId;
    }

    public void setChildCount(ViewGroup viewGroup, int childCount) {
        View childView;
        while (viewGroup.getChildCount() > childCount) {
            childView = viewGroup.getChildAt(viewGroup.getChildCount() - 1);
            viewGroup.removeViewAt(viewGroup.getChildCount() - 1);
            this.mViews.add(childView);
        }
        while (viewGroup.getChildCount() < childCount) {
            childView = this.mViews.isEmpty() ? this.mLayoutInflater.inflate(this.mLayoutResId, viewGroup, false) : this.mViews.removeFirst();
            viewGroup.addView(childView);
        }
    }
}

