/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.os.Handler;

public abstract class UITimer {
    private Thread mThread;
    private Handler mHandler;
    private long mPostSpan;
    private boolean mRunning;
    private long mTargetRunTime;
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            if (currentTime < UITimer.this.mTargetRunTime) {
                long delay = UITimer.this.mPostSpan + (UITimer.this.mTargetRunTime - currentTime);
                UITimer.this.mHandler.postDelayed(UITimer.this.mRunnable, delay);
                UITimer.this.mTargetRunTime = System.currentTimeMillis() + delay;
            } else if (currentTime > UITimer.this.mTargetRunTime) {
                long delay = UITimer.this.mPostSpan + (UITimer.this.mTargetRunTime - currentTime);
                if (delay < 1L) {
                    delay = 1L;
                }
                UITimer.this.mHandler.postDelayed(UITimer.this.mRunnable, delay);
                UITimer.this.mTargetRunTime = System.currentTimeMillis() + delay;
            } else {
                UITimer.this.mHandler.postDelayed(UITimer.this.mRunnable, UITimer.this.mPostSpan);
                UITimer.this.mTargetRunTime = System.currentTimeMillis() + UITimer.this.mPostSpan;
            }
            UITimer.this.doOnUIThread();
        }
    };

    public UITimer(long span) {
        this.mThread = Thread.currentThread();
        this.mHandler = new Handler();
        this.mPostSpan = span;
        this.mRunning = false;
    }

    public UITimer() {
        this(10L);
    }

    public abstract void doOnUIThread();

    private void checkThread() {
        Thread currentThread = Thread.currentThread();
        if (currentThread != this.mThread) {
            throw new RuntimeException("Call from different thread.");
        }
    }

    public void start(boolean startOnce) {
        this.checkThread();
        if (this.mRunning) {
            this.mHandler.removeCallbacks(this.mRunnable);
        } else {
            this.mRunning = true;
        }
        if (startOnce) {
            this.mHandler.postDelayed(this.mRunnable, 0L);
            this.mTargetRunTime = System.currentTimeMillis();
        } else {
            this.mHandler.postDelayed(this.mRunnable, this.mPostSpan);
            this.mTargetRunTime = System.currentTimeMillis() + this.mPostSpan;
        }
    }

    public void stop() {
        this.checkThread();
        if (this.mRunning) {
            this.mHandler.removeCallbacks(this.mRunnable);
            this.mRunning = false;
        }
    }
}

