/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.os.Handler;
import java.util.LinkedList;
import java.util.List;

public class UIThread {
    private static final Object sLock = new Object();
    private static Thread sUIThread;
    private static Handler sUIHandler;
    private static List<UIEventHandler> sHandlers;

    public static void initialize() {
        sUIThread = Thread.currentThread();
        sUIHandler = new Handler();
        sHandlers = new LinkedList<UIEventHandler>();
    }

    public static boolean check() {
        Thread currentThread = Thread.currentThread();
        return currentThread == sUIThread;
    }

    public static void run(Runnable runnable) {
        if (UIThread.check()) {
            runnable.run();
        } else {
            sUIHandler.post(runnable);
        }
    }

    public static void run(Runnable runnable, long delayMillis) {
        sUIHandler.postDelayed(runnable, delayMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(UIEventHandler handler) {
        Object object = sLock;
        synchronized (object) {
            sHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(UIEventHandler handler) {
        Object object = sLock;
        synchronized (object) {
            sHandlers.remove(handler);
        }
    }

    public static void event(String event, Object data) {
        EventBroadcaster broadcaster = new EventBroadcaster(event, data);
        UIThread.run(broadcaster);
    }

    public static void event(String event) {
        UIThread.event(event, null);
    }

    private static class EventBroadcaster
    implements Runnable {
        private String event;
        private Object data;
        private List<UIEventHandler> handlers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EventBroadcaster(String s, Object o) {
            this.event = s;
            this.data = o;
            this.handlers = new LinkedList<UIEventHandler>();
            Object object = sLock;
            synchronized (object) {
                this.handlers.addAll(sHandlers);
            }
        }

        @Override
        public void run() {
            for (UIEventHandler handler : this.handlers) {
                handler.onEvent(this.event, this.data);
            }
        }
    }

    public static interface UIEventHandler {
        public void onEvent(String var1, Object var2);
    }
}

