/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import site.iway.androidhelpers.BitmapHelper;

public class TouchBlurView
extends View {
    private Bitmap mBitmap;
    private Canvas mCanvas;
    private Paint mPaintBlurred;
    private Path mPath;
    private float mLastTouchX;
    private float mLastTouchY;

    public TouchBlurView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public TouchBlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TouchBlurView(Context context) {
        super(context);
    }

    public void setBitmap(Bitmap bitmap, int blurRadius, int strokeWidth) {
        this.mBitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);
        this.mCanvas = new Canvas(this.mBitmap);
        this.mPaintBlurred = new Paint();
        Bitmap bitmapBlurred = BitmapHelper.blur(this.mBitmap, blurRadius);
        Shader.TileMode tileMode = Shader.TileMode.REPEAT;
        BitmapShader bitmapShader = new BitmapShader(bitmapBlurred, tileMode, tileMode);
        this.mPaintBlurred.setShader((Shader)bitmapShader);
        this.mPaintBlurred.setAntiAlias(true);
        this.mPaintBlurred.setDither(true);
        this.mPaintBlurred.setStyle(Paint.Style.STROKE);
        this.mPaintBlurred.setFilterBitmap(true);
        this.mPaintBlurred.setStrokeJoin(Paint.Join.ROUND);
        this.mPaintBlurred.setStrokeCap(Paint.Cap.ROUND);
        this.mPaintBlurred.setStrokeWidth((float)strokeWidth);
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        float currentTouchX = event.getX();
        float currentTouchY = event.getY();
        switch (event.getAction()) {
            case 0: {
                if (this.mPath == null) {
                    this.mPath = new Path();
                }
                this.mPath.reset();
                this.mPath.moveTo(event.getX(), event.getY());
                break;
            }
            case 2: {
                float dx = Math.abs(currentTouchX - this.mLastTouchX);
                float dy = Math.abs(currentTouchY - this.mLastTouchY);
                if (!(dx >= 4.0f) && !(dy >= 4.0f)) break;
                float x1 = this.mLastTouchX;
                float y1 = this.mLastTouchY;
                float x2 = (currentTouchX + this.mLastTouchX) / 2.0f;
                float y2 = (currentTouchY + this.mLastTouchY) / 2.0f;
                this.mPath.quadTo(x1, y1, x2, y2);
                break;
            }
            case 1: {
                this.mPath.lineTo(currentTouchX, currentTouchY);
            }
        }
        this.mCanvas.drawPath(this.mPath, this.mPaintBlurred);
        this.mLastTouchX = currentTouchX;
        this.mLastTouchY = currentTouchY;
        this.invalidate();
        return true;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
    }
}

