/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;

public class TouchAllLayout
extends FrameLayout {
    private boolean mSuperHandledTouchEvent;
    private int mChildCount;
    private boolean[] mTouchResults;
    private Rect mHitRect = new Rect();

    public TouchAllLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public TouchAllLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TouchAllLayout(Context context) {
        super(context);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    private boolean onSuperTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        } else if (this.mSuperHandledTouchEvent) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        }
        return this.mSuperHandledTouchEvent;
    }

    private boolean onChildTouchEvent(int childIndex, MotionEvent event) {
        View child = this.getChildAt(childIndex);
        int action = event.getAction();
        float offsetX = this.getScrollX() - child.getLeft();
        float offsetY = this.getScrollY() - child.getTop();
        float x = event.getX() + offsetX;
        float y = event.getY() + offsetY;
        child.getHitRect(this.mHitRect);
        if (this.mHitRect.contains((int)x, (int)y)) {
            event.offsetLocation(offsetX, offsetY);
            if (action == 0) {
                this.mTouchResults[childIndex] = child.dispatchTouchEvent(event);
            } else if (this.mTouchResults[childIndex]) {
                this.mTouchResults[childIndex] = child.dispatchTouchEvent(event);
            }
            event.offsetLocation(-offsetX, -offsetY);
        }
        return this.mTouchResults[childIndex];
    }

    private boolean onChildrenTouchEvents(MotionEvent event) {
        boolean hasChildHandled = false;
        for (int i = this.mChildCount - 1; i >= 0; --i) {
            hasChildHandled |= this.onChildTouchEvent(i, event);
        }
        return hasChildHandled;
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mChildCount = this.getChildCount();
            this.mTouchResults = new boolean[this.mChildCount];
            for (int i = 0; i < this.mChildCount; ++i) {
                this.mTouchResults[i] = false;
            }
        }
        return this.onSuperTouchEvent(event) || this.onChildrenTouchEvents(event);
    }
}

