/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.LinearLayout;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.ViewHelper;
import site.iway.javahelpers.MathHelper;

public class TabLayout
extends LinearLayout {
    public static final int ITEM_NONE = -1;
    private OnItemSelectedListener mOnItemSelectedListener;
    private boolean mContainSplitter;
    private int mSelectedItem = -1;
    private boolean mInvokeSelectOnTouchDown;
    private boolean mInvokeSelectOnTouchMove;
    private boolean mInvokeSelectOnTouchUp;
    private float mInvokeSelectOnTouchUpRange;
    private float mTouchDownX;
    private float mTouchDownY;
    private boolean mSuperHandledTouchEvent;

    public TabLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.resolveAttrs(context, attrs);
    }

    public TabLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public TabLayout(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabLayout);
        this.mContainSplitter = a.getBoolean(R.styleable.TabLayout_containSplitter, false);
        this.mInvokeSelectOnTouchDown = a.getBoolean(R.styleable.TabLayout_invokeSelectOnTouchDown, false);
        this.mInvokeSelectOnTouchMove = a.getBoolean(R.styleable.TabLayout_invokeSelectOnTouchMove, false);
        this.mInvokeSelectOnTouchUp = a.getBoolean(R.styleable.TabLayout_invokeSelectOnTouchUp, false);
        this.mInvokeSelectOnTouchUpRange = a.getDimension(R.styleable.TabLayout_invokeSelectOnTouchUpRange, Float.POSITIVE_INFINITY);
        a.recycle();
    }

    public void setOnItemSelectedListener(OnItemSelectedListener l) {
        this.mOnItemSelectedListener = l;
    }

    public boolean isContainSplitter() {
        return this.mContainSplitter;
    }

    public void setContainSplitter(boolean contains) {
        this.mContainSplitter = contains;
    }

    public int getSelectedItem() {
        return this.mSelectedItem;
    }

    private void setSelectedView(int index) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            childView.setSelected(i == index);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSelectedItem(int item, boolean invokeItemSelected) {
        if (item == this.mSelectedItem) {
            return;
        }
        int childCount = this.getChildCount();
        if (childCount == 0) {
            if (item != -1) throw new RuntimeException("The item " + item + " is not selectable");
            this.mSelectedItem = item;
            return;
        } else if (item == -1) {
            this.setSelectedView(-1);
            this.mSelectedItem = item;
            return;
        } else {
            int selectedViewIndex;
            int n = selectedViewIndex = this.mContainSplitter ? item * 2 : item * 1;
            if (selectedViewIndex >= childCount) {
                throw new RuntimeException("The item " + item + " is not selectable");
            }
            if (this.mOnItemSelectedListener == null) {
                this.setSelectedView(selectedViewIndex);
                this.mSelectedItem = item;
                return;
            } else {
                boolean result = this.mOnItemSelectedListener.onItemSelected(this, item);
                if (!result) return;
                this.setSelectedView(selectedViewIndex);
                this.mSelectedItem = item;
            }
        }
    }

    public void setSelectedItem(int item) {
        this.setSelectedItem(item, true);
    }

    public boolean isInvokeSelectOnTouchDown() {
        return this.mInvokeSelectOnTouchDown;
    }

    public void setInvokeSelectOnTouchDown(boolean value) {
        this.mInvokeSelectOnTouchDown = value;
    }

    public boolean isInvokeSelectOnTouchMove() {
        return this.mInvokeSelectOnTouchMove;
    }

    public void setInvokeSelectOnTouchMove(boolean value) {
        this.mInvokeSelectOnTouchMove = value;
    }

    public boolean isInvokeSelectOnTouchUp() {
        return this.mInvokeSelectOnTouchUp;
    }

    public void setInvokeSelectOnTouchUp(boolean value, float range) {
        this.mInvokeSelectOnTouchUp = value;
        this.mInvokeSelectOnTouchUpRange = range;
    }

    public void setInvokeSelectOnTouchUp(boolean value) {
        this.mInvokeSelectOnTouchUp = value;
        this.mInvokeSelectOnTouchUpRange = Float.POSITIVE_INFINITY;
    }

    private void invokeSelection(MotionEvent ev) {
        if (this.mContainSplitter) {
            for (int i = 0; i < this.getChildCount(); i += 2) {
                if (!this.getChildAt(i).isEnabled() || !ViewHelper.isMotionEventInView(ev, this.getChildAt(i))) continue;
                this.setSelectedItem(i / 2);
                break;
            }
        } else {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (!this.getChildAt(i).isEnabled() || !ViewHelper.isMotionEventInView(ev, this.getChildAt(i))) continue;
                this.setSelectedItem(i);
                break;
            }
        }
    }

    private void handleSuperTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        } else if (this.mSuperHandledTouchEvent) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        this.handleSuperTouchEvent(ev);
        switch (ev.getAction()) {
            case 0: {
                this.mTouchDownX = ev.getRawX();
                this.mTouchDownY = ev.getRawY();
                if (!this.mInvokeSelectOnTouchDown) break;
                this.invokeSelection(ev);
                break;
            }
            case 2: {
                if (!this.mInvokeSelectOnTouchMove) break;
                this.invokeSelection(ev);
                break;
            }
            case 1: 
            case 3: {
                float dy;
                float dx;
                double dxy;
                if (!this.mInvokeSelectOnTouchUp || !((dxy = MathHelper.distance((double)(dx = ev.getRawX() - this.mTouchDownX), (double)(dy = ev.getRawY() - this.mTouchDownY))) < (double)this.mInvokeSelectOnTouchUpRange)) break;
                this.invokeSelection(ev);
            }
        }
        return true;
    }

    public static interface OnItemSelectedListener {
        public boolean onItemSelected(TabLayout var1, int var2);
    }
}

