/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.UITimer;

public class SlideIndicator
extends View {
    private float mLeftPositionOffset;
    private float mRightPositionOffset;
    private Drawable mIndicatorDrawable;
    private Interpolator mInterpolator;
    private boolean mIndicatorPositionSet;
    private int mIndicatorLeft = 0;
    private int mIndicatorRight = 0;
    private long mAnimationStartTime;
    private float mSourceIndicatorLeft;
    private float mSourceIndicatorRight;
    private float mTargetIndicatorLeft;
    private float mTargetIndicatorRight;
    private UITimer mAnimator = new UITimer(){
        private float mDuration = 300.0f;

        @Override
        public void doOnUIThread() {
            float rightChange;
            long timeSpan = System.currentTimeMillis() - SlideIndicator.this.mAnimationStartTime;
            float fraction = SlideIndicator.this.mInterpolator.getInterpolation((float)timeSpan / this.mDuration);
            int leftOffset = (int)(fraction * (SlideIndicator.this.mTargetIndicatorLeft - SlideIndicator.this.mSourceIndicatorLeft));
            int rightOffset = (int)(fraction * (SlideIndicator.this.mTargetIndicatorRight - SlideIndicator.this.mSourceIndicatorRight));
            SlideIndicator.this.mIndicatorLeft = (int)(SlideIndicator.this.mSourceIndicatorLeft + (float)leftOffset);
            SlideIndicator.this.mIndicatorRight = (int)(SlideIndicator.this.mSourceIndicatorRight + (float)rightOffset);
            boolean shouldStop = false;
            float leftChange = Math.abs((float)SlideIndicator.this.mIndicatorLeft - SlideIndicator.this.mSourceIndicatorLeft);
            if (leftChange >= Math.abs(SlideIndicator.this.mTargetIndicatorLeft - SlideIndicator.this.mSourceIndicatorLeft)) {
                shouldStop = true;
            }
            if ((rightChange = Math.abs((float)SlideIndicator.this.mIndicatorRight - SlideIndicator.this.mSourceIndicatorRight)) >= Math.abs(SlideIndicator.this.mTargetIndicatorRight - SlideIndicator.this.mSourceIndicatorRight)) {
                shouldStop = true;
            }
            if (shouldStop) {
                SlideIndicator.this.mIndicatorLeft = (int)SlideIndicator.this.mTargetIndicatorLeft;
                SlideIndicator.this.mIndicatorRight = (int)SlideIndicator.this.mTargetIndicatorRight;
                this.stop();
            }
            SlideIndicator.this.invalidate();
        }
    };

    public SlideIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.resolveAttrs(context, attrs);
    }

    public SlideIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public SlideIndicator(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    public Drawable getIndicatorDrawable() {
        return this.mIndicatorDrawable;
    }

    public void setIndicatorDrawable(Drawable drawable2) {
        this.mIndicatorDrawable = drawable2;
    }

    public void setIndicatorDrawableResource(int resourceId) {
        this.mIndicatorDrawable = this.getContext().getResources().getDrawable(resourceId);
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SlideIndicator);
        this.mIndicatorDrawable = a.getDrawable(R.styleable.SlideIndicator_indicatorDrawable);
        int interpolator = a.getResourceId(R.styleable.SlideIndicator_interpolator, 0);
        this.mInterpolator = interpolator == 0 ? new LinearInterpolator() : AnimationUtils.loadInterpolator((Context)context, (int)interpolator);
        this.mLeftPositionOffset = a.getFloat(R.styleable.SlideIndicator_leftPositionOffset, 0.0f);
        this.mRightPositionOffset = a.getFloat(R.styleable.SlideIndicator_rightPositionOffset, 0.0f);
        a.recycle();
    }

    public void setIndicatorTo(int left, int right, boolean animated) {
        this.mIndicatorPositionSet = true;
        this.mAnimator.stop();
        if (animated) {
            this.mAnimationStartTime = System.currentTimeMillis();
            this.mSourceIndicatorLeft = this.mIndicatorLeft;
            this.mSourceIndicatorRight = this.mIndicatorRight;
            this.mTargetIndicatorLeft = left;
            this.mTargetIndicatorRight = right;
            this.mAnimator.start(true);
        } else {
            this.mSourceIndicatorLeft = left;
            this.mSourceIndicatorRight = right;
            this.mTargetIndicatorLeft = left;
            this.mTargetIndicatorRight = right;
            this.mIndicatorLeft = left;
            this.mIndicatorRight = right;
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mIndicatorDrawable == null) {
            return;
        }
        if (this.mIndicatorPositionSet) {
            this.mIndicatorDrawable.setBounds(this.mIndicatorLeft, 0, this.mIndicatorRight, this.getHeight());
            this.mIndicatorDrawable.draw(canvas);
        } else {
            int width = this.getWidth();
            int left = (int)((float)width * this.mLeftPositionOffset);
            int right = (int)((float)width * this.mRightPositionOffset);
            this.mIndicatorDrawable.setBounds(left, 0, right, this.getHeight());
            this.mIndicatorDrawable.draw(canvas);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAnimator.start(true);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAnimator.stop();
    }
}

