/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.UnitHelper;

public class ScratchCard
extends View {
    private Drawable mDrawable;
    private float mScratchWidth;
    private Bitmap mBitmap;
    private Canvas mCanvas;
    private Path mPath;
    private Paint mInnerPaint;
    private Paint mOuterPaint;
    private OnScratchListener mListener;
    private float mLastTouchX;
    private float mLastTouchY;

    public ScratchCard(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.resolveAttr(context, attrs);
    }

    public ScratchCard(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttr(context, attrs);
    }

    public ScratchCard(Context context) {
        super(context);
        this.resolveAttr(context, null);
    }

    private void resolveAttr(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ScratchCard);
        this.mDrawable = a.getDrawable(R.styleable.ScratchCard_scratchDrawable);
        this.mScratchWidth = a.getDimension(R.styleable.ScratchCard_scratchWidth, UnitHelper.dipToPx(context, 20.0f));
        a.recycle();
    }

    public void setScratchDrawable(Drawable drawable2) {
        this.mDrawable = drawable2;
    }

    public void setScratchWidth(float width) {
        this.mScratchWidth = width;
    }

    public void setOnScratchListener(OnScratchListener listener) {
        this.mListener = listener;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
        }
        this.mBitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCanvas = new Canvas(this.mBitmap);
        if (this.mDrawable != null) {
            this.mDrawable.setBounds(0, 0, this.mBitmap.getWidth(), this.mBitmap.getHeight());
            this.mDrawable.draw(this.mCanvas);
        } else {
            this.mCanvas.drawColor(-4144960);
        }
        if (this.mPath == null) {
            this.mPath = new Path();
        }
        if (this.mInnerPaint == null) {
            this.mInnerPaint = new Paint();
            this.mInnerPaint.setAntiAlias(true);
            this.mInnerPaint.setDither(true);
            this.mInnerPaint.setStyle(Paint.Style.STROKE);
            this.mInnerPaint.setFilterBitmap(true);
            this.mInnerPaint.setStrokeJoin(Paint.Join.ROUND);
            this.mInnerPaint.setStrokeCap(Paint.Cap.ROUND);
            this.mInnerPaint.setStrokeWidth(this.mScratchWidth);
            this.mInnerPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        }
        if (this.mOuterPaint == null) {
            this.mOuterPaint = new Paint();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        float currentTouchX = event.getX();
        float currentTouchY = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.mPath.reset();
                this.mPath.moveTo(event.getX(), event.getY());
                break;
            }
            case 2: {
                float dx = Math.abs(currentTouchX - this.mLastTouchX);
                float dy = Math.abs(currentTouchY - this.mLastTouchY);
                if (!(dx >= 4.0f) && !(dy >= 4.0f)) break;
                float x1 = this.mLastTouchX;
                float y1 = this.mLastTouchY;
                float x2 = (currentTouchX + this.mLastTouchX) / 2.0f;
                float y2 = (currentTouchY + this.mLastTouchY) / 2.0f;
                this.mPath.quadTo(x1, y1, x2, y2);
                break;
            }
            case 1: {
                this.mPath.lineTo(currentTouchX, currentTouchY);
                if (this.mListener == null) break;
                int width = this.mBitmap.getWidth();
                int height = this.mBitmap.getHeight();
                int total = width * height;
                int count = 0;
                for (int i = 0; i < width; i += 3) {
                    for (int j = 0; j < height; j += 3) {
                        if (this.mBitmap.getPixel(i, j) != 0) continue;
                        ++count;
                    }
                }
                this.mListener.onScratch(this, (float)count / (float)total * 9.0f);
            }
        }
        this.mCanvas.drawPath(this.mPath, this.mInnerPaint);
        this.mLastTouchX = currentTouchX;
        this.mLastTouchY = currentTouchY;
        this.invalidate();
        return true;
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, this.mOuterPaint);
        super.onDraw(canvas);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }

    public static interface OnScratchListener {
        public void onScratch(ScratchCard var1, float var2);
    }
}

