/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;

public class SMSTraverser {
    private Context mContext;
    private ContentResolver mContentResolver;
    private Uri mUri;
    private String[] mQueryContent;
    private OnSMSReadListener mOnSMSReadListener;

    public SMSTraverser(Context context) {
        this.mContext = context;
        this.mContentResolver = this.mContext.getContentResolver();
        this.mUri = Uri.parse((String)"content://sms/inbox");
        this.mQueryContent = new String[]{"_id", "address", "body"};
    }

    public void setOnSMSReadListener(OnSMSReadListener l) {
        this.mOnSMSReadListener = l;
    }

    public void doTraverse() {
        Cursor cursor = this.mContentResolver.query(this.mUri, this.mQueryContent, null, null, null);
        if (cursor != null) {
            cursor.moveToFirst();
            if (cursor.moveToFirst()) {
                String address = cursor.getString(cursor.getColumnIndex("address"));
                String body = cursor.getString(cursor.getColumnIndex("body"));
                if (this.mOnSMSReadListener != null) {
                    this.mOnSMSReadListener.onSMSRead(address, body);
                }
            }
        }
    }

    public static interface OnSMSReadListener {
        public void onSMSRead(String var1, String var2);
    }
}

