/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.List;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.ViewHelper;

public class RatingBar
extends LinearLayout {
    private int mCount;
    private int mResChecked;
    private int mResUnchecked;
    private int mPoint;
    private boolean mPointByTouch;
    private boolean mSuperHandledTouchEvent;

    public RatingBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.resolveAttrs(context, attrs);
    }

    public RatingBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public RatingBar(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    private List<View> copyChildViews() {
        ArrayList<View> copiedChildViews = new ArrayList<View>();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            copiedChildViews.add(this.getChildAt(i));
        }
        return copiedChildViews;
    }

    private void update() {
        List<View> copiedChildViews = this.copyChildViews();
        this.removeAllViews();
        if (this.mCount <= 0) {
            return;
        }
        for (int i = 0; i < this.mCount; ++i) {
            ImageView imageView;
            if (i < copiedChildViews.size()) {
                imageView = (ImageView)copiedChildViews.get(i);
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -1);
                params.weight = 1.0f;
                this.addView((View)imageView, (ViewGroup.LayoutParams)params);
            } else {
                Context context = this.getContext();
                ImageView imageView2 = new ImageView(context);
                imageView2.setScaleType(ImageView.ScaleType.FIT_CENTER);
                LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -1);
                params.weight = 1.0f;
                this.addView((View)imageView2, (ViewGroup.LayoutParams)params);
            }
            imageView = (ImageView)this.getChildAt(i);
            if (i < this.mPoint) {
                imageView.setImageResource(this.mResChecked);
                continue;
            }
            imageView.setImageResource(this.mResUnchecked);
        }
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RatingBar);
        this.mCount = a.getInt(R.styleable.RatingBar_count, 5);
        this.mResChecked = a.getResourceId(R.styleable.RatingBar_resChecked, R.drawable.star_fill);
        this.mResUnchecked = a.getResourceId(R.styleable.RatingBar_resUnchecked, R.drawable.star_empty);
        this.mPoint = a.getInt(R.styleable.RatingBar_point, 0);
        this.mPointByTouch = a.getBoolean(R.styleable.RatingBar_pointByTouch, false);
        this.update();
        a.recycle();
    }

    public void setCount(int count) {
        this.mCount = count;
        this.update();
    }

    public void setResChecked(int resChecked) {
        this.mResChecked = resChecked;
        this.update();
    }

    public void setResUnchecked(int resUnchecked) {
        this.mCount = resUnchecked;
        this.update();
    }

    public void setPoint(int point) {
        this.mPoint = point;
        this.update();
    }

    private boolean onSuperTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        } else if (this.mSuperHandledTouchEvent) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        }
        return this.mSuperHandledTouchEvent;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result;
        boolean bl = result = this.onSuperTouchEvent(event) || this.mPointByTouch;
        if (this.mPointByTouch && event.getAction() == 1) {
            int childCount = this.getChildCount();
            for (int childIndex = childCount - 1; childIndex >= 0; --childIndex) {
                View child = this.getChildAt(childIndex);
                boolean hitView = ViewHelper.isMotionEventInView(event, child);
                if (!hitView) continue;
                this.setPoint(childIndex + 1);
            }
        }
        return result;
    }
}

