/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.os.Handler;
import android.os.Looper;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.LinkedBlockingQueue;
import site.iway.androidhelpers.RPCInfo;
import site.iway.androidhelpers.RPCListener;
import site.iway.javahelpers.StreamReader;

@Deprecated
public abstract class RPCInfoManager {
    private LinkedBlockingQueue<RPCInfo> mRPCInfosOrdered;
    private LinkedBlockingQueue<RPCInfo> mRPCInfos;
    private RPCInfoProcessor[] mProcessors;
    protected Handler mHandler;

    public RPCInfoManager(int processorCount) {
        if (processorCount <= 0) {
            throw new RuntimeException("processorCount must be larger than zero.");
        }
        this.mRPCInfosOrdered = new LinkedBlockingQueue();
        this.mRPCInfos = new LinkedBlockingQueue();
        this.mProcessors = new RPCInfoProcessor[processorCount];
        for (int i = 0; i < processorCount; ++i) {
            this.mProcessors[i] = new RPCInfoProcessor(i == 0);
            this.mProcessors[i].start();
        }
    }

    public RPCInfoManager() {
        this(2);
    }

    public RPCInfo addRequest(RPCInfo rpcInfo) {
        if (rpcInfo.listener == null) {
            rpcInfo.listener = new RPCListener(){

                @Override
                public void onRequestOK(RPCInfo rpcInfo, Object response) {
                }

                @Override
                public void onRequestER(RPCInfo rpcInfo, Exception e) {
                }
            };
        }
        if (this.mProcessors.length > 1) {
            if (rpcInfo.ordered) {
                return this.mRPCInfosOrdered.add(rpcInfo) ? rpcInfo : null;
            }
            if (this.mRPCInfosOrdered.size() < this.mRPCInfos.size() / (this.mProcessors.length - 1)) {
                return this.mRPCInfosOrdered.add(rpcInfo) ? rpcInfo : null;
            }
            return this.mRPCInfos.add(rpcInfo) ? rpcInfo : null;
        }
        return this.mRPCInfosOrdered.add(rpcInfo) ? rpcInfo : null;
    }

    protected void checkHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
    }

    protected void postRunnable(Runnable runnable, long beginTime, long minDelayTime) {
        if (minDelayTime <= 0L) {
            this.mHandler.post(runnable);
        } else {
            long delayTime = System.currentTimeMillis() - beginTime;
            if (delayTime >= minDelayTime) {
                this.mHandler.post(runnable);
            } else {
                this.mHandler.postDelayed(runnable, minDelayTime - delayTime);
            }
        }
    }

    protected boolean beforeOKOnUIThread(RPCInfo rpcInfo, Object response) {
        return true;
    }

    protected void afterOKOnUIThread(RPCInfo rpcInfo, Object response) {
    }

    protected void handleOKOnUIThread(final RPCInfo rpcInfo, final Object response) {
        this.checkHandler();
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                if (!rpcInfo.isCanceled && RPCInfoManager.this.beforeOKOnUIThread(rpcInfo, response)) {
                    RPCListener rpcListener = rpcInfo.getListener();
                    rpcListener.onRequestOK(rpcInfo, response);
                    RPCInfoManager.this.afterOKOnUIThread(rpcInfo, response);
                }
            }
        }, rpcInfo.beginTime, rpcInfo.minDelayTime);
    }

    protected boolean beforeErrorOnUIThread(RPCInfo rpcInfo, Exception error) {
        return true;
    }

    protected void afterErrorOnUIThread(RPCInfo rpcInfo, Exception error) {
    }

    protected void handleErrorOnUIThread(final RPCInfo rpcInfo, final Exception error) {
        this.checkHandler();
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                if (!rpcInfo.isCanceled && RPCInfoManager.this.beforeErrorOnUIThread(rpcInfo, error)) {
                    RPCListener rpcListener = rpcInfo.getListener();
                    rpcListener.onRequestER(rpcInfo, error);
                    RPCInfoManager.this.afterErrorOnUIThread(rpcInfo, error);
                }
            }
        }, rpcInfo.beginTime, rpcInfo.minDelayTime);
    }

    protected void onRPCInfoTaken(RPCInfo rpcInfo) throws Exception {
    }

    protected abstract void onUrlConnectionOpened(RPCInfo var1, HttpURLConnection var2) throws Exception;

    protected void onUrlConnectionEstablished(RPCInfo rpcInfo, HttpURLConnection connection) throws Exception {
    }

    protected abstract void sendData(RPCInfo var1, HttpURLConnection var2, OutputStream var3) throws Exception;

    protected abstract void onGetData(RPCInfo var1, byte[] var2) throws Exception;

    protected abstract void onGetError(RPCInfo var1, Exception var2);

    private class RPCInfoProcessor
    extends Thread {
        private boolean mOrdered;

        public RPCInfoProcessor(boolean ordered) {
            this.mOrdered = ordered;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                RPCInfo rpcInfo = null;
                OutputStream outputStream = null;
                InputStream inputStream = null;
                try {
                    rpcInfo = this.mOrdered ? (RPCInfo)RPCInfoManager.this.mRPCInfosOrdered.take() : (RPCInfo)RPCInfoManager.this.mRPCInfos.take();
                    rpcInfo.beginTime = System.currentTimeMillis();
                    if (rpcInfo.isCanceled) continue;
                    RPCInfoManager.this.onRPCInfoTaken(rpcInfo);
                    URL url = new URL(rpcInfo.url);
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout(rpcInfo.getConnectTimeout());
                    connection.setReadTimeout(rpcInfo.getReadTimeout());
                    if (rpcInfo.isCanceled) continue;
                    RPCInfoManager.this.onUrlConnectionOpened(rpcInfo, connection);
                    connection.connect();
                    if (rpcInfo.isCanceled) continue;
                    RPCInfoManager.this.onUrlConnectionEstablished(rpcInfo, connection);
                    if (connection.getDoOutput()) {
                        outputStream = connection.getOutputStream();
                        if (rpcInfo.isCanceled) continue;
                        RPCInfoManager.this.sendData(rpcInfo, connection, outputStream);
                    }
                    if (!connection.getDoInput()) continue;
                    inputStream = connection.getInputStream();
                    byte[] data = StreamReader.readAllBytes((InputStream)inputStream);
                    if (rpcInfo.isCanceled) continue;
                    RPCInfoManager.this.onGetData(rpcInfo, data);
                    continue;
                }
                catch (Exception e) {
                    if (rpcInfo == null || rpcInfo.isCanceled) continue;
                    RPCInfoManager.this.onGetError(rpcInfo, e);
                    continue;
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {}
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
        }
    }
}

