/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.os.Handler;
import android.os.Looper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import site.iway.androidhelpers.RPCReq;

public class RPCEngine {
    private ExecutorService mExecutorService;
    private Handler mHandler;
    private static RPCEngine sEngine;

    public RPCEngine(int processorCount) {
        if (processorCount <= 0) {
            throw new RuntimeException("ProcessorCount must be larger than zero.");
        }
        this.mExecutorService = Executors.newFixedThreadPool(processorCount);
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    private void addReq(RPCReq req) {
        ReqProcessor reqProcessor = new ReqProcessor(req);
        if (req.independent) {
            Thread thread = new Thread(reqProcessor);
            thread.start();
        } else {
            this.mExecutorService.execute(reqProcessor);
        }
    }

    private void postRunnable(Runnable runnable, long beginTime, long minDelayTime) {
        if (minDelayTime <= 0L) {
            this.mHandler.post(runnable);
        } else {
            long delayTime = System.currentTimeMillis() - beginTime;
            if (delayTime >= minDelayTime) {
                this.mHandler.post(runnable);
            } else {
                this.mHandler.postDelayed(runnable, minDelayTime - delayTime);
            }
        }
    }

    private void finishOnUIThread(final RPCReq req) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                if (!req.isCanceled) {
                    req.onFinishUI();
                }
            }
        }, req.beginTime, req.minDelayTime);
    }

    private void errorOnUIThread(final RPCReq req) {
        this.postRunnable(new Runnable(){

            @Override
            public void run() {
                if (!req.isCanceled) {
                    req.onErrorUI();
                }
            }
        }, req.beginTime, req.minDelayTime);
    }

    public static void initialize(int processorCount) {
        sEngine = new RPCEngine(processorCount);
    }

    static void dealWith(RPCReq req) {
        sEngine.addReq(req);
    }

    static /* synthetic */ void access$000(RPCEngine x0, RPCReq x1) {
        x0.finishOnUIThread(x1);
    }

    static /* synthetic */ void access$100(RPCEngine x0, RPCReq x1) {
        x0.errorOnUIThread(x1);
    }

    private class ReqProcessor
    implements Runnable {
        private RPCReq mReq;

        public ReqProcessor(RPCReq req) {
            this.mReq = req;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 41[DOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

