/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import site.iway.androidhelpers.PullRefreshHeader;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.UITimer;
import site.iway.androidhelpers.UnitHelper;
import site.iway.androidhelpers.ViewHelper;
import site.iway.javahelpers.MathHelper;

public class PullRefreshLayout
extends ViewGroup {
    private int mHeaderViewIdFromAttr;
    private int mContentViewIdFromAttr;
    private View mHeaderView;
    private View mContentView;
    private OnRefreshListener mOnRefreshListener;
    private boolean mIsRefreshing;
    private float mCurrentPullOffset = 0.0f;
    private float mTargetPullOffset = 0.0f;
    private boolean mAnimatingToTarget = false;
    private UITimer mAnimator = new UITimer(){

        @Override
        public void doOnUIThread() {
            float change = (PullRefreshLayout.this.mTargetPullOffset - PullRefreshLayout.this.mCurrentPullOffset) * 0.15f;
            if (Math.abs(change) < 1.0f) {
                PullRefreshLayout.this.mCurrentPullOffset = PullRefreshLayout.this.mTargetPullOffset;
                PullRefreshLayout.this.setPullOffset((int)PullRefreshLayout.this.mCurrentPullOffset);
                this.stop();
                PullRefreshLayout.this.mAnimatingToTarget = false;
            } else {
                PullRefreshLayout.this.mCurrentPullOffset = PullRefreshLayout.this.mCurrentPullOffset + change;
                PullRefreshLayout.this.setPullOffset((int)PullRefreshLayout.this.mCurrentPullOffset);
            }
        }
    };
    private float mSavedTouchEventXAxis;
    private float mSavedTouchEventYAxis;
    private float mDragStartYAxis;
    private boolean mSuperHandledTouchEvent;

    public PullRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.resolveAttrs(context, attrs);
    }

    public PullRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public PullRefreshLayout(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PullRefreshLayout);
        this.mHeaderViewIdFromAttr = a.getResourceId(R.styleable.PullRefreshLayout_headerViewId, 0);
        this.mContentViewIdFromAttr = a.getResourceId(R.styleable.PullRefreshLayout_contentViewId, 0);
        a.recycle();
    }

    public void setHeaderView(View view) {
        if (ViewHelper.isChildView(this, view)) {
            this.mHeaderView = view;
        }
    }

    public void setHeaderViewId(int id2) {
        this.mHeaderView = ViewHelper.findChildViewById(this, id2);
    }

    public void setContentView(View view) {
        if (ViewHelper.isChildView(this, view)) {
            this.mContentView = view;
        }
    }

    public void setContentViewId(int id2) {
        this.mContentView = ViewHelper.findChildViewById(this, id2);
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        int childViewId = child.getId();
        if (childViewId == this.mHeaderViewIdFromAttr) {
            this.mHeaderView = child;
        }
        if (childViewId == this.mContentViewIdFromAttr) {
            this.mContentView = child;
        }
    }

    public void setOnRefreshListener(OnRefreshListener l) {
        this.mOnRefreshListener = l;
    }

    public boolean isRefreshing() {
        return this.mIsRefreshing;
    }

    public void setRefreshing(boolean refreshing) {
        PullRefreshHeader pullRefreshHeader = (PullRefreshHeader)this.mHeaderView;
        int pullRefreshHeaderMainHeight = pullRefreshHeader.getMainHeight();
        if (refreshing) {
            pullRefreshHeader.setRefreshing(true);
            if (this.mOnRefreshListener != null && !this.mIsRefreshing) {
                this.mIsRefreshing = true;
                this.mOnRefreshListener.onRefresh(this);
            } else {
                this.mIsRefreshing = true;
            }
            this.animatePullOffsetTo(pullRefreshHeaderMainHeight);
        } else {
            pullRefreshHeader.setRefreshing(false);
            this.mIsRefreshing = false;
            this.animatePullOffsetTo(0);
        }
    }

    private void setPullOffset(int offset) {
        if (offset < 0) {
            offset = 0;
        }
        this.setScrollY(-offset);
    }

    private int getPullOffset() {
        return -this.getScrollY();
    }

    private void animatePullOffsetTo(int pullOffset) {
        this.mCurrentPullOffset = this.getPullOffset();
        this.mTargetPullOffset = pullOffset;
        this.mAnimatingToTarget = true;
        this.mAnimator.start(false);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mIsRefreshing || this.mAnimatingToTarget) {
            return true;
        }
        int action = ev.getAction();
        switch (action) {
            case 0: {
                this.mSavedTouchEventXAxis = ev.getX();
                this.mSavedTouchEventYAxis = ev.getY();
                break;
            }
            case 2: {
                Context context = this.getContext();
                float touchEventXAxis = ev.getX();
                float touchEventYAxis = ev.getY();
                float detectRange = UnitHelper.dipToPx(context, 10.0f);
                boolean isPullHorizontal = Math.abs(touchEventXAxis - this.mSavedTouchEventXAxis) > detectRange;
                boolean isPullVertical = touchEventYAxis - this.mSavedTouchEventYAxis > detectRange;
                boolean canContentViewPull = this.mContentView.canScrollVertically(-1);
                if (isPullHorizontal || !isPullVertical || canContentViewPull) break;
                this.mDragStartYAxis = ev.getY();
                return true;
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    private void handleSuperTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        } else if (this.mSuperHandledTouchEvent) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mIsRefreshing || this.mAnimatingToTarget) {
            return true;
        }
        this.handleSuperTouchEvent(event);
        PullRefreshHeader pullRefreshHeader = (PullRefreshHeader)this.mHeaderView;
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.mDragStartYAxis = event.getY();
                break;
            }
            case 2: {
                float offset = event.getY() - this.mDragStartYAxis;
                int pullOffset = MathHelper.pixel((double)((double)offset * 0.5));
                this.setPullOffset(pullOffset);
                pullRefreshHeader.updateContent(pullOffset);
                break;
            }
            case 1: 
            case 3: {
                int pullRefreshHeaderMainHeight = pullRefreshHeader.getMainHeight();
                int currentPullOffset = this.getPullOffset();
                this.setRefreshing(currentPullOffset > pullRefreshHeaderMainHeight);
            }
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        RuntimeException runtimeException = new RuntimeException("HeaderView or ContentView not set !");
        if (this.mHeaderView == null || this.mContentView == null) {
            if (this.mHeaderViewIdFromAttr > 0 && this.mContentViewIdFromAttr > 0) {
                this.setHeaderViewId(this.mHeaderViewIdFromAttr);
                this.setContentViewId(this.mContentViewIdFromAttr);
                if (this.mHeaderView == null || this.mContentView == null) {
                    throw runtimeException;
                }
            } else {
                throw runtimeException;
            }
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            int bottom;
            int right;
            int top;
            int left;
            View child = this.getChildAt(i);
            if (child == this.mHeaderView) {
                left = 0;
                top = -child.getMeasuredHeight();
                right = left + child.getMeasuredWidth();
                bottom = top + child.getMeasuredHeight();
                child.layout(left, top, right, bottom);
                continue;
            }
            left = 0;
            top = 0;
            right = left + child.getMeasuredWidth();
            bottom = top + child.getMeasuredHeight();
            child.layout(left, top, right, bottom);
        }
    }

    public static interface OnRefreshListener {
        public void onRefresh(PullRefreshLayout var1);
    }
}

