/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.UITimer;

public class PullRefreshHeader
extends FrameLayout {
    private LinearLayout mMainView;
    private ImageView mImageView;
    private TextView mTextView;
    private int mLastPullOffset;
    private boolean mRefreshing;
    private UITimer mRotatePlayer;

    public PullRefreshHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.onInitViews(context);
    }

    public PullRefreshHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.onInitViews(context);
    }

    public PullRefreshHeader(Context context) {
        super(context);
        this.onInitViews(context);
    }

    public void onInitViews(Context context) {
        PullRefreshHeader.inflate((Context)context, (int)R.layout.pull_refresh_header, (ViewGroup)this);
        this.mMainView = (LinearLayout)this.findViewById(R.id.mainView);
        this.mImageView = (ImageView)this.findViewById(R.id.imageView);
        this.mTextView = (TextView)this.findViewById(R.id.textView);
        this.mTextView.setText(R.string.pull_to_refresh);
    }

    public int getMainHeight() {
        return this.mMainView.getHeight();
    }

    public void updateContent(int pullOffset) {
        if (this.mRefreshing) {
            if (this.mRotatePlayer == null) {
                this.mRotatePlayer = new UITimer(100L){

                    @Override
                    public void doOnUIThread() {
                        float rotation = PullRefreshHeader.this.mImageView.getRotation();
                        PullRefreshHeader.this.mImageView.setRotation(rotation += 30.0f);
                    }
                };
                this.mRotatePlayer.start(false);
            }
            this.mTextView.setText(R.string.refreshing);
        } else {
            if (this.mRotatePlayer != null) {
                this.mRotatePlayer.stop();
                this.mRotatePlayer = null;
            }
            this.mImageView.setRotation((float)(-pullOffset / 10 * 30));
            int mainHeight = this.getMainHeight();
            if (pullOffset > mainHeight) {
                this.mTextView.setText(R.string.release_can_refresh);
            } else {
                this.mTextView.setText(R.string.pull_to_refresh);
            }
        }
        this.mLastPullOffset = pullOffset;
    }

    public void setRefreshing(boolean refreshing) {
        this.mRefreshing = refreshing;
        this.updateContent(this.mLastPullOffset);
    }
}

