/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import site.iway.androidhelpers.ImageViewer;
import site.iway.androidhelpers.ViewHelper;
import site.iway.javahelpers.BooleanComparable;

public abstract class PhotoAlbum
extends ViewPager {
    private BooleanComparable<View> mViewComparable = new BooleanComparable<View>(){

        public boolean compareTo(View another) {
            if (!(another instanceof ImageViewer)) {
                return false;
            }
            return PhotoAlbum.this.isImageViewerInPosition((ImageViewer)another, PhotoAlbum.this.getCurrentItem());
        }
    };
    private BooleanComparable<View> mViewComparableLeft = new BooleanComparable<View>(){

        public boolean compareTo(View another) {
            if (!(another instanceof ImageViewer)) {
                return false;
            }
            return PhotoAlbum.this.isImageViewerInPosition((ImageViewer)another, PhotoAlbum.this.getCurrentItem() - 1);
        }
    };
    private BooleanComparable<View> mViewComparableRight = new BooleanComparable<View>(){

        public boolean compareTo(View another) {
            if (!(another instanceof ImageViewer)) {
                return false;
            }
            return PhotoAlbum.this.isImageViewerInPosition((ImageViewer)another, PhotoAlbum.this.getCurrentItem() + 1);
        }
    };
    private ImageViewer mImageViewer;
    private float mTouchDownX;
    private boolean mShouldHandleSelfDefined;
    private boolean mShouldHandleSelf;

    public PhotoAlbum(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PhotoAlbum(Context context) {
        super(context);
    }

    protected abstract boolean isImageViewerInPosition(ImageViewer var1, int var2);

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    private void resetLeftOrRightImageViewer() {
        ImageViewer imageViewer = (ImageViewer)ViewHelper.findViewByComparable((ViewGroup)this, this.mViewComparableLeft);
        if (imageViewer != null) {
            imageViewer.resetImageState();
        }
        if ((imageViewer = (ImageViewer)ViewHelper.findViewByComparable((ViewGroup)this, this.mViewComparableRight)) != null) {
            imageViewer.resetImageState();
        }
    }

    private View findChildView(View view) {
        if (view.getParent() == this) {
            return view;
        }
        return this.findChildView((View)view.getParent());
    }

    private int findImageViewerLeft(ImageViewer imageViewer) {
        View view = this.findChildView(imageViewer);
        return view.getLeft();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mImageViewer = (ImageViewer)ViewHelper.findViewByComparable((ViewGroup)this, this.mViewComparable);
                this.mTouchDownX = ev.getX();
                if (this.mImageViewer == null) {
                    this.mShouldHandleSelfDefined = true;
                    this.mShouldHandleSelf = true;
                    break;
                }
                if (this.getScrollX() - this.findImageViewerLeft(this.mImageViewer) != 0) {
                    this.mShouldHandleSelfDefined = true;
                    this.mShouldHandleSelf = true;
                    break;
                }
                this.mShouldHandleSelfDefined = false;
                this.mShouldHandleSelf = true;
                break;
            }
            case 2: {
                if (this.mShouldHandleSelfDefined) break;
                if (ev.getPointerCount() > 1) {
                    this.mShouldHandleSelfDefined = true;
                    this.mShouldHandleSelf = false;
                    break;
                }
                float xChange = ev.getX() - this.mTouchDownX;
                if (!(Math.abs(xChange) >= 5.0f)) break;
                if (xChange > 0.0f && this.mImageViewer.getBitmap() != null && (double)this.mImageViewer.getImageLeftPadding() < -0.5) {
                    this.mShouldHandleSelfDefined = true;
                    this.mShouldHandleSelf = false;
                }
                if (xChange < 0.0f && this.mImageViewer.getBitmap() != null && (double)this.mImageViewer.getImageRightPadding() < -0.5) {
                    this.mShouldHandleSelfDefined = true;
                    this.mShouldHandleSelf = false;
                }
                if (this.mShouldHandleSelfDefined) break;
                this.mShouldHandleSelfDefined = true;
                this.mShouldHandleSelf = true;
                this.resetLeftOrRightImageViewer();
                break;
            }
            case 1: {
                if (this.mShouldHandleSelfDefined) break;
                this.mShouldHandleSelfDefined = true;
                this.mShouldHandleSelf = true;
            }
        }
        switch (ev.getAction()) {
            case 0: {
                if (this.mImageViewer == null) break;
                this.mImageViewer.onTouchEvent(ev);
                break;
            }
            case 2: {
                if (!this.mShouldHandleSelfDefined || this.mShouldHandleSelf) break;
                this.mImageViewer.onTouchEvent(ev);
                break;
            }
            case 1: {
                if (this.mImageViewer == null) break;
                this.mImageViewer.onTouchEvent(ev);
                this.mImageViewer = null;
            }
        }
        switch (ev.getAction() & 0xFF) {
            case 0: {
                super.onTouchEvent(ev);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                if (!this.mShouldHandleSelfDefined || !this.mShouldHandleSelf) break;
                super.onTouchEvent(ev);
            }
        }
        return true;
    }
}

