/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

public class PhoneShakeDetector
implements SensorEventListener {
    private Context mContext;
    private SensorManager mSensorManager;
    private PhoneShakeListener mListener;
    private int mShakeThreshold = 5000;
    private float x;
    private float y;
    private float z;
    private float last_x;
    private float last_y;
    private float last_z;
    private long lastUpdate;

    public PhoneShakeDetector(Context context) {
        this.mContext = context;
    }

    public void setPhoneShakeListener(PhoneShakeListener listener) {
        this.mListener = listener;
    }

    public void setShakeThreshold(int value) {
        this.mShakeThreshold = value;
    }

    public void onSensorChanged(SensorEvent event) {
        long curTime = System.currentTimeMillis();
        if (curTime - this.lastUpdate > 100L) {
            long diffTime = curTime - this.lastUpdate;
            this.lastUpdate = curTime;
            this.x = event.values[0];
            this.y = event.values[1];
            this.z = event.values[2];
            float speed = Math.abs(this.x + this.y + this.z - this.last_x - this.last_y - this.last_z) / (float)diffTime * 10000.0f;
            if (speed > (float)this.mShakeThreshold) {
                this.mListener.onPhoneShake(this);
            }
            this.last_x = this.x;
            this.last_y = this.y;
            this.last_z = this.z;
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void start() {
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        Sensor sensor = this.mSensorManager.getDefaultSensor(1);
        this.mSensorManager.registerListener((SensorEventListener)this, sensor, 2);
    }

    public void stop() {
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        this.mSensorManager.unregisterListener((SensorEventListener)this);
    }

    public static interface PhoneShakeListener {
        public void onPhoneShake(PhoneShakeDetector var1);
    }
}

