/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

public class PhoneOverturnDetector
implements SensorEventListener {
    private Context mContext;
    private SensorManager mSensorManager;
    private int mTestCount = 0;
    private float mSourceZValue = 0.0f;
    private boolean mIsSource = false;
    private PhoneOverturnListener mListener;

    public PhoneOverturnDetector(Context context) {
        this.mContext = context;
    }

    public void setPhoneOverturnListener(PhoneOverturnListener listener) {
        this.mListener = listener;
    }

    public void onSensorChanged(SensorEvent event) {
        ++this.mTestCount;
        if (this.mTestCount < 30) {
            return;
        }
        if (!this.mIsSource) {
            float z = Math.abs(event.values[2]);
            if (z > 9.3f && z < 10.0f) {
                this.mIsSource = true;
                this.mSourceZValue = event.values[2];
            }
        } else {
            float span = event.values[2] - this.mSourceZValue;
            float absSpan = Math.abs(span);
            if (absSpan > 18.6f && absSpan < 20.0f && this.mListener != null) {
                this.mSourceZValue = event.values[2];
                this.mListener.onPhoneOverturn(this);
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void start() {
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        Sensor sensor = this.mSensorManager.getDefaultSensor(1);
        this.mSensorManager.registerListener((SensorEventListener)this, sensor, 2);
    }

    public void stop() {
        this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        this.mSensorManager.unregisterListener((SensorEventListener)this);
    }

    public static interface PhoneOverturnListener {
        public void onPhoneOverturn(PhoneOverturnDetector var1);
    }
}

