/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import java.util.ArrayList;
import java.util.List;
import site.iway.androidhelpers.R;

public class PageIndicator
extends LinearLayout {
    private int mCount;
    private int mResSelected;
    private int mResUnselected;
    private int mPoint;
    private int mIndicatorSpacing;

    public PageIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.resolveAttr(context, attrs);
    }

    public PageIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttr(context, attrs);
    }

    public PageIndicator(Context context) {
        super(context);
        this.resolveAttr(context, null);
    }

    private List<View> copyChildViews() {
        ArrayList<View> copiedChildViews = new ArrayList<View>();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            copiedChildViews.add(this.getChildAt(i));
        }
        return copiedChildViews;
    }

    private void update() {
        List<View> copiedChildViews = this.copyChildViews();
        this.removeAllViews();
        if (this.mCount <= 0) {
            return;
        }
        for (int i = 0; i < this.mCount; ++i) {
            LinearLayout.LayoutParams params;
            ImageView imageView;
            if (i < copiedChildViews.size()) {
                imageView = (ImageView)copiedChildViews.get(i);
                params = new LinearLayout.LayoutParams(0, -1);
                params.weight = 1.0f;
                this.addView((View)imageView, (ViewGroup.LayoutParams)params);
            } else {
                Context context = this.getContext();
                ImageView imageView2 = new ImageView(context);
                imageView2.setScaleType(ImageView.ScaleType.FIT_CENTER);
                LinearLayout.LayoutParams params2 = new LinearLayout.LayoutParams(0, -1);
                params2.weight = 1.0f;
                this.addView((View)imageView2, (ViewGroup.LayoutParams)params2);
            }
            imageView = (ImageView)this.getChildAt(i);
            if (i == 0) {
                params = (LinearLayout.LayoutParams)imageView.getLayoutParams();
                params.leftMargin = 0;
                params.rightMargin = 0;
            } else {
                params = (LinearLayout.LayoutParams)imageView.getLayoutParams();
                params.leftMargin = this.mIndicatorSpacing;
                params.rightMargin = 0;
            }
            if (i == this.mPoint) {
                imageView.setImageResource(this.mResSelected);
                continue;
            }
            imageView.setImageResource(this.mResUnselected);
        }
    }

    private void resolveAttr(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PageIndicator);
        this.mCount = a.getInt(R.styleable.PageIndicator_pageCount, 5);
        this.mResSelected = a.getResourceId(R.styleable.PageIndicator_resSelected, R.drawable.page_indicator_s);
        this.mResUnselected = a.getResourceId(R.styleable.PageIndicator_resUnselected, R.drawable.page_indicator_n);
        this.mPoint = a.getInt(R.styleable.PageIndicator_pageIndex, 0);
        this.mIndicatorSpacing = a.getDimensionPixelSize(R.styleable.PageIndicator_indicatorSpacing, 0);
        this.update();
        a.recycle();
    }

    public void setPageCount(int count) {
        this.mCount = count;
        this.update();
    }

    public void setResSelected(int resSelected) {
        this.mResSelected = resSelected;
        this.update();
    }

    public void setResUnselected(int resUnselected) {
        this.mCount = resUnselected;
        this.update();
    }

    public void setPageIndex(int point) {
        this.mPoint = point;
        this.update();
    }
}

