/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Movie;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import java.io.InputStream;
import site.iway.androidhelpers.CanvasHelper;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.UITimer;
import site.iway.javahelpers.Scale;

public class MovieView
extends View {
    private Scale mScale;
    private boolean mRepeated;
    private int mRefreshTimeSpan;
    private boolean mLoaded;
    private Movie mMovie;
    private Bitmap mTempImage;
    private Canvas mTempCanvas;
    private Paint mPaint;
    private long mStartTime;
    private UITimer mUITimer;

    public MovieView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.resolveAttrs(context, attrs);
    }

    public MovieView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public MovieView(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MovieView);
        int scaleType = a.getInt(R.styleable.MovieView_scaleType, 0);
        switch (scaleType) {
            case 0: {
                this.mScale = Scale.None;
                break;
            }
            case 1: {
                this.mScale = Scale.Center;
                break;
            }
            case 2: {
                this.mScale = Scale.CenterFit;
                break;
            }
            case 3: {
                this.mScale = Scale.CenterCrop;
                break;
            }
            case 4: {
                this.mScale = Scale.CenterInside;
            }
        }
        this.mRepeated = a.getBoolean(R.styleable.MovieView_repeated, false);
        this.mRefreshTimeSpan = a.getInt(R.styleable.MovieView_refreshTimeSpan, 16);
        a.recycle();
        this.mUITimer = new UITimer(this.mRefreshTimeSpan){

            @Override
            public void doOnUIThread() {
                long now = System.nanoTime() / 1000000L;
                int time = (int)(now - MovieView.this.mStartTime);
                if (MovieView.this.mRepeated) {
                    time %= MovieView.this.mMovie.duration();
                } else if (time > MovieView.this.mMovie.duration()) {
                    time = MovieView.this.mMovie.duration();
                }
                MovieView.this.mMovie.setTime(time);
                MovieView.this.mMovie.draw(MovieView.this.mTempCanvas, 0.0f, 0.0f);
                MovieView.this.invalidate();
            }
        };
    }

    private void start() {
        if (this.mMovie != null) {
            this.mStartTime = System.nanoTime() / 1000000L;
            this.mUITimer.start(true);
        }
    }

    private void stop() {
        this.mUITimer.stop();
    }

    public void load(InputStream inputStream) {
        this.mMovie = Movie.decodeStream((InputStream)inputStream);
        if (this.mMovie != null) {
            int width = this.mMovie.width();
            int height = this.mMovie.height();
            Bitmap.Config config = Bitmap.Config.ARGB_8888;
            this.mTempImage = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            this.mTempCanvas = new Canvas(this.mTempImage);
            this.mPaint = new Paint();
            this.mPaint.setFilterBitmap(true);
            this.mLoaded = true;
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mLoaded) {
            CanvasHelper.drawBitmap(canvas, null, this.mTempImage, null, this.mScale, this.mPaint);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.start();
    }

    protected void onDetachedFromWindow() {
        this.stop();
        super.onDetachedFromWindow();
    }
}

