/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.ImageView;
import android.widget.RelativeLayout;

@Deprecated
public abstract class MenuAnimated {
    private Activity mActivity;
    private RelativeLayout mRootView;
    private ImageView mBackgroundView;
    private View mContentView;
    private boolean mIsShown = false;
    private int mAnimationTimeout = 300;
    private boolean mWillHideOnBgClicked = true;
    private boolean mWillHideOnBackPressed = true;
    private OnMenuBgClickListener mOnMenuBgClickListener;
    private OnBackPressedListener mOnBackPressedListener;
    private OnMenuShownListener mOnMenuShownListener;
    private OnMenuHiddenListener mOnMenuHiddenListener;

    public MenuAnimated(Activity parent, int backgroundColor) {
        this.mActivity = parent;
        this.mRootView = new RelativeLayout((Context)parent);
        this.mBackgroundView = new ImageView((Context)parent);
        this.mBackgroundView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.mBackgroundView.setImageDrawable((Drawable)new ColorDrawable(backgroundColor));
        this.mBackgroundView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (MenuAnimated.this.mOnMenuBgClickListener != null) {
                    MenuAnimated.this.mOnMenuBgClickListener.onMenuBgClick(MenuAnimated.this);
                }
                if (MenuAnimated.this.mWillHideOnBgClicked) {
                    MenuAnimated.this.hide();
                }
            }
        });
        int width = -1;
        int height = -1;
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(width, height);
        this.mRootView.addView((View)this.mBackgroundView, (ViewGroup.LayoutParams)layoutParams);
        this.mRootView.setVisibility(8);
        this.mRootView.setOnKeyListener(new View.OnKeyListener(){
            private boolean mHasKeyDowned;

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (MenuAnimated.this.mIsShown && keyCode == 4) {
                    switch (event.getAction()) {
                        case 0: {
                            this.mHasKeyDowned = true;
                            return true;
                        }
                        case 1: {
                            if (this.mHasKeyDowned) {
                                if (MenuAnimated.this.mOnBackPressedListener != null) {
                                    MenuAnimated.this.mOnBackPressedListener.onBackPressed(MenuAnimated.this);
                                }
                                if (MenuAnimated.this.mWillHideOnBackPressed) {
                                    MenuAnimated.this.hide();
                                }
                                this.mHasKeyDowned = false;
                            }
                            return true;
                        }
                    }
                    return true;
                }
                return false;
            }
        });
        this.mRootView.setFocusable(true);
        this.mRootView.setFocusableInTouchMode(true);
        this.mActivity.addContentView((View)this.mRootView, (ViewGroup.LayoutParams)layoutParams);
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public int getAnimationTimeout() {
        return this.mAnimationTimeout;
    }

    public void setAnimationTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must >= 0");
        }
        this.mAnimationTimeout = timeout;
    }

    public boolean getWillHideOnBgClicked() {
        return this.mWillHideOnBgClicked;
    }

    public void setWillHideOnBgClicked(boolean value) {
        this.mWillHideOnBgClicked = value;
    }

    public boolean getWillHideOnBackPressed() {
        return this.mWillHideOnBackPressed;
    }

    public void setWillHideOnBackPressed(boolean value) {
        this.mWillHideOnBackPressed = value;
        this.mRootView.setFocusable(value);
        this.mRootView.setFocusableInTouchMode(value);
    }

    public OnMenuBgClickListener getOnMenuBgClickListener() {
        return this.mOnMenuBgClickListener;
    }

    public void setOnMenuBgClickListener(OnMenuBgClickListener listener) {
        this.mOnMenuBgClickListener = listener;
    }

    public OnBackPressedListener getOnBackPressedListener() {
        return this.mOnBackPressedListener;
    }

    public void setOnBackPressedListener(OnBackPressedListener listener) {
        this.mOnBackPressedListener = listener;
    }

    public OnMenuShownListener getOnMenuShownListener() {
        return this.mOnMenuShownListener;
    }

    public void setOnMenuShownListener(OnMenuShownListener listener) {
        this.mOnMenuShownListener = listener;
    }

    public OnMenuHiddenListener getOnMenuHiddenListener() {
        return this.mOnMenuHiddenListener;
    }

    public void setOnMenuHiddenListener(OnMenuHiddenListener listener) {
        this.mOnMenuHiddenListener = listener;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public View findViewById(int id) {
        return this.mContentView == null ? null : this.mContentView.findViewById(id);
    }

    public void setLayoutParams(RelativeLayout.LayoutParams layoutParams) {
        if (this.mContentView != null) {
            this.mContentView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
    }

    protected abstract void processContentViewLayoutParams(RelativeLayout.LayoutParams var1);

    private void setOnClickListenerToAll(ViewGroup viewGroup, View.OnClickListener listener) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View child = viewGroup.getChildAt(i);
            if (child instanceof ViewGroup) {
                this.setOnClickListenerToAll((ViewGroup)child, listener);
                continue;
            }
            child.setOnClickListener(listener);
        }
    }

    public void setContentView(View view, View.OnClickListener listener) {
        if (this.mContentView != null) {
            this.mRootView.removeView(this.mContentView);
        }
        this.mContentView = view;
        if (listener != null) {
            if (this.mContentView instanceof ViewGroup) {
                this.setOnClickListenerToAll((ViewGroup)this.mContentView, listener);
            } else {
                this.mContentView.setOnClickListener(listener);
            }
        }
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.mContentView.getLayoutParams();
        this.processContentViewLayoutParams(params);
        this.mRootView.addView(this.mContentView);
    }

    public void setContentView(int layoutId, View.OnClickListener listener) {
        LayoutInflater inflater = this.mActivity.getLayoutInflater();
        View contentView = inflater.inflate(layoutId, (ViewGroup)this.mRootView, false);
        this.setContentView(contentView, listener);
    }

    public boolean isShown() {
        return this.mIsShown;
    }

    protected abstract void playShowAnimation(View var1);

    public void show() {
        if (this.mIsShown) {
            return;
        }
        this.mIsShown = true;
        this.mRootView.setVisibility(0);
        if (this.mWillHideOnBackPressed) {
            this.mRootView.requestFocus();
        }
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration((long)this.mAnimationTimeout);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (MenuAnimated.this.mOnMenuShownListener != null) {
                    MenuAnimated.this.mOnMenuShownListener.onMenuShown(MenuAnimated.this, true);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mBackgroundView.startAnimation((Animation)animation);
        this.playShowAnimation(this.mContentView);
    }

    public void showImediately() {
        if (this.mIsShown) {
            return;
        }
        this.mIsShown = true;
        this.mRootView.setVisibility(0);
        if (this.mWillHideOnBackPressed) {
            this.mRootView.requestFocus();
        }
        if (this.mOnMenuShownListener != null) {
            this.mOnMenuShownListener.onMenuShown(this, false);
        }
    }

    public boolean isHidden() {
        return !this.mIsShown;
    }

    protected abstract void playHideAnimation(View var1);

    public void hide() {
        if (!this.mIsShown) {
            return;
        }
        this.mIsShown = false;
        AlphaAnimation animation = new AlphaAnimation(1.0f, 0.0f);
        animation.setDuration((long)this.mAnimationTimeout);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                MenuAnimated.this.mRootView.setVisibility(8);
                if (MenuAnimated.this.mOnMenuHiddenListener != null) {
                    MenuAnimated.this.mOnMenuHiddenListener.onMenuHidden(MenuAnimated.this, true);
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mBackgroundView.startAnimation((Animation)animation);
        this.playHideAnimation(this.mContentView);
    }

    public void hideImediately() {
        if (!this.mIsShown) {
            return;
        }
        this.mIsShown = false;
        this.mRootView.setVisibility(8);
        if (this.mOnMenuHiddenListener != null) {
            this.mOnMenuHiddenListener.onMenuHidden(this, false);
        }
    }

    public static interface OnMenuShownListener {
        public void onMenuShown(MenuAnimated var1, boolean var2);
    }

    public static interface OnMenuHiddenListener {
        public void onMenuHidden(MenuAnimated var1, boolean var2);
    }

    public static interface OnMenuBgClickListener {
        public void onMenuBgClick(MenuAnimated var1);
    }

    public static interface OnBackPressedListener {
        public void onBackPressed(MenuAnimated var1);
    }
}

