/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import android.os.Process;

public class LocationGetter
implements LocationListener {
    private Context mContext;
    private LocationManager mLocationManager;
    private LocationGetterListener mOnLocationGetListener;

    public LocationGetter(Context context) {
        this.mContext = context;
        Object service = this.mContext.getSystemService("location");
        this.mLocationManager = (LocationManager)service;
    }

    public void setOnLocationGetListener(LocationGetterListener l) {
        this.mOnLocationGetListener = l;
    }

    private boolean checkPermission() {
        int pid = Process.myPid();
        int uid = Process.myUid();
        int p1 = this.mContext.checkPermission("android.permission.ACCESS_FINE_LOCATION", pid, uid);
        int p2 = this.mContext.checkPermission("android.permission.ACCESS_COARSE_LOCATION", pid, uid);
        return p1 == 0 && p2 == 0;
    }

    public boolean startGPS() {
        String provider = "gps";
        Looper looper = Looper.getMainLooper();
        if (this.checkPermission()) {
            this.mLocationManager.requestSingleUpdate(provider, (LocationListener)this, looper);
            return true;
        }
        return false;
    }

    public boolean startGPS(long minTime, float minDistance) {
        String provider = "gps";
        Looper looper = Looper.getMainLooper();
        if (this.checkPermission()) {
            this.mLocationManager.requestLocationUpdates(provider, minTime, minDistance, (LocationListener)this, looper);
            return true;
        }
        return false;
    }

    public boolean startNetwork() {
        String provider = "network";
        Looper looper = Looper.getMainLooper();
        if (this.checkPermission()) {
            this.mLocationManager.requestSingleUpdate(provider, (LocationListener)this, looper);
            return true;
        }
        return false;
    }

    public boolean startNetwork(long minTime, float minDistance) {
        String provider = "network";
        Looper looper = Looper.getMainLooper();
        if (this.checkPermission()) {
            this.mLocationManager.requestLocationUpdates(provider, minTime, minDistance, (LocationListener)this, looper);
            return true;
        }
        return false;
    }

    public boolean startPassive() {
        String provider = "passive";
        Looper looper = Looper.getMainLooper();
        if (this.checkPermission()) {
            this.mLocationManager.requestSingleUpdate(provider, (LocationListener)this, looper);
            return true;
        }
        return false;
    }

    public boolean startPassive(long minTime, float minDistance) {
        String provider = "passive";
        Looper looper = Looper.getMainLooper();
        if (this.checkPermission()) {
            this.mLocationManager.requestLocationUpdates(provider, minTime, minDistance, (LocationListener)this, looper);
            return true;
        }
        return false;
    }

    public void onLocationChanged(Location location) {
        this.mOnLocationGetListener.onLocationGet(location);
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onProviderDisabled(String provider) {
    }

    public boolean stop() {
        if (this.checkPermission()) {
            this.mLocationManager.removeUpdates((LocationListener)this);
            return true;
        }
        return false;
    }

    public static interface LocationGetterListener {
        public void onLocationGet(Location var1);
    }
}

