/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.UITimer;

public class LoadingView
extends View {
    private boolean mHasWindow;
    private Drawable mDrawable;
    private int mRotateDegrees;
    private int mRotateFrameSpan;
    private int mRotateFrameTime;
    private UITimer mTimer;

    public LoadingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.resolveAttrs(context, attrs);
    }

    public LoadingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public LoadingView(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    private void update() {
        if (this.mTimer != null) {
            this.mTimer.stop();
        }
        if (this.mDrawable == null) {
            return;
        }
        if (this.mRotateFrameSpan % 360 == 0) {
            return;
        }
        if (this.mRotateFrameTime <= 0) {
            return;
        }
        this.mTimer = new UITimer(this.mRotateFrameTime){

            @Override
            public void doOnUIThread() {
                int visibility = LoadingView.this.getVisibility();
                if (visibility == 0) {
                    LoadingView.this.mRotateDegrees = LoadingView.this.mRotateDegrees + LoadingView.this.mRotateFrameSpan;
                    LoadingView.this.invalidate();
                }
            }

            @Override
            public void start(boolean startOnce) {
                LoadingView.this.mRotateDegrees = 0;
                super.start(startOnce);
            }
        };
        if (this.mHasWindow) {
            this.mTimer.start(false);
        }
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LoadingView);
        Resources r = context.getResources();
        this.mDrawable = a.hasValue(R.styleable.LoadingView_loadingDrawable) ? a.getDrawable(R.styleable.LoadingView_loadingDrawable) : r.getDrawable(R.drawable.loading);
        this.mRotateFrameSpan = a.getInt(R.styleable.LoadingView_rotateFrameSpan, 30);
        this.mRotateFrameTime = a.getInt(R.styleable.LoadingView_rotateFrameTime, 100);
        a.recycle();
        this.update();
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public void setDrawable(Drawable drawable2) {
        this.mDrawable = drawable2;
        this.mRotateDegrees = 0;
        this.update();
    }

    public int getRotateFrameSpan() {
        return this.mRotateFrameSpan;
    }

    public void setRotateFrameSpan(int rotateFrameSpan) {
        this.mRotateFrameSpan = rotateFrameSpan;
        this.update();
    }

    public int getRotateFrameTime() {
        return this.mRotateFrameTime;
    }

    public void setRotateFrameTime(int rotateFrameTime) {
        this.mRotateFrameTime = rotateFrameTime;
        this.update();
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDrawable != null) {
            canvas.save();
            int clientLeft = this.getPaddingLeft();
            int clientTop = this.getPaddingTop();
            int clientRight = this.getWidth() - this.getPaddingRight();
            int clientBottom = this.getHeight() - this.getPaddingBottom();
            float centerX = (float)(clientLeft + clientRight) * 0.5f;
            float centerY = (float)(clientTop + clientBottom) * 0.5f;
            canvas.rotate((float)this.mRotateDegrees, centerX, centerY);
            this.mDrawable.setBounds(clientLeft, clientTop, clientRight, clientBottom);
            this.mDrawable.draw(canvas);
            canvas.restore();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mHasWindow = true;
        if (this.mTimer != null) {
            this.mTimer.start(false);
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mTimer != null) {
            this.mTimer.stop();
        }
        this.mHasWindow = false;
        super.onDetachedFromWindow();
    }
}

