/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import site.iway.javahelpers.MathHelper;

public class ImageViewer
extends View {
    public static final int CENTER_NO_SCALE = 1;
    public static final int CENTER_FIT = 2;
    public static final int CENTER_CROP = 3;
    public static final int CENTER_INSIDE = 4;
    private Bitmap mBitmap;
    private float mImageWidth;
    private float mImageHeight;
    private float mImageLeft;
    private float mImageTop;
    private float mImageScale;
    private float mViewWidth;
    private float mViewHeight;
    private int mInitScaleType = 2;
    private float mInitImageScale;
    private int mImageAnimationStep = 5;
    private float mMinImageScale = 1.0f;
    private float mMaxImageScale = 2.0f;
    private ImageStateChecker mImageStateChecker;
    private int mClickDetectStep = 300;
    private int mClickDetectRadius = 10;
    private View.OnClickListener mOnClickListener;
    private boolean mIsDetectingClick;
    private int mClickDownCount;
    private int mClickUpCount;
    private float mClickDownX;
    private float mClickDownY;
    private float mClickUpX;
    private float mClickUpY;
    private Runnable mClickDetectHandler = new Runnable(){

        @Override
        public void run() {
            float dy;
            float dx = ImageViewer.this.mClickDownX - ImageViewer.this.mClickUpX;
            if (MathHelper.distance((double)dx, (double)(dy = ImageViewer.this.mClickDownY - ImageViewer.this.mClickUpY)) < (double)ImageViewer.this.mClickDetectRadius) {
                if (ImageViewer.this.mClickDownCount == 1 && ImageViewer.this.mClickUpCount == 1) {
                    if (ImageViewer.this.mOnClickListener != null) {
                        ImageViewer.this.mOnClickListener.onClick((View)ImageViewer.this);
                    }
                } else if (ImageViewer.this.mClickDownCount == 2 && ImageViewer.this.mClickUpCount == 2) {
                    ImageViewer.this.onDoubleClickEvent();
                }
            }
            ImageViewer.this.mIsDetectingClick = false;
        }
    };
    private float mSavedImageLeft;
    private float mSavedImageTop;
    private float mSavedImageScale;
    private float mSavedTouchDownX;
    private float mSavedTouchDownY;
    private float mSavedTouchUpX;
    private float mSavedTouchUpY;
    private float mSavedXPivot;
    private float mSavedYPivot;
    private float mSavedFingersCenterX;
    private float mSavedFingersCenterY;
    private float mSavedFingerDistance;
    private float mTargetImageLeft;
    private float mTargetImageTop;
    private float mTargetImageScale;
    private float mTargetImageWidth;
    private float mTargetImageHeight;
    private boolean mIsFirstTwoFingerTouch = true;
    private boolean mHasTwoFingerTouched = false;
    private Matrix mMatrix = new Matrix();
    private float[] mMatrixValues = new float[9];
    private Paint mPaint = new Paint();

    public ImageViewer(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public ImageViewer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ImageViewer(Context context) {
        super(context);
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.mImageWidth = this.mBitmap == null ? -1.0f : (float)this.mBitmap.getWidth();
        this.mImageHeight = this.mBitmap == null ? -1.0f : (float)this.mBitmap.getHeight();
        this.resetImageState();
    }

    public float getImageWidth() {
        if (this.mBitmap == null) {
            return Float.NaN;
        }
        return this.mImageWidth;
    }

    public float getImageHeight() {
        if (this.mBitmap == null) {
            return Float.NaN;
        }
        return this.mImageHeight;
    }

    public float getImageLeftPadding() {
        if (this.mBitmap == null) {
            return Float.NaN;
        }
        return this.mImageLeft;
    }

    public float getImageTopPadding() {
        if (this.mBitmap == null) {
            return Float.NaN;
        }
        return this.mImageTop;
    }

    public float getImageRightPadding() {
        if (this.mBitmap == null) {
            return Float.NaN;
        }
        return this.mViewWidth - (this.mImageLeft + this.mImageWidth * this.mImageScale);
    }

    public float getImageBottomPadding() {
        if (this.mBitmap == null) {
            return Float.NaN;
        }
        return this.mViewHeight - (this.mImageTop + this.mImageHeight * this.mImageScale);
    }

    public float getImageScale() {
        if (this.mBitmap == null) {
            return Float.NaN;
        }
        return this.mImageScale;
    }

    public float getViewWidth() {
        return this.mViewWidth;
    }

    public float getViewHeight() {
        return this.mViewHeight;
    }

    public int getInitScaleType() {
        return this.mInitScaleType;
    }

    public void setInitScaleType(int scaleType) {
        if (scaleType >= 1 && scaleType <= 3) {
            if (this.mInitScaleType != scaleType) {
                this.mInitScaleType = scaleType;
                this.resetImageState();
            } else {
                this.mInitScaleType = scaleType;
            }
        }
    }

    public void resetImageState() {
        if (this.mBitmap == null || this.mViewWidth == 0.0f || this.mViewHeight == 0.0f) {
            return;
        }
        if (this.mImageStateChecker != null) {
            this.mImageStateChecker.pauseCheckState();
        }
        switch (this.mInitScaleType) {
            case 1: {
                this.mImageLeft = (this.mViewWidth - this.mImageWidth) / 2.0f;
                this.mImageTop = (this.mViewHeight - this.mImageHeight) / 2.0f;
                break;
            }
            case 4: {
                if (this.mImageWidth <= this.mViewWidth && this.mImageHeight <= this.mViewHeight) {
                    this.mImageLeft = (this.mViewWidth - this.mImageWidth) / 2.0f;
                    this.mImageTop = (this.mViewHeight - this.mImageHeight) / 2.0f;
                    break;
                }
            }
            case 2: {
                float targetScale = 1.0f;
                if (this.mViewWidth / this.mImageWidth * this.mImageHeight <= this.mViewHeight) {
                    targetScale = this.mViewWidth / this.mImageWidth;
                }
                if (this.mViewHeight / this.mImageHeight * this.mImageWidth <= this.mViewWidth) {
                    targetScale = this.mViewHeight / this.mImageHeight;
                }
                float scaledImageWidth = targetScale * this.mImageWidth;
                float scaledImageHeight = targetScale * this.mImageHeight;
                this.mImageScale = targetScale;
                this.mImageLeft = (this.mViewWidth - scaledImageWidth) / 2.0f;
                this.mImageTop = (this.mViewHeight - scaledImageHeight) / 2.0f;
                break;
            }
            case 3: {
                float targetScale = 1.0f;
                if (this.mViewWidth / this.mImageWidth * this.mImageHeight >= this.mViewHeight) {
                    targetScale = this.mViewWidth / this.mImageWidth;
                }
                if (this.mViewHeight / this.mImageHeight * this.mImageWidth >= this.mViewWidth) {
                    targetScale = this.mViewHeight / this.mImageHeight;
                }
                float scaledImageWidth = targetScale * this.mImageWidth;
                float scaledImageHeight = targetScale * this.mImageHeight;
                this.mImageScale = targetScale;
                this.mImageLeft = (this.mViewWidth - scaledImageWidth) / 2.0f;
                this.mImageTop = (this.mViewHeight - scaledImageHeight) / 2.0f;
            }
        }
        this.mInitImageScale = this.mImageScale;
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mViewWidth = w;
        this.mViewHeight = h;
        this.resetImageState();
    }

    public int getImageAnimationStep() {
        return this.mImageAnimationStep;
    }

    public void setImageAnimationStep(int millis) {
        this.mImageAnimationStep = millis;
    }

    public float getMinImageScale() {
        return this.mMinImageScale;
    }

    public void setMinImageScale(float value) {
        this.mMinImageScale = value;
    }

    public float getMaxImageScale() {
        return this.mMaxImageScale;
    }

    public void setMaxImageScale(float value) {
        this.mMaxImageScale = value;
    }

    public int getClickDetectStep() {
        return this.mClickDetectStep;
    }

    public void setClickDetectStep(int millis) {
        this.mClickDetectStep = millis;
    }

    public int getClickDetectRadius() {
        return this.mClickDetectRadius;
    }

    public void setClickDetectRadius(int pixels) {
        this.mClickDetectRadius = pixels;
    }

    public View.OnClickListener getOnClickListener() {
        return this.mOnClickListener;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.mOnClickListener = listener;
    }

    public void handleClickDetectDown(MotionEvent event) {
        ++this.mClickDownCount;
        this.mClickDownX = event.getX();
        this.mClickDownY = event.getY();
    }

    public void handleClickDetectUp(MotionEvent event) {
        ++this.mClickUpCount;
        this.mClickUpX = event.getX();
        this.mClickUpY = event.getY();
    }

    private void beginClickDetect() {
        if (!this.mIsDetectingClick) {
            this.mClickDownCount = 0;
            this.mClickUpCount = 0;
            this.mIsDetectingClick = true;
            this.getHandler().postDelayed(this.mClickDetectHandler, (long)this.mClickDetectStep);
        }
    }

    private void saveImageState() {
        this.mSavedImageLeft = this.mImageLeft;
        this.mSavedImageTop = this.mImageTop;
        this.mSavedImageScale = this.mImageScale;
    }

    private void loadTargetImageState() {
        this.mTargetImageLeft = this.mImageLeft;
        this.mTargetImageTop = this.mImageTop;
        this.mTargetImageScale = this.mImageScale;
    }

    private void checkTargetImageScale() {
        if (this.mTargetImageScale > this.mMaxImageScale * this.mInitImageScale) {
            this.mTargetImageScale = this.mMaxImageScale * this.mInitImageScale;
        }
        if (this.mTargetImageScale < this.mMinImageScale * this.mInitImageScale) {
            this.mTargetImageScale = this.mMinImageScale * this.mInitImageScale;
        }
    }

    private void computeTargetImageSize() {
        this.mTargetImageWidth = this.mImageWidth * this.mTargetImageScale;
        this.mTargetImageHeight = this.mImageHeight * this.mTargetImageScale;
    }

    private void setTargetImagePosition() {
        float xPovit = (this.mSavedTouchUpX - this.mImageLeft) / (this.mImageWidth * this.mImageScale);
        float yPovit = (this.mSavedTouchUpY - this.mImageTop) / (this.mImageHeight * this.mImageScale);
        this.mTargetImageLeft = this.mSavedTouchUpX - this.mTargetImageWidth * xPovit;
        this.mTargetImageTop = this.mSavedTouchUpY - this.mTargetImageHeight * yPovit;
    }

    private void checkTargetImagePosition() {
        if (this.mTargetImageWidth <= this.mViewWidth && this.mTargetImageHeight <= this.mViewHeight) {
            this.mTargetImageLeft = (this.mViewWidth - this.mTargetImageWidth) / 2.0f;
            this.mTargetImageTop = (this.mViewHeight - this.mTargetImageHeight) / 2.0f;
        } else if (this.mTargetImageWidth > this.mViewWidth && this.mTargetImageHeight <= this.mViewHeight) {
            if (this.mTargetImageLeft > 0.0f) {
                this.mTargetImageLeft = 0.0f;
            } else if (this.mTargetImageLeft + this.mTargetImageWidth < this.mViewWidth) {
                this.mTargetImageLeft = this.mViewWidth - this.mTargetImageWidth;
            }
            this.mTargetImageTop = (this.mViewHeight - this.mTargetImageHeight) / 2.0f;
        } else if (this.mTargetImageWidth <= this.mViewWidth && this.mTargetImageHeight > this.mViewHeight) {
            this.mTargetImageLeft = (this.mViewWidth - this.mTargetImageWidth) / 2.0f;
            if (this.mTargetImageTop > 0.0f) {
                this.mTargetImageTop = 0.0f;
            } else if (this.mTargetImageTop + this.mTargetImageHeight < this.mViewHeight) {
                this.mTargetImageTop = this.mViewHeight - this.mTargetImageHeight;
            }
        } else if (this.mTargetImageWidth > this.mViewWidth && this.mTargetImageHeight > this.mViewHeight) {
            if (this.mTargetImageLeft > 0.0f) {
                this.mTargetImageLeft = 0.0f;
            } else if (this.mTargetImageLeft + this.mTargetImageWidth < this.mViewWidth) {
                this.mTargetImageLeft = this.mViewWidth - this.mTargetImageWidth;
            }
            if (this.mTargetImageTop > 0.0f) {
                this.mTargetImageTop = 0.0f;
            } else if (this.mTargetImageTop + this.mTargetImageHeight < this.mViewHeight) {
                this.mTargetImageTop = this.mViewHeight - this.mTargetImageHeight;
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mSavedTouchDownX = event.getX();
                this.mSavedTouchDownY = event.getY();
                this.beginClickDetect();
                this.handleClickDetectDown(event);
                this.mImageStateChecker.pauseCheckState();
                this.saveImageState();
                this.mIsFirstTwoFingerTouch = true;
                this.mHasTwoFingerTouched = false;
                break;
            }
            case 2: {
                switch (event.getPointerCount()) {
                    case 1: {
                        if (this.mHasTwoFingerTouched) break;
                        this.mImageLeft = this.mTargetImageLeft = event.getX() - this.mSavedTouchDownX + this.mSavedImageLeft;
                        this.mImageTop = this.mTargetImageTop = event.getY() - this.mSavedTouchDownY + this.mSavedImageTop;
                        this.invalidate();
                        break;
                    }
                    case 2: {
                        this.mSavedFingersCenterX = (event.getX(0) + event.getX(1)) / 2.0f;
                        this.mSavedFingersCenterY = (event.getY(0) + event.getY(1)) / 2.0f;
                        float x_0 = event.getX(0);
                        float y_0 = event.getY(0);
                        float x_1 = event.getX(1);
                        float y_1 = event.getY(1);
                        float fingerDistance = (float)MathHelper.distance((double)x_0, (double)y_0, (double)x_1, (double)y_1);
                        if (this.mIsFirstTwoFingerTouch) {
                            this.mSavedImageScale = this.mImageScale;
                            this.mSavedXPivot = (this.mSavedFingersCenterX - this.mImageLeft) / (this.mImageWidth * this.mImageScale);
                            this.mSavedYPivot = (this.mSavedFingersCenterY - this.mImageTop) / (this.mImageHeight * this.mImageScale);
                            this.mSavedFingerDistance = fingerDistance;
                            this.mIsFirstTwoFingerTouch = false;
                            this.mHasTwoFingerTouched = true;
                        } else {
                            float multiple = fingerDistance / this.mSavedFingerDistance;
                            this.mImageScale = multiple * this.mSavedImageScale;
                            this.mImageScale = multiple * this.mSavedImageScale;
                            this.mImageLeft = this.mSavedFingersCenterX - this.mImageWidth * this.mImageScale * this.mSavedXPivot;
                            this.mImageTop = this.mSavedFingersCenterY - this.mImageHeight * this.mImageScale * this.mSavedYPivot;
                        }
                        this.postInvalidate();
                    }
                }
                break;
            }
            case 1: 
            case 3: {
                if (this.mHasTwoFingerTouched) {
                    this.mSavedTouchUpX = this.mSavedFingersCenterX;
                    this.mSavedTouchUpY = this.mSavedFingersCenterY;
                } else {
                    this.mSavedTouchUpX = event.getX();
                    this.mSavedTouchUpY = event.getY();
                }
                this.loadTargetImageState();
                this.checkTargetImageScale();
                this.computeTargetImageSize();
                this.setTargetImagePosition();
                this.checkTargetImagePosition();
                this.handleClickDetectUp(event);
                this.mImageStateChecker.beginCheckState();
            }
        }
        return true;
    }

    private void onDoubleClickEvent() {
        this.loadTargetImageState();
        this.mTargetImageScale = this.mImageScale > this.mInitImageScale * (this.mMaxImageScale + this.mMinImageScale) / 2.0f ? this.mMinImageScale * this.mInitImageScale : this.mMaxImageScale * this.mInitImageScale;
        this.computeTargetImageSize();
        this.setTargetImagePosition();
        this.checkTargetImagePosition();
        this.mImageStateChecker.beginCheckState();
    }

    public boolean getMultiSamplingEnabled() {
        return this.mPaint.isFilterBitmap();
    }

    public void setMultiSamplingEnabled(boolean enabled) {
        this.mPaint.setFilterBitmap(enabled);
    }

    protected void onDraw(Canvas canvas) {
        if (this.mBitmap != null && !this.mBitmap.isRecycled()) {
            this.mMatrix.getValues(this.mMatrixValues);
            this.mMatrixValues[2] = this.mImageLeft;
            this.mMatrixValues[5] = this.mImageTop;
            this.mMatrixValues[0] = this.mImageScale;
            this.mMatrixValues[4] = this.mImageScale;
            this.mMatrix.setValues(this.mMatrixValues);
            canvas.drawBitmap(this.mBitmap, this.mMatrix, this.mPaint);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mImageStateChecker != null) {
            this.mImageStateChecker.stopCheckState();
        }
        this.mImageStateChecker = new ImageStateChecker();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBitmap = null;
        this.mViewWidth = 0.0f;
        this.mViewHeight = 0.0f;
        if (this.mImageStateChecker != null) {
            this.mImageStateChecker.stopCheckState();
        }
        this.mImageStateChecker = null;
    }

    private class ImageStateChecker
    extends Thread {
        private volatile boolean mShouldCheckImageState = false;
        private volatile boolean mShouldStopCheckState = false;

        private ImageStateChecker() {
        }

        @Override
        public void run() {
            while (!this.mShouldStopCheckState) {
                if (this.mShouldCheckImageState) {
                    if (ImageViewer.this.mBitmap == null) {
                        this.pauseCheckState();
                    } else {
                        float shouldImageLeftChange = (ImageViewer.this.mTargetImageLeft - ImageViewer.this.mImageLeft) * 0.05f;
                        float shouldImageTopChange = (ImageViewer.this.mTargetImageTop - ImageViewer.this.mImageTop) * 0.05f;
                        float shouldImageScaleChange = (ImageViewer.this.mTargetImageScale - ImageViewer.this.mImageScale) * 0.05f;
                        ImageViewer.this.mImageLeft = ImageViewer.this.mImageLeft + shouldImageLeftChange;
                        ImageViewer.this.mImageTop = ImageViewer.this.mImageTop + shouldImageTopChange;
                        ImageViewer.this.mImageScale = ImageViewer.this.mImageScale + shouldImageScaleChange;
                        boolean shouldPauseCheckState = true;
                        if (Math.abs(ImageViewer.this.mTargetImageLeft - ImageViewer.this.mImageLeft) >= 1.0f) {
                            shouldPauseCheckState = false;
                        }
                        if (Math.abs(ImageViewer.this.mTargetImageTop - ImageViewer.this.mImageTop) >= 1.0f) {
                            shouldPauseCheckState = false;
                        }
                        if (Math.abs((ImageViewer.this.mTargetImageScale - ImageViewer.this.mImageScale) * ImageViewer.this.mImageWidth) >= 1.0f) {
                            shouldPauseCheckState = false;
                        }
                        if (Math.abs((ImageViewer.this.mTargetImageScale - ImageViewer.this.mImageScale) * ImageViewer.this.mImageHeight) >= 1.0f) {
                            shouldPauseCheckState = false;
                        }
                        if (shouldPauseCheckState) {
                            ImageViewer.this.mImageLeft = ImageViewer.this.mTargetImageLeft;
                            ImageViewer.this.mImageTop = ImageViewer.this.mTargetImageTop;
                            ImageViewer.this.mImageScale = ImageViewer.this.mTargetImageScale;
                            this.pauseCheckState();
                        }
                        if (ImageViewer.this.getVisibility() == 0) {
                            ImageViewer.this.postInvalidate();
                        }
                    }
                }
                try {
                    ImageStateChecker.sleep(ImageViewer.this.mImageAnimationStep);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public void beginCheckState() {
            if (!this.isAlive()) {
                this.start();
            }
            this.mShouldCheckImageState = true;
        }

        public void pauseCheckState() {
            this.mShouldCheckImageState = false;
        }

        public void stopCheckState() {
            this.mShouldStopCheckState = true;
        }
    }
}

