/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import site.iway.androidhelpers.UnitHelper;
import site.iway.javahelpers.MathHelper;

public class ImageCropper
extends View {
    private Bitmap mBitmap;
    private RectF mBitmapRect;
    private float mInitRectPercent = 0.5f;
    private Drawable mCropDrawable;
    private RectF mCropRect;
    private float mCropBorderWidth;
    private float mMinCropRectSideLength = UnitHelper.dipToPx(this.getContext(), 20.0f);
    private float mCropRatio = -1.0f;
    private float mCropRatioBase;
    private float mCropRatioForX;
    private float mCropRatioForY;
    private Drawable mCoverDrawable;
    private boolean mAdjustLeftEdge;
    private boolean mAdjustTopEdge;
    private boolean mAdjustRightEdge;
    private boolean mAdjustBottomEdge;
    private boolean mAdjustCenterPoint;
    private float mTouchDownX;
    private float mTouchDownY;
    private float mSavedCropLeft;
    private float mSavedCropTop;
    private float mSavedCropRight;
    private float mSavedCropBottom;
    private Paint mPaint = new Paint();
    private Rect mCropRectInt = new Rect();

    public ImageCropper(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public ImageCropper(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ImageCropper(Context context) {
        super(context);
    }

    public float getInitCropRectPercent() {
        return this.mInitRectPercent;
    }

    public void setInitCropRectPercent(float percent) {
        this.mInitRectPercent = percent;
    }

    private void setBitmapAndCropRect() {
        if (this.mBitmap == null) {
            return;
        }
        float targetScale = 1.0f;
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        if (viewWidth / (float)this.mBitmap.getWidth() * (float)this.mBitmap.getHeight() <= viewHeight) {
            targetScale = viewWidth / (float)this.mBitmap.getWidth();
        }
        if (viewHeight / (float)this.mBitmap.getHeight() * (float)this.mBitmap.getWidth() <= viewWidth) {
            targetScale = viewHeight / (float)this.mBitmap.getHeight();
        }
        float scaledImageWidth = targetScale * (float)this.mBitmap.getWidth();
        float scaledImageHeight = targetScale * (float)this.mBitmap.getHeight();
        float left = (viewWidth - scaledImageWidth) / 2.0f;
        float top = (viewHeight - scaledImageHeight) / 2.0f;
        this.mBitmapRect = new RectF(left, top, left + scaledImageWidth, top + scaledImageHeight);
        float cropWidth = scaledImageWidth * this.mInitRectPercent;
        float cropHeight = scaledImageHeight * this.mInitRectPercent;
        if (this.mCropRatio > 0.0f) {
            if (cropHeight > cropWidth / this.mCropRatio) {
                cropHeight = cropWidth / this.mCropRatio;
            }
            if (cropWidth > cropHeight * this.mCropRatio) {
                cropWidth = cropHeight * this.mCropRatio;
            }
        }
        left = (viewWidth - cropWidth) / 2.0f;
        top = (viewHeight - cropHeight) / 2.0f;
        this.mCropRect = new RectF(left, top, left + cropWidth, top + cropHeight);
        this.invalidate();
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void setBitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        this.setBitmapAndCropRect();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.setBitmapAndCropRect();
    }

    public Drawable getCropDrawable() {
        return this.mCropDrawable;
    }

    public void setCropDrawable(Drawable drawable) {
        this.mCropDrawable = drawable;
    }

    public void setCropDrawable(int resourceId) {
        this.mCropDrawable = this.getContext().getResources().getDrawable(resourceId);
    }

    public float getCropBorderWidth() {
        return this.mCropBorderWidth;
    }

    public void setCropBorderWidth(float width) {
        this.mCropBorderWidth = width;
    }

    public float getMinCropDrawableRectSideLength() {
        return this.mMinCropRectSideLength;
    }

    public void setMinCropDrawableRectSideLength(float minCropDrawableRectSideLength) {
        this.mMinCropRectSideLength = minCropDrawableRectSideLength;
    }

    public float getCropRatio() {
        return this.mCropRatio;
    }

    public void setCropRatio(float ratio) {
        this.mCropRatio = ratio;
        this.mCropRatioBase = (float)Math.sqrt(this.mCropRatio * this.mCropRatio + 1.0f);
        this.mCropRatioForX = this.mCropRatio / this.mCropRatioBase;
        this.mCropRatioForY = 1.0f / this.mCropRatioBase;
        this.setBitmapAndCropRect();
    }

    public Drawable getCoverDrawable() {
        return this.mCoverDrawable;
    }

    public void setCoverDrawable(Drawable drawable) {
        this.mCoverDrawable = drawable;
        if (!(this.mCoverDrawable instanceof ColorDrawable) && Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, this.mPaint);
        }
    }

    public void setCoverDrawable(int resourceId) {
        this.setCoverDrawable(this.getContext().getResources().getDrawable(resourceId));
    }

    private void saveTouchDownStates(MotionEvent event) {
        this.mTouchDownX = event.getX();
        this.mTouchDownY = event.getY();
        this.mSavedCropLeft = this.mCropRect.left;
        this.mSavedCropTop = this.mCropRect.top;
        this.mSavedCropRight = this.mCropRect.right;
        this.mSavedCropBottom = this.mCropRect.bottom;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mBitmap == null || this.mCropDrawable == null) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.saveTouchDownStates(event);
                this.mAdjustLeftEdge = this.mTouchDownX <= this.mCropRect.left + this.mCropBorderWidth;
                this.mAdjustTopEdge = this.mTouchDownY <= this.mCropRect.top + this.mCropBorderWidth;
                this.mAdjustRightEdge = this.mTouchDownX >= this.mCropRect.right - this.mCropBorderWidth;
                this.mAdjustBottomEdge = this.mTouchDownY >= this.mCropRect.bottom - this.mCropBorderWidth;
                boolean bl = this.mAdjustCenterPoint = !this.mAdjustLeftEdge && !this.mAdjustTopEdge && !this.mAdjustRightEdge && !this.mAdjustBottomEdge;
                if (!(this.mCropRatio > 0.0f)) break;
                this.mAdjustLeftEdge = this.mTouchDownX < this.mCropRect.centerX();
                this.mAdjustTopEdge = this.mTouchDownY < this.mCropRect.centerY();
                this.mAdjustRightEdge = this.mTouchDownX > this.mCropRect.centerX();
                this.mAdjustBottomEdge = this.mTouchDownY > this.mCropRect.centerY();
                break;
            }
            case 2: {
                float dx = event.getX() - this.mTouchDownX;
                float dy = event.getY() - this.mTouchDownY;
                if (this.mAdjustCenterPoint) {
                    float targetCropLeft = this.mSavedCropLeft + dx;
                    float targetCropTop = this.mSavedCropTop + dy;
                    float targetCropRight = this.mSavedCropRight + dx;
                    float targetCropBottom = this.mSavedCropBottom + dy;
                    float savedCropWidth = this.mSavedCropRight - this.mSavedCropLeft;
                    float savedCropHeight = this.mSavedCropBottom - this.mSavedCropTop;
                    if (targetCropLeft < this.mBitmapRect.left) {
                        targetCropLeft = this.mBitmapRect.left;
                        targetCropRight = this.mBitmapRect.left + savedCropWidth;
                    }
                    if (targetCropTop < this.mBitmapRect.top) {
                        targetCropTop = this.mBitmapRect.top;
                        targetCropBottom = this.mBitmapRect.top + savedCropHeight;
                    }
                    if (targetCropRight > this.mBitmapRect.right) {
                        targetCropRight = this.mBitmapRect.right;
                        targetCropLeft = this.mBitmapRect.right - savedCropWidth;
                    }
                    if (targetCropBottom > this.mBitmapRect.bottom) {
                        targetCropBottom = this.mBitmapRect.bottom;
                        targetCropTop = this.mBitmapRect.bottom - savedCropHeight;
                    }
                    this.mCropRect.left = targetCropLeft;
                    this.mCropRect.top = targetCropTop;
                    this.mCropRect.right = targetCropRight;
                    this.mCropRect.bottom = targetCropBottom;
                } else if (this.mCropRatio > 0.0f) {
                    if (this.mAdjustLeftEdge && this.mAdjustTopEdge) {
                        boolean isLeftTooSmall;
                        boolean isTopTooSmall;
                        boolean isLeftTooBig;
                        boolean isTopTooBig;
                        float dst1 = (float)MathHelper.distance((double)this.mTouchDownX, (double)this.mTouchDownY, (double)this.getWidth(), (double)this.getHeight());
                        float dst2 = (float)MathHelper.distance((double)event.getX(), (double)event.getY(), (double)this.getWidth(), (double)this.getHeight());
                        float distanceChanged = dst2 - dst1;
                        float xChange = distanceChanged * this.mCropRatioForX;
                        float yChange = distanceChanged * this.mCropRatioForY;
                        float targetCropTop = this.mSavedCropTop - yChange;
                        float targetCropLeft = this.mSavedCropLeft - xChange;
                        boolean bl = isTopTooBig = targetCropTop < this.mBitmapRect.top;
                        if (isTopTooBig) {
                            targetCropTop = this.mBitmapRect.top;
                            targetCropLeft = this.mSavedCropRight - (this.mSavedCropBottom - targetCropTop) * this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        boolean bl2 = isLeftTooBig = targetCropLeft < this.mBitmapRect.left;
                        if (isLeftTooBig) {
                            targetCropLeft = this.mBitmapRect.left;
                            targetCropTop = this.mSavedCropBottom - (this.mSavedCropRight - targetCropLeft) / this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        boolean bl3 = isTopTooSmall = targetCropTop > this.mSavedCropBottom - this.mMinCropRectSideLength;
                        if (isTopTooSmall) {
                            targetCropTop = this.mSavedCropBottom - this.mMinCropRectSideLength;
                            targetCropLeft = this.mSavedCropRight - (this.mSavedCropBottom - targetCropTop) * this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        boolean bl4 = isLeftTooSmall = targetCropLeft > this.mSavedCropRight - this.mMinCropRectSideLength;
                        if (isLeftTooSmall) {
                            targetCropLeft = this.mSavedCropRight - this.mMinCropRectSideLength;
                            targetCropTop = this.mSavedCropBottom - (this.mSavedCropRight - targetCropLeft) / this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        this.mCropRect.top = targetCropTop;
                        this.mCropRect.left = targetCropLeft;
                    } else if (this.mAdjustLeftEdge && this.mAdjustBottomEdge) {
                        boolean isLeftTooSmall;
                        boolean isBottomTooSmall;
                        boolean isLeftTooBig;
                        boolean isBottomTooBig;
                        float dst1 = (float)MathHelper.distance((double)this.mTouchDownX, (double)this.mTouchDownY, (double)this.getWidth(), (double)0.0);
                        float dst2 = (float)MathHelper.distance((double)event.getX(), (double)event.getY(), (double)this.getWidth(), (double)0.0);
                        float distanceChanged = dst2 - dst1;
                        float xChange = distanceChanged * this.mCropRatioForX;
                        float yChange = distanceChanged * this.mCropRatioForY;
                        float targetCropBottom = this.mSavedCropBottom + yChange;
                        float targetCropLeft = this.mSavedCropLeft - xChange;
                        boolean bl = isBottomTooBig = targetCropBottom > this.mBitmapRect.bottom;
                        if (isBottomTooBig) {
                            targetCropBottom = this.mBitmapRect.bottom;
                            targetCropLeft = this.mSavedCropRight - (targetCropBottom - this.mSavedCropTop) * this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        boolean bl5 = isLeftTooBig = targetCropLeft < this.mBitmapRect.left;
                        if (isLeftTooBig) {
                            targetCropLeft = this.mBitmapRect.left;
                            targetCropBottom = this.mSavedCropTop + (this.mSavedCropRight - targetCropLeft) / this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        boolean bl6 = isBottomTooSmall = targetCropBottom < this.mSavedCropTop + this.mMinCropRectSideLength;
                        if (isBottomTooSmall) {
                            targetCropBottom = this.mSavedCropTop + this.mMinCropRectSideLength;
                            targetCropLeft = this.mSavedCropRight - (targetCropBottom - this.mSavedCropTop) * this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        boolean bl7 = isLeftTooSmall = targetCropLeft > this.mSavedCropRight - this.mMinCropRectSideLength;
                        if (isLeftTooSmall) {
                            targetCropLeft = this.mSavedCropRight - this.mMinCropRectSideLength;
                            targetCropBottom = this.mSavedCropTop + (this.mSavedCropRight - targetCropLeft) / this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        this.mCropRect.bottom = targetCropBottom;
                        this.mCropRect.left = targetCropLeft;
                    } else if (this.mAdjustRightEdge && this.mAdjustTopEdge) {
                        boolean isRightTooSmall;
                        boolean isTopTooSmall;
                        boolean isRightTooBig;
                        boolean isTopTooBig;
                        float dst1 = (float)MathHelper.distance((double)this.mTouchDownX, (double)this.mTouchDownY, (double)0.0, (double)this.getHeight());
                        float dst2 = (float)MathHelper.distance((double)event.getX(), (double)event.getY(), (double)0.0, (double)this.getHeight());
                        float distanceChanged = dst2 - dst1;
                        float xChange = distanceChanged * this.mCropRatioForX;
                        float yChange = distanceChanged * this.mCropRatioForY;
                        float targetCropTop = this.mSavedCropTop - yChange;
                        float targetCropRight = this.mSavedCropRight + xChange;
                        boolean bl = isTopTooBig = targetCropTop < this.mBitmapRect.top;
                        if (isTopTooBig) {
                            targetCropTop = this.mBitmapRect.top;
                            targetCropRight = this.mSavedCropLeft + (this.mSavedCropBottom - targetCropTop) * this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        boolean bl8 = isRightTooBig = targetCropRight > this.mBitmapRect.right;
                        if (isRightTooBig) {
                            targetCropRight = this.mBitmapRect.right;
                            targetCropTop = this.mSavedCropBottom - (targetCropRight - this.mSavedCropLeft) / this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        boolean bl9 = isTopTooSmall = targetCropTop > this.mSavedCropBottom - this.mMinCropRectSideLength;
                        if (isTopTooSmall) {
                            targetCropTop = this.mSavedCropBottom - this.mMinCropRectSideLength;
                            targetCropRight = this.mSavedCropLeft + (this.mSavedCropBottom - targetCropTop) * this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        boolean bl10 = isRightTooSmall = targetCropRight < this.mSavedCropLeft + this.mMinCropRectSideLength;
                        if (isRightTooSmall) {
                            targetCropRight = this.mSavedCropLeft + this.mMinCropRectSideLength;
                            targetCropTop = this.mSavedCropBottom - (targetCropRight - this.mSavedCropLeft) / this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        this.mCropRect.top = targetCropTop;
                        this.mCropRect.right = targetCropRight;
                    } else if (this.mAdjustRightEdge && this.mAdjustBottomEdge) {
                        boolean isRightTooSmall;
                        boolean isBottomTooSmall;
                        boolean isRightTooBig;
                        boolean isBottomTooBig;
                        float dst1 = (float)MathHelper.distance((double)this.mTouchDownX, (double)this.mTouchDownY, (double)0.0, (double)0.0);
                        float dst2 = (float)MathHelper.distance((double)event.getX(), (double)event.getY(), (double)0.0, (double)0.0);
                        float distanceChanged = dst2 - dst1;
                        float xChange = distanceChanged * this.mCropRatioForX;
                        float yChange = distanceChanged * this.mCropRatioForY;
                        float targetCropBottom = this.mSavedCropBottom + yChange;
                        float targetCropRight = this.mSavedCropRight + xChange;
                        boolean bl = isBottomTooBig = targetCropBottom > this.mBitmapRect.bottom;
                        if (isBottomTooBig) {
                            targetCropBottom = this.mBitmapRect.bottom;
                            targetCropRight = this.mSavedCropLeft + (targetCropBottom - this.mSavedCropTop) * this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        boolean bl11 = isRightTooBig = targetCropRight > this.mBitmapRect.right;
                        if (isRightTooBig) {
                            targetCropRight = this.mBitmapRect.right;
                            targetCropBottom = this.mSavedCropTop + (targetCropRight - this.mSavedCropLeft) / this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        boolean bl12 = isBottomTooSmall = targetCropBottom < this.mSavedCropTop + this.mMinCropRectSideLength;
                        if (isBottomTooSmall) {
                            targetCropBottom = this.mSavedCropTop + this.mMinCropRectSideLength;
                            targetCropRight = this.mSavedCropLeft + (targetCropBottom - this.mSavedCropTop) * this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        boolean bl13 = isRightTooSmall = targetCropRight < this.mSavedCropLeft + this.mMinCropRectSideLength;
                        if (isRightTooSmall) {
                            targetCropRight = this.mSavedCropLeft + this.mMinCropRectSideLength;
                            targetCropBottom = this.mSavedCropTop + (targetCropRight - this.mSavedCropLeft) / this.mCropRatio;
                            this.saveTouchDownStates(event);
                        }
                        this.mCropRect.bottom = targetCropBottom;
                        this.mCropRect.right = targetCropRight;
                    }
                } else {
                    if (this.mAdjustLeftEdge) {
                        float targetCropLeft = this.mSavedCropLeft + dx;
                        if (targetCropLeft > this.mSavedCropRight - this.mMinCropRectSideLength) {
                            targetCropLeft = this.mSavedCropRight - this.mMinCropRectSideLength;
                            this.saveTouchDownStates(event);
                        }
                        if (targetCropLeft < this.mBitmapRect.left) {
                            targetCropLeft = this.mBitmapRect.left;
                            this.saveTouchDownStates(event);
                        }
                        this.mCropRect.left = targetCropLeft;
                    }
                    if (this.mAdjustTopEdge) {
                        float targetCropTop = this.mSavedCropTop + dy;
                        if (targetCropTop > this.mSavedCropBottom - this.mMinCropRectSideLength) {
                            targetCropTop = this.mSavedCropBottom - this.mMinCropRectSideLength;
                            this.saveTouchDownStates(event);
                        }
                        if (targetCropTop < this.mBitmapRect.top) {
                            targetCropTop = this.mBitmapRect.top;
                            this.saveTouchDownStates(event);
                        }
                        this.mCropRect.top = targetCropTop;
                    }
                    if (this.mAdjustRightEdge) {
                        float targetCropRight = this.mSavedCropRight + dx;
                        if (targetCropRight < this.mSavedCropLeft + this.mMinCropRectSideLength) {
                            targetCropRight = this.mSavedCropLeft + this.mMinCropRectSideLength;
                            this.saveTouchDownStates(event);
                        }
                        if (targetCropRight > this.mBitmapRect.right) {
                            targetCropRight = this.mBitmapRect.right;
                            this.saveTouchDownStates(event);
                        }
                        this.mCropRect.right = targetCropRight;
                    }
                    if (this.mAdjustBottomEdge) {
                        float targetCropBottom = this.mSavedCropBottom + dy;
                        if (targetCropBottom < this.mSavedCropTop + this.mMinCropRectSideLength) {
                            targetCropBottom = this.mSavedCropTop + this.mMinCropRectSideLength;
                            this.saveTouchDownStates(event);
                        }
                        if (targetCropBottom > this.mBitmapRect.bottom) {
                            targetCropBottom = this.mBitmapRect.bottom;
                            this.saveTouchDownStates(event);
                        }
                        this.mCropRect.bottom = targetCropBottom;
                    }
                }
                this.setCropDrawableRect(true);
            }
        }
        return true;
    }

    public boolean getMultiSamplingEnabled() {
        return this.mPaint.isFilterBitmap();
    }

    public void setMultiSamplingEnabled(boolean enabled) {
        this.mPaint.setFilterBitmap(enabled);
    }

    private void setCropDrawableRect(boolean invalidate) {
        this.mCropRectInt.left = (int)(this.mCropRect.left + 0.5f);
        this.mCropRectInt.top = (int)(this.mCropRect.top + 0.5f);
        this.mCropRectInt.right = (int)(this.mCropRect.right + 0.5f);
        this.mCropRectInt.bottom = (int)(this.mCropRect.bottom + 0.5f);
        this.mCropDrawable.setBounds(this.mCropRectInt);
        if (invalidate) {
            this.invalidate();
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.mBitmap == null || this.mCropDrawable == null) {
            return;
        }
        canvas.drawBitmap(this.mBitmap, null, this.mBitmapRect, this.mPaint);
        this.setCropDrawableRect(false);
        if (this.mCoverDrawable != null) {
            if (this.mCoverDrawable instanceof ColorDrawable) {
                this.mCoverDrawable.setBounds(0, 0, this.getWidth(), this.mCropRectInt.top);
                this.mCoverDrawable.draw(canvas);
                this.mCoverDrawable.setBounds(0, this.mCropRectInt.top, this.mCropRectInt.left, this.mCropRectInt.bottom);
                this.mCoverDrawable.draw(canvas);
                this.mCoverDrawable.setBounds(this.mCropRectInt.right, this.mCropRectInt.top, this.getWidth(), this.mCropRectInt.bottom);
                this.mCoverDrawable.draw(canvas);
                this.mCoverDrawable.setBounds(0, this.mCropRectInt.bottom, this.getWidth(), this.getHeight());
                this.mCoverDrawable.draw(canvas);
            } else {
                canvas.save();
                canvas.clipRect(this.mCropRectInt, Region.Op.DIFFERENCE);
                this.mCoverDrawable.setBounds(0, 0, this.getWidth(), this.getHeight());
                this.mCoverDrawable.draw(canvas);
                canvas.restore();
            }
        }
        this.mCropDrawable.draw(canvas);
    }

    public RectF getCroppedRectF() {
        float x = (this.mCropRect.left - this.mBitmapRect.left) * (float)this.mBitmap.getWidth() / this.mBitmapRect.width();
        float y = (this.mCropRect.top - this.mBitmapRect.top) * (float)this.mBitmap.getHeight() / this.mBitmapRect.height();
        float w = this.mCropRect.width() * (float)this.mBitmap.getWidth() / this.mBitmapRect.width();
        float h = this.mCropRect.height() * (float)this.mBitmap.getHeight() / this.mBitmapRect.height();
        return new RectF(x, y, x + w, y + h);
    }

    public Rect getCroppedRect() {
        RectF rectf = this.getCroppedRectF();
        int l = (int)(rectf.left + 0.5f);
        int t = (int)(rectf.top + 0.5f);
        int r = (int)(rectf.right + 0.5f);
        int b = (int)(rectf.bottom + 0.5f);
        return new Rect(l, t, r, b);
    }

    public Bitmap getCroppedBitmap() {
        Rect rect = this.getCroppedRect();
        int left = rect.left;
        int top = rect.top;
        int width = rect.width();
        int height = rect.height();
        return Bitmap.createBitmap((Bitmap)this.mBitmap, (int)left, (int)top, (int)width, (int)height);
    }
}

