/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import site.iway.androidhelpers.R;
import site.iway.javahelpers.ArrayHelper;
import site.iway.javahelpers.MathHelper;

public class GestureLockIndicator
extends View {
    private static final int ROW_COUNT = 3;
    private static final int COL_COUNT = 3;
    private Drawable mNormalDrawable;
    private Drawable mSelectedDrawable;
    private int[] mRoute;

    public GestureLockIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.resolveAttrs(context, attrs);
    }

    public GestureLockIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public GestureLockIndicator(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    public Drawable getNormalDrawable() {
        return this.mNormalDrawable;
    }

    public void setNormalDrawable(Drawable normalDrawable) {
        this.mNormalDrawable = normalDrawable;
    }

    public void setNormalDrawableResource(int resource) {
        this.mNormalDrawable = this.getResources().getDrawable(resource);
    }

    public Drawable getSelectedDrawable() {
        return this.mSelectedDrawable;
    }

    public void setSelectedDrawable(Drawable selectedDrawable) {
        this.mSelectedDrawable = selectedDrawable;
    }

    public void setSelectedDrawableResource(int resource) {
        this.mSelectedDrawable = this.getResources().getDrawable(resource);
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GestureLockIndicator);
        this.mNormalDrawable = a.getDrawable(R.styleable.GestureLockIndicator_normalDrawable);
        this.mSelectedDrawable = a.getDrawable(R.styleable.GestureLockIndicator_selectedDrawable);
        a.recycle();
    }

    public int[] getRoute() {
        return this.mRoute;
    }

    public void setRoute(int[] route) {
        this.mRoute = route;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mNormalDrawable == null) {
            return;
        }
        if (this.mSelectedDrawable == null) {
            return;
        }
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int drawableBottom;
                int drawableTop;
                int drawableRight;
                int drawableLeft;
                float drawableHeight;
                float drawableWidth;
                float drawableCenterX = viewWidth / 3.0f * ((float)col + 0.5f);
                float drawableCenterY = viewHeight / 3.0f * ((float)row + 0.5f);
                int drawablePoint = row * 3 + col;
                if (this.mRoute != null && ArrayHelper.contains((int[])this.mRoute, (int)drawablePoint)) {
                    drawableWidth = this.mSelectedDrawable.getIntrinsicWidth();
                    drawableHeight = this.mSelectedDrawable.getIntrinsicHeight();
                    drawableLeft = MathHelper.pixel((float)(drawableCenterX - drawableWidth / 2.0f));
                    drawableRight = MathHelper.pixel((float)(drawableCenterX + drawableWidth / 2.0f));
                    drawableTop = MathHelper.pixel((float)(drawableCenterY - drawableHeight / 2.0f));
                    drawableBottom = MathHelper.pixel((float)(drawableCenterY + drawableHeight / 2.0f));
                    this.mSelectedDrawable.setBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
                    this.mSelectedDrawable.draw(canvas);
                    continue;
                }
                drawableWidth = this.mNormalDrawable.getIntrinsicWidth();
                drawableHeight = this.mNormalDrawable.getIntrinsicHeight();
                drawableLeft = MathHelper.pixel((float)(drawableCenterX - drawableWidth / 2.0f));
                drawableRight = MathHelper.pixel((float)(drawableCenterX + drawableWidth / 2.0f));
                drawableTop = MathHelper.pixel((float)(drawableCenterY - drawableHeight / 2.0f));
                drawableBottom = MathHelper.pixel((float)(drawableCenterY + drawableHeight / 2.0f));
                this.mNormalDrawable.setBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
                this.mNormalDrawable.draw(canvas);
            }
        }
    }
}

