/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import site.iway.androidhelpers.R;
import site.iway.javahelpers.ArrayHelper;
import site.iway.javahelpers.AutoExpandIntArray;
import site.iway.javahelpers.MathHelper;

public class GestureLock
extends View {
    private static final int ROW_COUNT = 3;
    private static final int COL_COUNT = 3;
    private GestureLockListener mListener;
    private Drawable mNormalDrawable;
    private Drawable mSelectedDrawable;
    private Drawable mErrorDrawable;
    private boolean mIsShowingError;
    private int mRouteColorSelected;
    private int mRouteColorError;
    private float mRouteWidth;
    private float mRouteShrink;
    private float mTouchDetectRadius;
    private boolean mSuperHandledTouchEvent;
    private AutoExpandIntArray mRoute;
    private float mTouchingX;
    private float mTouchingY;
    private Handler mHandler;
    private Paint mPaint;
    private int[] mEmptyRoute;

    public GestureLock(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.resolveAttrs(context, attrs);
    }

    public GestureLock(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public GestureLock(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    public GestureLockListener getListener() {
        return this.mListener;
    }

    public void setListener(GestureLockListener listener) {
        this.mListener = listener;
    }

    public Drawable getNormalDrawable() {
        return this.mNormalDrawable;
    }

    public void setNormalDrawable(Drawable normalDrawable) {
        this.mNormalDrawable = normalDrawable;
    }

    public void setNormalDrawableResource(int resource) {
        this.mNormalDrawable = this.getResources().getDrawable(resource);
    }

    public Drawable getSelectedDrawable() {
        return this.mSelectedDrawable;
    }

    public void setSelectedDrawable(Drawable selectedDrawable) {
        this.mSelectedDrawable = selectedDrawable;
    }

    public void setSelectedDrawableResource(int resource) {
        this.mSelectedDrawable = this.getResources().getDrawable(resource);
    }

    public Drawable getErrorDrawable() {
        return this.mErrorDrawable;
    }

    public void setErrorDrawable(Drawable errorDrawable) {
        this.mErrorDrawable = errorDrawable;
    }

    public void setErrorDrawableResource(int resource) {
        this.mErrorDrawable = this.getResources().getDrawable(resource);
    }

    public int getRouteColorSelected() {
        return this.mRouteColorSelected;
    }

    public void setRouteColorSelected(int routeColorSelected) {
        this.mRouteColorSelected = routeColorSelected;
    }

    public int getRouteColorError() {
        return this.mRouteColorError;
    }

    public void setRouteColorError(int routeColorError) {
        this.mRouteColorError = routeColorError;
    }

    public float getRouteWidth() {
        return this.mRouteWidth;
    }

    public void setRouteWidth(float routeWidth) {
        this.mRouteWidth = routeWidth;
    }

    public float getRouteShrink() {
        return this.mRouteShrink;
    }

    public void setRouteShrink(float routeShrink) {
        this.mRouteShrink = routeShrink;
    }

    public float getTouchDetectRadius() {
        return this.mTouchDetectRadius;
    }

    public void setTouchDetectRadius(float touchDetectRadius) {
        this.mTouchDetectRadius = touchDetectRadius;
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.GestureLock);
        this.mNormalDrawable = a.getDrawable(R.styleable.GestureLock_normalDrawable);
        this.mSelectedDrawable = a.getDrawable(R.styleable.GestureLock_selectedDrawable);
        this.mErrorDrawable = a.getDrawable(R.styleable.GestureLock_errorDrawable);
        this.mRouteColorSelected = a.getColor(R.styleable.GestureLock_routeColorSelected, 0);
        this.mRouteColorError = a.getColor(R.styleable.GestureLock_routeColorError, 0);
        this.mRouteWidth = a.getDimension(R.styleable.GestureLock_routeWidth, 0.0f);
        this.mRouteShrink = a.getDimension(R.styleable.GestureLock_routeShrink, 0.0f);
        this.mTouchDetectRadius = a.getDimension(R.styleable.GestureLock_touchDetectRadius, 0.0f);
        a.recycle();
    }

    private boolean onSuperTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        } else if (this.mSuperHandledTouchEvent) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        }
        return this.mSuperHandledTouchEvent;
    }

    private void addRoutePoint(int row, int col) {
        int drawablePoint = row * 3 + col;
        if (!this.mRoute.has(drawablePoint)) {
            this.mRoute.add(drawablePoint);
            if (this.mListener != null) {
                int[] route = this.mRoute.getOutArray();
                this.mListener.onGesturePointAdded(route);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = this.onSuperTouchEvent(event);
        if (this.mIsShowingError) {
            return result;
        }
        if (this.mNormalDrawable == null) {
            return result;
        }
        if (this.mErrorDrawable == null) {
            return result;
        }
        int action = event.getAction();
        this.mTouchingX = event.getX();
        this.mTouchingY = event.getY();
        switch (action) {
            case 0: {
                if (this.mRoute == null) {
                    this.mRoute = new AutoExpandIntArray(4);
                }
                this.mRoute.clear();
                if (this.mListener != null) {
                    this.mListener.onGestureLockBegin();
                }
            }
            case 2: {
                float viewWidth = this.getWidth();
                float viewHeight = this.getHeight();
                for (int row = 0; row < 3; ++row) {
                    for (int col = 0; col < 3; ++col) {
                        float drawableCenterX = viewWidth / 3.0f * ((float)col + 0.5f);
                        float drawableCenterY = viewHeight / 3.0f * ((float)row + 0.5f);
                        if (this.mTouchDetectRadius <= 0.0f) {
                            boolean yOK;
                            float drawableWidth = this.mNormalDrawable.getIntrinsicWidth();
                            float drawableHeight = this.mNormalDrawable.getIntrinsicHeight();
                            float drawableLeft = drawableCenterX - drawableWidth / 2.0f;
                            float drawableRight = drawableCenterX + drawableWidth / 2.0f;
                            float drawableTop = drawableCenterY - drawableHeight / 2.0f;
                            float drawableBottom = drawableCenterY + drawableHeight / 2.0f;
                            boolean xOK = this.mTouchingX > drawableLeft && this.mTouchingX < drawableRight;
                            boolean bl = yOK = this.mTouchingY > drawableTop && this.mTouchingY < drawableBottom;
                            if (!xOK || !yOK) continue;
                            this.addRoutePoint(row, col);
                            continue;
                        }
                        float dx = this.mTouchingX - drawableCenterX;
                        float dy = this.mTouchingY - drawableCenterY;
                        if (!(MathHelper.distance((double)dx, (double)dy) < (double)this.mTouchDetectRadius)) continue;
                        this.addRoutePoint(row, col);
                    }
                }
                break;
            }
            case 1: {
                if (this.mListener != null) {
                    int[] route = this.mRoute.getOutArray();
                    boolean isGestureRight = this.mListener.onGestureLockFinish(route);
                    if (isGestureRight) {
                        this.mRoute.clear();
                        break;
                    }
                    if (this.mErrorDrawable != null) {
                        if (this.mHandler == null) {
                            this.mHandler = new Handler();
                        }
                        this.mIsShowingError = true;
                        this.mHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                GestureLock.this.mIsShowingError = false;
                                GestureLock.this.mRoute.clear();
                                GestureLock.this.invalidate();
                            }
                        }, 1000L);
                        break;
                    }
                    this.mRoute.clear();
                    break;
                }
                this.mRoute.clear();
            }
        }
        this.invalidate();
        return true;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mNormalDrawable == null) {
            return;
        }
        if (this.mSelectedDrawable == null) {
            return;
        }
        if (this.mErrorDrawable == null) {
            return;
        }
        if (this.mPaint == null) {
            this.mPaint = new Paint();
            this.mPaint.setAntiAlias(true);
            this.mPaint.setDither(true);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setFilterBitmap(true);
            this.mPaint.setStrokeJoin(Paint.Join.ROUND);
            this.mPaint.setStrokeCap(Paint.Cap.ROUND);
            this.mPaint.setStrokeWidth(this.mRouteWidth);
        }
        this.mPaint.setColor(this.mIsShowingError ? this.mRouteColorError : this.mRouteColorSelected);
        if (this.mEmptyRoute == null) {
            this.mEmptyRoute = new int[0];
        }
        int[] route = this.mRoute == null ? this.mEmptyRoute : this.mRoute.getOutArray();
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        for (int i = 0; i < route.length; ++i) {
            float distance;
            float dy;
            float dx;
            float stopY;
            float stopX;
            float startX = viewWidth * ((float)(route[i] % 3) + 0.5f) / 3.0f;
            float startY = viewHeight * ((float)(route[i] / 3) + 0.5f) / 3.0f;
            if (i + 1 == route.length) {
                stopX = this.mTouchingX;
                stopY = this.mTouchingY;
                if (this.mRouteShrink > 0.0f) {
                    dx = stopX - startX;
                    dy = stopY - startY;
                    distance = (float)MathHelper.distance((double)dx, (double)dy);
                    if (!(distance > this.mRouteShrink)) continue;
                    canvas.drawLine(startX += this.mRouteShrink / distance * dx, startY += this.mRouteShrink / distance * dy, stopX, stopY, this.mPaint);
                    continue;
                }
                canvas.drawLine(startX, startY, stopX, stopY, this.mPaint);
                continue;
            }
            stopX = viewWidth * ((float)(route[i + 1] % 3) + 0.5f) / 3.0f;
            stopY = viewHeight * ((float)(route[i + 1] / 3) + 0.5f) / 3.0f;
            if (this.mRouteShrink > 0.0f) {
                dx = stopX - startX;
                dy = stopY - startY;
                distance = (float)MathHelper.distance((double)dx, (double)dy);
                if (!(distance > this.mRouteShrink * 2.0f)) continue;
                canvas.drawLine(startX += this.mRouteShrink / distance * dx, startY += this.mRouteShrink / distance * dy, stopX -= this.mRouteShrink / distance * dx, stopY -= this.mRouteShrink / distance * dy, this.mPaint);
                continue;
            }
            canvas.drawLine(startX, startY, stopX, stopY, this.mPaint);
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                float drawableCenterX = viewWidth / 3.0f * ((float)col + 0.5f);
                float drawableCenterY = viewHeight / 3.0f * ((float)row + 0.5f);
                int drawablePoint = row * 3 + col;
                if (ArrayHelper.contains((int[])route, (int)drawablePoint)) {
                    Drawable drawable = this.mIsShowingError ? this.mErrorDrawable : this.mSelectedDrawable;
                    float drawableWidth = drawable.getIntrinsicWidth();
                    float drawableHeight = drawable.getIntrinsicHeight();
                    int drawableLeft = MathHelper.pixel((float)(drawableCenterX - drawableWidth / 2.0f));
                    int drawableRight = MathHelper.pixel((float)(drawableCenterX + drawableWidth / 2.0f));
                    int drawableTop = MathHelper.pixel((float)(drawableCenterY - drawableHeight / 2.0f));
                    int drawableBottom = MathHelper.pixel((float)(drawableCenterY + drawableHeight / 2.0f));
                    drawable.setBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
                    drawable.draw(canvas);
                    continue;
                }
                float drawableWidth = this.mNormalDrawable.getIntrinsicWidth();
                float drawableHeight = this.mNormalDrawable.getIntrinsicHeight();
                int drawableLeft = MathHelper.pixel((float)(drawableCenterX - drawableWidth / 2.0f));
                int drawableRight = MathHelper.pixel((float)(drawableCenterX + drawableWidth / 2.0f));
                int drawableTop = MathHelper.pixel((float)(drawableCenterY - drawableHeight / 2.0f));
                int drawableBottom = MathHelper.pixel((float)(drawableCenterY + drawableHeight / 2.0f));
                this.mNormalDrawable.setBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
                this.mNormalDrawable.draw(canvas);
            }
        }
    }

    public static interface GestureLockListener {
        public void onGestureLockBegin();

        public void onGesturePointAdded(int[] var1);

        public boolean onGestureLockFinish(int[] var1);
    }
}

