/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.ViewSelector;
import site.iway.javahelpers.YAlign;

public class FlowLayout
extends ViewGroup {
    private ViewSelector mViewSelector;
    private YAlign mLineAlignment;
    private int mHorizontalSpacing;
    private int mVerticalSpacing;
    private boolean mSuperHandledTouchEvent;

    public FlowLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.resolveAttrs(context, attrs);
    }

    public FlowLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public FlowLayout(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    public int[] getSelectIndices() {
        return this.mViewSelector.getSelectIndices();
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FlowLayout);
        boolean enableTouchSelect = a.getBoolean(R.styleable.FlowLayout_enableTouchSelect, false);
        boolean multipleSelectMode = a.getBoolean(R.styleable.FlowLayout_multipleSelectMode, false);
        this.mViewSelector = new ViewSelector(this, enableTouchSelect, multipleSelectMode, false);
        int lineAlignment = a.getInt(R.styleable.FlowLayout_lineAlignment, 0);
        switch (lineAlignment) {
            case 0: {
                this.mLineAlignment = YAlign.TopTop;
                break;
            }
            case 1: {
                this.mLineAlignment = YAlign.TopCenter;
                break;
            }
            case 2: {
                this.mLineAlignment = YAlign.TopBottom;
                break;
            }
            case 3: {
                this.mLineAlignment = YAlign.CenterTop;
                break;
            }
            case 4: {
                this.mLineAlignment = YAlign.CenterCenter;
                break;
            }
            case 5: {
                this.mLineAlignment = YAlign.CenterBottom;
                break;
            }
            case 6: {
                this.mLineAlignment = YAlign.BottomTop;
                break;
            }
            case 7: {
                this.mLineAlignment = YAlign.BottomCenter;
                break;
            }
            case 8: {
                this.mLineAlignment = YAlign.BottomBottom;
            }
        }
        this.mHorizontalSpacing = a.getDimensionPixelSize(R.styleable.FlowLayout_horizontalSpacing, 0);
        this.mVerticalSpacing = a.getDimensionPixelSize(R.styleable.FlowLayout_verticalSpacing, 0);
        a.recycle();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new ViewGroup.MarginLayoutParams(p);
    }

    public YAlign getLineAlignment() {
        return this.mLineAlignment;
    }

    public void setLineAlignment(YAlign alignment) {
        this.mLineAlignment = alignment;
    }

    public int getHorizontalSpacing() {
        return this.mHorizontalSpacing;
    }

    public void setHorizontalSpacing(int spacing) {
        if (spacing >= 0) {
            this.mHorizontalSpacing = spacing;
        }
    }

    public int getVerticalSpacing() {
        return this.mVerticalSpacing;
    }

    public void setVerticalSpacing(int spacing) {
        if (spacing >= 0) {
            this.mVerticalSpacing = spacing;
        }
    }

    private int computeWidth(List<Integer> widths) {
        int maxWidth = 0;
        for (Integer width : widths) {
            maxWidth = Math.max(maxWidth, width);
        }
        return maxWidth + this.getPaddingLeft() + this.getPaddingRight();
    }

    private int computeHeight(List<Integer> heights) {
        int heightSum = 0;
        for (Integer height : heights) {
            heightSum += height.intValue();
        }
        int lineCount = heights.size();
        if (lineCount > 1) {
            heightSum += (lineCount - 1) * this.mVerticalSpacing;
        }
        return heightSum + this.getPaddingTop() + this.getPaddingBottom();
    }

    private List<View> getVisibleChildViews() {
        ArrayList<View> visibleChildViews = new ArrayList<View>();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            int childViewVisibility = childView.getVisibility();
            if (childViewVisibility == 8) continue;
            visibleChildViews.add(childView);
        }
        return visibleChildViews;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        ArrayList<Integer> widths = new ArrayList<Integer>();
        ArrayList<Integer> heights = new ArrayList<Integer>();
        int lineWidth = 0;
        int lineHeight = 0;
        List<View> visibleChildViews = this.getVisibleChildViews();
        int visibleChildViewCount = visibleChildViews.size();
        for (int i = 0; i < visibleChildViewCount; ++i) {
            View visibleChildView = visibleChildViews.get(i);
            this.measureChild(visibleChildView, widthMeasureSpec, heightMeasureSpec);
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)visibleChildView.getLayoutParams();
            int childWidth = visibleChildView.getMeasuredWidth() + mlp.leftMargin + mlp.rightMargin;
            int childHeight = visibleChildView.getMeasuredHeight() + mlp.topMargin + mlp.bottomMargin;
            if (i == 0) {
                lineWidth = childWidth;
                lineHeight = childHeight;
            } else if (lineWidth + this.mHorizontalSpacing + childWidth <= widthSize - paddingLeft - paddingRight) {
                lineWidth += this.mHorizontalSpacing + childWidth;
                lineHeight = Math.max(lineHeight, childHeight);
            } else {
                widths.add(lineWidth);
                heights.add(lineHeight);
                lineWidth = childWidth;
                lineHeight = childHeight;
            }
            if (i != visibleChildViewCount - 1) continue;
            widths.add(lineWidth);
            heights.add(lineHeight);
        }
        int computedWidth = this.computeWidth(widths);
        int computedHeight = this.computeHeight(heights);
        int measuredWidth = 0;
        int measuredHeight = 0;
        int minWidth = this.getSuggestedMinimumWidth();
        int minHeight = this.getSuggestedMinimumHeight();
        switch (widthMode) {
            case 0x40000000: {
                measuredWidth = widthSize;
                break;
            }
            case -2147483648: {
                measuredWidth = Math.max(computedWidth, minWidth);
                measuredWidth = Math.min(widthSize, measuredWidth);
                break;
            }
            case 0: {
                measuredWidth = Math.max(computedWidth, minWidth);
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                measuredHeight = heightSize;
                break;
            }
            case -2147483648: {
                measuredHeight = Math.max(computedHeight, minHeight);
                measuredHeight = Math.min(heightSize, measuredHeight);
                break;
            }
            case 0: {
                measuredHeight = Math.max(computedHeight, minHeight);
            }
        }
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    private void layoutLineViews(List<View> lineViews, int lineLeft, int lineTop, int lineWidth, int lineHeight) {
        for (View view : lineViews) {
            ViewGroup.MarginLayoutParams viewMLP = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
            int viewW = view.getMeasuredWidth() + viewMLP.leftMargin + viewMLP.rightMargin;
            int viewH = view.getMeasuredHeight() + viewMLP.topMargin + viewMLP.bottomMargin;
            int viewL = lineLeft + viewMLP.leftMargin;
            int viewT = this.mLineAlignment.getY(lineTop, lineHeight, viewH) + viewMLP.topMargin;
            int viewR = viewL + view.getMeasuredWidth();
            int viewB = viewT + view.getMeasuredHeight();
            view.layout(viewL, viewT, viewR, viewB);
            lineLeft += viewW + this.mHorizontalSpacing;
        }
        lineViews.clear();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int w = r - l;
        int h = b - t;
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int lineLeft = 0;
        int lineTop = 0;
        int lineWidth = 0;
        int lineHeight = 0;
        ArrayList<View> lineViews = new ArrayList<View>();
        List<View> visibleChildViews = this.getVisibleChildViews();
        int visibleChildViewCount = visibleChildViews.size();
        for (int i = 0; i < visibleChildViewCount; ++i) {
            View visibleChildView = visibleChildViews.get(i);
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)visibleChildView.getLayoutParams();
            int childWidth = visibleChildView.getMeasuredWidth() + mlp.leftMargin + mlp.rightMargin;
            int childHeight = visibleChildView.getMeasuredHeight() + mlp.topMargin + mlp.bottomMargin;
            if (i == 0) {
                lineLeft = paddingLeft;
                lineTop = paddingTop;
                lineWidth = childWidth;
                lineHeight = childHeight;
                lineViews.add(visibleChildView);
            } else if (lineWidth + this.mHorizontalSpacing + childWidth <= w - paddingLeft - paddingRight) {
                lineWidth += this.mHorizontalSpacing + childWidth;
                lineHeight = Math.max(lineHeight, childHeight);
                lineViews.add(visibleChildView);
            } else {
                this.layoutLineViews(lineViews, lineLeft, lineTop, lineWidth, lineHeight);
                lineLeft = paddingLeft;
                lineTop += lineHeight + this.mVerticalSpacing;
                lineWidth = childWidth;
                lineHeight = childHeight;
                lineViews.add(visibleChildView);
            }
            if (i != visibleChildViewCount - 1) continue;
            this.layoutLineViews(lineViews, lineLeft, lineTop, lineWidth, lineHeight);
        }
    }

    private boolean onSuperTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        } else if (this.mSuperHandledTouchEvent) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        }
        return this.mSuperHandledTouchEvent;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.onSuperTouchEvent(event) || this.mViewSelector.onTouchEvent(event);
    }
}

