/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import site.iway.javahelpers.CalendarHelper;
import site.iway.javahelpers.FileSystemHelper;
import site.iway.javahelpers.StringHelper;

public class FLog {
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int NONE = 8;
    private static File sLogDirectory;
    private static int sLogLevel;
    private static String sDefaultTag;
    private static List<String> sCachedRecords;
    private static Object sSynchronizer;
    private static boolean sPaused;
    private static FileOutputStream sOutputStream;
    private static PrintStream sPrintStream;

    public static void initialize(String logDirectory, int logLevel, String defaultTag) {
        sLogDirectory = new File(logDirectory);
        if (!FileSystemHelper.createDirectory((File)sLogDirectory)) {
            throw new RuntimeException("Create log directory failed.");
        }
        sLogLevel = logLevel;
        sDefaultTag = defaultTag;
        if (StringHelper.nullOrEmpty((String)sDefaultTag)) {
            sDefaultTag = "TF";
        }
        sCachedRecords = new ArrayList<String>();
        sSynchronizer = new Object();
        sPaused = true;
        FLog.resumeFileLog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logFile(String level, String tag, String message) {
        Object object = sSynchronizer;
        synchronized (object) {
            message = StringHelper.trim((String)message, (boolean)true, (boolean)true, (char[])new char[]{' ', '\n'});
            if (StringHelper.nullOrEmpty((String)message)) {
                return;
            }
            Calendar now = CalendarHelper.now();
            String nowString = CalendarHelper.format((Calendar)now, (String)"yyyy-MM-dd HH:mm:ss.SSS");
            message = nowString + " " + level + "/" + tag + " " + message;
            if (sPaused) {
                sCachedRecords.add(message);
            } else {
                sPrintStream.print(message);
                sPrintStream.println();
                sPrintStream.flush();
            }
        }
    }

    private static void log(int level, String tag, String msg, Throwable tr) {
        if (level >= sLogLevel) {
            if (tag == null) {
                tag = "";
            }
            if (msg == null) {
                msg = "";
            }
            if (tr != null) {
                msg = msg + "\n" + FLog.getStackTraceString(tr);
            }
            switch (level) {
                case 2: {
                    FLog.logFile("V", tag, msg);
                    Log.v((String)tag, (String)msg);
                    break;
                }
                case 3: {
                    FLog.logFile("D", tag, msg);
                    Log.d((String)tag, (String)msg);
                    break;
                }
                case 4: {
                    FLog.logFile("I", tag, msg);
                    Log.i((String)tag, (String)msg);
                    break;
                }
                case 5: {
                    FLog.logFile("W", tag, msg);
                    Log.w((String)tag, (String)msg);
                    break;
                }
                case 6: {
                    FLog.logFile("E", tag, msg);
                    Log.e((String)tag, (String)msg);
                }
            }
        }
    }

    private static void createStreams() {
        try {
            Calendar now = CalendarHelper.now();
            String fileName = CalendarHelper.format((Calendar)now, (String)"yyyyMMddHHmmssSSS");
            File logFile = new File(sLogDirectory, fileName);
            sOutputStream = new FileOutputStream(logFile, true);
            sPrintStream = new PrintStream(sOutputStream);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void closeStreams() {
        sPrintStream.close();
    }

    private static void flushRecords() {
        for (String record : sCachedRecords) {
            sPrintStream.print(record);
            sPrintStream.println();
        }
        sPrintStream.flush();
        sCachedRecords.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseFileLog() {
        Object object = sSynchronizer;
        synchronized (object) {
            if (sPaused) {
                return;
            }
            FLog.closeStreams();
            sPaused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resumeFileLog() {
        Object object = sSynchronizer;
        synchronized (object) {
            if (!sPaused) {
                return;
            }
            FLog.createStreams();
            FLog.flushRecords();
            sPaused = false;
        }
    }

    public static void v(String tag, String msg, Throwable tr) {
        FLog.log(2, tag, msg, tr);
    }

    public static void v(String tag, String msg) {
        FLog.v(tag, msg, null);
    }

    public static void v(String msg) {
        FLog.v(sDefaultTag, msg, null);
    }

    public static void v(String msg, Throwable tr) {
        FLog.v(sDefaultTag, msg, tr);
    }

    public static void d(String tag, String msg, Throwable tr) {
        FLog.log(3, tag, msg, tr);
    }

    public static void d(String tag, String msg) {
        FLog.d(tag, msg, null);
    }

    public static void d(String msg) {
        FLog.d(sDefaultTag, msg, null);
    }

    public static void d(String msg, Throwable tr) {
        FLog.d(sDefaultTag, msg, tr);
    }

    public static void i(String tag, String msg, Throwable tr) {
        FLog.log(4, tag, msg, tr);
    }

    public static void i(String tag, String msg) {
        FLog.i(tag, msg, null);
    }

    public static void i(String msg) {
        FLog.i(sDefaultTag, msg, null);
    }

    public static void i(String msg, Throwable tr) {
        FLog.i(sDefaultTag, msg, tr);
    }

    public static void w(String tag, String msg, Throwable tr) {
        FLog.log(5, tag, msg, tr);
    }

    public static void w(String tag, String msg) {
        FLog.w(tag, msg, null);
    }

    public static void w(String msg) {
        FLog.w(sDefaultTag, msg, null);
    }

    public static void w(String msg, Throwable tr) {
        FLog.w(sDefaultTag, msg, tr);
    }

    public static void e(String tag, String msg, Throwable tr) {
        FLog.log(6, tag, msg, tr);
    }

    public static void e(String tag, String msg) {
        FLog.e(tag, msg, null);
    }

    public static void e(String msg) {
        FLog.e(sDefaultTag, msg, null);
    }

    public static void e(String msg, Throwable tr) {
        FLog.e(sDefaultTag, msg, tr);
    }

    public static String getStackTraceString(Throwable tr) {
        return Log.getStackTraceString((Throwable)tr);
    }
}

