/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import java.lang.reflect.Field;
import site.iway.androidhelpers.ExtendedScroller;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.UITimer;

public class ExtendedViewPager
extends ViewPager {
    private boolean mAttachedToWindow;
    private UITimer mAutoSwitchTimer;
    private boolean mUserTouchable = true;
    private boolean mSuperHandledTouchEvent;

    public ExtendedViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedViewPager(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExtendedViewPager);
        int customizeScrollerDuration = a.getInt(R.styleable.ExtendedViewPager_customizeScrollDuration, 0);
        this.customizeScrollerDuration(customizeScrollerDuration);
        int autoSwitchTime = a.getInt(R.styleable.ExtendedViewPager_autoSwitchTime, 0);
        this.setAutoSwitchTime(autoSwitchTime);
        this.mUserTouchable = a.getBoolean(R.styleable.ExtendedViewPager_userTouchable, true);
        a.recycle();
    }

    public void customizeScrollerDuration(int customizedScrollerDuration) {
        try {
            if (customizedScrollerDuration > 0) {
                Context context = this.getContext();
                ExtendedScroller extendedScroller = new ExtendedScroller(context);
                extendedScroller.customizeDuration(customizedScrollerDuration);
                Field localField = ViewPager.class.getDeclaredField("mScroller");
                localField.setAccessible(true);
                localField.set((Object)this, (Object)extendedScroller);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public void setAutoSwitchTime(int millis) {
        if (millis > 0) {
            this.mAutoSwitchTimer = new UITimer(millis){

                @Override
                public void doOnUIThread() {
                    PagerAdapter adapter = ExtendedViewPager.this.getAdapter();
                    if (adapter == null || adapter.getCount() < 2) {
                        return;
                    }
                    int index = ExtendedViewPager.this.getCurrentItem();
                    int count = adapter.getCount();
                    if (++index >= count) {
                        index = 0;
                    }
                    ExtendedViewPager.this.setCurrentItem(index);
                }
            };
            if (this.mAttachedToWindow) {
                this.mAutoSwitchTimer.start(false);
            }
        } else if (this.mAutoSwitchTimer != null) {
            this.mAutoSwitchTimer.stop();
            this.mAutoSwitchTimer = null;
        }
    }

    public void setUserTouchable(boolean userTouchable) {
        this.mUserTouchable = userTouchable;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mUserTouchable) {
            return super.onInterceptTouchEvent(ev);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean result = super.onTouchEvent(ev);
        if (this.mAutoSwitchTimer != null) {
            int action = ev.getAction();
            switch (action) {
                case 0: {
                    this.mAutoSwitchTimer.stop();
                    return true;
                }
                case 1: 
                case 3: {
                    this.mAutoSwitchTimer.start(false);
                }
            }
        }
        return result;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        if (this.mAutoSwitchTimer != null) {
            this.mAutoSwitchTimer.start(false);
            this.mAutoSwitchTimer = null;
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mAutoSwitchTimer != null) {
            this.mAutoSwitchTimer.stop();
            this.mAutoSwitchTimer = null;
        }
        this.mAttachedToWindow = false;
        super.onDetachedFromWindow();
    }
}

