/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.TextView;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.TypefaceHelper;

public class ExtendedTextView
extends TextView {
    private boolean mDrawRoundRect;
    private int mRoundRectColor;
    private float mRoundRectRadius;
    private boolean mDrawRoundRectIncludePadding;
    private Drawable mLineDrawable;
    private int mLineDrawableHeight;
    private int mLineDrawableOffset;
    private Animation mTouchDownAnimation;
    private Animation mTouchUpAnimation;
    private int mTextPressAlpha;
    private int mDrawablePressAlpha;
    private int mFilterClickSpan;
    private boolean mLastPressed;
    private Paint mRoundRectPaint;
    private RectF mRoundRect;
    private Rect mRect = new Rect();
    private View mClearView;

    public ExtendedTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedTextView(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    public boolean isDrawRoundRect() {
        return this.mDrawRoundRect;
    }

    public void setDrawRoundRect(boolean drawRoundRect) {
        this.mDrawRoundRect = drawRoundRect;
        this.invalidate();
    }

    public int getRoundRectColor() {
        return this.mRoundRectColor;
    }

    public void setRoundRectColor(int roundRectColor) {
        this.mRoundRectColor = roundRectColor;
        this.invalidate();
    }

    public float getRoundRectRadius() {
        return this.mRoundRectRadius;
    }

    public void setRoundRectRadius(float roundRectRadius) {
        this.mRoundRectRadius = roundRectRadius;
        this.invalidate();
    }

    public boolean isDrawRoundRectIncludePadding() {
        return this.mDrawRoundRectIncludePadding;
    }

    public void setDrawRoundRectIncludePadding(boolean drawRoundRectIncludePadding) {
        this.mDrawRoundRectIncludePadding = drawRoundRectIncludePadding;
    }

    public Drawable getLineDrawable() {
        return this.mLineDrawable;
    }

    public void setLineDrawable(Drawable drawable) {
        this.mLineDrawable = drawable;
        this.invalidate();
    }

    public void setLineDrawable(int resourceId) {
        Drawable drawable = this.getContext().getResources().getDrawable(resourceId);
        this.setLineDrawable(drawable);
    }

    public int getLineDrawableHeight() {
        return this.mLineDrawableHeight;
    }

    public void setLineDrawableHeight(int lineDrawableHeight) {
        this.mLineDrawableHeight = lineDrawableHeight;
        this.invalidate();
    }

    public int getLineDrawableOffset() {
        return this.mLineDrawableOffset;
    }

    public void setLineDrawableOffset(int lineDrawableOffset) {
        this.mLineDrawableOffset = lineDrawableOffset;
        this.invalidate();
    }

    public void setTouchDownAnimation(Animation animation) {
        this.mTouchDownAnimation = animation;
    }

    public void setTouchDownAnimation(int resourceId) {
        if (resourceId != 0) {
            Context context = this.getContext();
            Animation animation = AnimationUtils.loadAnimation((Context)context, (int)resourceId);
            this.setTouchDownAnimation(animation);
        }
    }

    public void setTouchUpAnimation(Animation animation) {
        this.mTouchUpAnimation = animation;
    }

    public void setTouchUpAnimation(int resourceId) {
        if (resourceId != 0) {
            Context context = this.getContext();
            Animation animation = AnimationUtils.loadAnimation((Context)context, (int)resourceId);
            this.setTouchUpAnimation(animation);
        }
    }

    public void setTextPressAlpha(int textPressAlpha) {
        this.mTextPressAlpha = textPressAlpha;
    }

    public void setDrawablePressAlpha(int drawablePressAlpha) {
        this.mDrawablePressAlpha = drawablePressAlpha;
    }

    public void setOnClickListener(final View.OnClickListener l) {
        if (this.mFilterClickSpan > 0) {
            View.OnClickListener wrapper = new View.OnClickListener(){
                private long mLastClickTime;

                public void onClick(View v) {
                    long now = System.currentTimeMillis();
                    if (now - this.mLastClickTime > (long)ExtendedTextView.this.mFilterClickSpan) {
                        this.mLastClickTime = System.currentTimeMillis();
                        l.onClick(v);
                    }
                }
            };
            super.setOnClickListener(wrapper);
        } else {
            super.setOnClickListener(l);
        }
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExtendedTextView);
        String typeFaceAssetPath = a.getString(R.styleable.ExtendedTextView_typeFaceAssetPath);
        Typeface typeface = TypefaceHelper.get(context, typeFaceAssetPath);
        if (typeface != null) {
            Typeface oldTypeface = this.getTypeface();
            if (oldTypeface != null) {
                int oldTypefaceStyle = oldTypeface.getStyle();
                this.setTypeface(typeface, oldTypefaceStyle);
            } else {
                this.setTypeface(typeface);
            }
        }
        this.mDrawRoundRect = a.getBoolean(R.styleable.ExtendedTextView_drawRoundRect, false);
        this.mRoundRectColor = a.getColor(R.styleable.ExtendedTextView_roundRectColor, 0);
        this.mRoundRectRadius = a.getDimension(R.styleable.ExtendedTextView_roundRectRadius, 0.0f);
        this.mDrawRoundRectIncludePadding = a.getBoolean(R.styleable.ExtendedTextView_drawRoundRectIncludePadding, false);
        this.mLineDrawable = a.getDrawable(R.styleable.ExtendedTextView_lineDrawable);
        this.mLineDrawableHeight = a.getDimensionPixelSize(R.styleable.ExtendedTextView_lineDrawableHeight, 1);
        this.mLineDrawableOffset = a.getDimensionPixelSize(R.styleable.ExtendedTextView_lineDrawableOffset, 0);
        this.setTouchDownAnimation(a.getResourceId(R.styleable.ExtendedTextView_touchDownAnimation, 0));
        this.setTouchUpAnimation(a.getResourceId(R.styleable.ExtendedTextView_touchUpAnimation, 0));
        this.mTextPressAlpha = a.getInt(R.styleable.ExtendedTextView_textPressAlpha, -1);
        this.mDrawablePressAlpha = a.getInt(R.styleable.ExtendedTextView_drawablePressAlpha, -1);
        this.mFilterClickSpan = a.getInt(R.styleable.ExtendedTextView_filterClickSpan, 0);
        a.recycle();
    }

    public void setPressed(boolean pressed) {
        if (this.mLastPressed != pressed) {
            int textColor = this.getCurrentTextColor();
            int red = Color.red((int)textColor);
            int green = Color.green((int)textColor);
            int blue = Color.blue((int)textColor);
            int textColorHint = this.getCurrentHintTextColor();
            int redHint = Color.red((int)textColorHint);
            int greenHint = Color.green((int)textColorHint);
            int blueHint = Color.blue((int)textColorHint);
            Drawable[] drawables = this.getCompoundDrawables();
            if (pressed) {
                if (this.mTextPressAlpha >= 0 && this.mTextPressAlpha <= 255) {
                    this.setTextColor(Color.argb((int)this.mTextPressAlpha, (int)red, (int)green, (int)blue));
                    this.setHintTextColor(Color.argb((int)this.mTextPressAlpha, (int)redHint, (int)greenHint, (int)blueHint));
                }
                for (Drawable drawable : drawables) {
                    if (drawable == null || this.mDrawablePressAlpha < 0 || this.mDrawablePressAlpha > 255) continue;
                    drawable.setAlpha(this.mDrawablePressAlpha);
                }
                if (this.mTouchDownAnimation != null) {
                    this.startAnimation(this.mTouchDownAnimation);
                }
            } else {
                if (this.mTextPressAlpha >= 0 && this.mTextPressAlpha <= 255) {
                    this.setTextColor(Color.argb((int)255, (int)red, (int)green, (int)blue));
                    this.setHintTextColor(Color.argb((int)255, (int)redHint, (int)greenHint, (int)blueHint));
                }
                for (Drawable drawable : drawables) {
                    if (drawable == null || this.mDrawablePressAlpha < 0 || this.mDrawablePressAlpha > 255) continue;
                    drawable.setAlpha(255);
                }
                if (this.mTouchDownAnimation != null) {
                    this.startAnimation(this.mTouchUpAnimation);
                }
            }
        }
        super.setPressed(pressed);
        this.mLastPressed = pressed;
    }

    protected void onDraw(Canvas canvas) {
        if (this.mDrawRoundRect) {
            if (this.mRoundRect == null) {
                this.mRoundRect = new RectF();
            }
            if (this.mRoundRectPaint == null) {
                this.mRoundRectPaint = new Paint();
                this.mRoundRectPaint.setAntiAlias(true);
                this.mRoundRectPaint.setDither(true);
            }
            if (this.mRoundRectColor != 0) {
                if (this.mDrawRoundRectIncludePadding) {
                    this.mRoundRect.left = this.getPaddingLeft();
                    this.mRoundRect.top = this.getPaddingTop();
                    this.mRoundRect.right = this.getWidth() - this.getPaddingRight();
                    this.mRoundRect.bottom = this.getHeight() - this.getPaddingBottom();
                } else {
                    this.mRoundRect.left = 0.0f;
                    this.mRoundRect.top = 0.0f;
                    this.mRoundRect.right = this.getWidth();
                    this.mRoundRect.bottom = this.getHeight();
                }
                this.mRoundRectPaint.setStyle(Paint.Style.FILL);
                this.mRoundRectPaint.setColor(this.mRoundRectColor);
                canvas.drawRoundRect(this.mRoundRect, this.mRoundRectRadius, this.mRoundRectRadius, this.mRoundRectPaint);
            }
        }
        super.onDraw(canvas);
        if (this.mLineDrawable != null) {
            int lineCount = this.getLineCount();
            for (int i = 0; i < lineCount; ++i) {
                this.getLineBounds(i, this.mRect);
                float top = this.mRect.bottom - this.mLineDrawableHeight + this.mLineDrawableOffset;
                float bottom = this.mRect.bottom + this.mLineDrawableOffset;
                this.mLineDrawable.setBounds(this.mRect.left, (int)top, this.mRect.right, (int)bottom);
                this.mLineDrawable.draw(canvas);
            }
        }
    }

    public void setClearView(View view) {
        this.mClearView = view;
        this.mClearView.setVisibility(TextUtils.isEmpty((CharSequence)this.getText()) ? 8 : 0);
        this.mClearView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ExtendedTextView.this.setText(null);
            }
        });
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        if (this.mClearView != null) {
            this.mClearView.setVisibility(TextUtils.isEmpty((CharSequence)text) ? 8 : 0);
        }
    }
}

