/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ScrollView;
import site.iway.androidhelpers.OnScrollChangedListener;
import site.iway.androidhelpers.R;

public class ExtendedScrollView
extends ScrollView {
    private boolean mFlingable = true;
    private OnScrollChangedListener mOnScrollChangedListener;

    public ExtendedScrollView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedScrollView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedScrollView(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExtendedScrollView);
        this.mFlingable = a.getBoolean(R.styleable.ExtendedScrollView_flingable, true);
        a.recycle();
    }

    public void setFlingable(boolean flingable) {
        this.mFlingable = flingable;
    }

    public boolean getFlingable() {
        return this.mFlingable;
    }

    public void fling(int velocityY) {
        if (this.mFlingable) {
            super.fling(velocityY);
        }
    }

    public void setOnScrollChangedListener(OnScrollChangedListener l) {
        this.mOnScrollChangedListener = l;
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.mOnScrollChangedListener != null) {
            this.mOnScrollChangedListener.onScrollChanged((View)this, l, t, oldl, oldt);
        }
    }
}

