/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.ViewSelector;

public class ExtendedRelativeLayout
extends RelativeLayout {
    private ViewSelector mViewSelector;
    private boolean mSuperHandledTouchEvent;

    public ExtendedRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedRelativeLayout(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    public int[] getSelectIndices() {
        return this.mViewSelector.getSelectIndices();
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExtendedRelativeLayout);
        boolean enableTouchSelect = a.getBoolean(R.styleable.ExtendedRelativeLayout_enableTouchSelect, false);
        boolean multipleSelectMode = a.getBoolean(R.styleable.ExtendedRelativeLayout_multipleSelectMode, false);
        this.mViewSelector = new ViewSelector((ViewGroup)this, enableTouchSelect, multipleSelectMode, false);
        a.recycle();
    }

    private boolean onSuperTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        } else if (this.mSuperHandledTouchEvent) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        }
        return this.mSuperHandledTouchEvent;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.onSuperTouchEvent(event) || this.mViewSelector.onTouchEvent(event);
    }
}

