/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.ViewSelector;

public class ExtendedLinearLayout
extends LinearLayout {
    private ViewSelector mViewSelector;
    private boolean mSuperHandledTouchEvent;

    public ExtendedLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedLinearLayout(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    public int[] getSelectIndices() {
        return this.mViewSelector.getSelectIndices();
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExtendedLinearLayout);
        boolean enableTouchSelect = a.getBoolean(R.styleable.ExtendedLinearLayout_enableTouchSelect, false);
        boolean multipleSelectMode = a.getBoolean(R.styleable.ExtendedLinearLayout_multipleSelectMode, false);
        boolean containSplitter = a.getBoolean(R.styleable.ExtendedLinearLayout_containSplitter, false);
        this.mViewSelector = new ViewSelector((ViewGroup)this, enableTouchSelect, multipleSelectMode, containSplitter);
        a.recycle();
    }

    private boolean onSuperTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        } else if (this.mSuperHandledTouchEvent) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        }
        return this.mSuperHandledTouchEvent;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.onSuperTouchEvent(event) || this.mViewSelector.onTouchEvent(event);
    }
}

