/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import site.iway.androidhelpers.R;

public class ExtendedImageView
extends ImageView {
    private int mDrawablePressAlpha;
    private int mFilterClickSpan;
    private Animation mTouchDownAnimation;
    private Animation mTouchUpAnimation;
    private boolean mLastPressed;

    public ExtendedImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedImageView(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    public void setDrawablePressAlpha(int drawablePressAlpha) {
        this.mDrawablePressAlpha = drawablePressAlpha;
    }

    public void setOnClickListener(final View.OnClickListener l) {
        if (this.mFilterClickSpan > 0) {
            View.OnClickListener wrapper = new View.OnClickListener(){
                private long mLastClickTime;

                public void onClick(View v) {
                    long now = System.currentTimeMillis();
                    if (now - this.mLastClickTime > (long)ExtendedImageView.this.mFilterClickSpan) {
                        this.mLastClickTime = System.currentTimeMillis();
                        l.onClick(v);
                    }
                }
            };
            super.setOnClickListener(wrapper);
        } else {
            super.setOnClickListener(l);
        }
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExtendedImageView);
        this.setTouchDownAnimation(a.getResourceId(R.styleable.ExtendedImageView_touchDownAnimation, 0));
        this.setTouchUpAnimation(a.getResourceId(R.styleable.ExtendedImageView_touchUpAnimation, 0));
        this.mDrawablePressAlpha = a.getInt(R.styleable.ExtendedImageView_drawablePressAlpha, -1);
        this.mFilterClickSpan = a.getInt(R.styleable.ExtendedImageView_filterClickSpan, 0);
        a.recycle();
    }

    public void setTouchDownAnimation(Animation animation) {
        this.mTouchDownAnimation = animation;
    }

    public void setTouchDownAnimation(int resourceId) {
        if (resourceId != 0) {
            Context context = this.getContext();
            Animation animation = AnimationUtils.loadAnimation((Context)context, (int)resourceId);
            this.setTouchDownAnimation(animation);
        }
    }

    public void setTouchUpAnimation(Animation animation) {
        this.mTouchUpAnimation = animation;
    }

    public void setTouchUpAnimation(int resourceId) {
        if (resourceId != 0) {
            Context context = this.getContext();
            Animation animation = AnimationUtils.loadAnimation((Context)context, (int)resourceId);
            this.setTouchUpAnimation(animation);
        }
    }

    public void setPressed(boolean pressed) {
        if (this.mLastPressed != pressed) {
            Drawable drawable = this.getDrawable();
            if (pressed) {
                if (drawable != null && this.mDrawablePressAlpha >= 0 && this.mDrawablePressAlpha <= 255) {
                    drawable.setAlpha(this.mDrawablePressAlpha);
                }
                if (this.mTouchDownAnimation != null) {
                    this.startAnimation(this.mTouchDownAnimation);
                }
            } else {
                if (drawable != null && this.mDrawablePressAlpha >= 0 && this.mDrawablePressAlpha <= 255) {
                    drawable.setAlpha(255);
                }
                if (this.mTouchDownAnimation != null) {
                    this.startAnimation(this.mTouchUpAnimation);
                }
            }
        }
        super.setPressed(pressed);
        this.mLastPressed = pressed;
    }
}

