/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.TypefaceHelper;

public class ExtendedEditText
extends EditText {
    private Drawable mLineDrawable;
    private int mLineDrawableHeight;
    private int mLineDrawableOffset;
    private Rect mRect = new Rect();
    private View mClearView;

    public ExtendedEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public ExtendedEditText(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    public Drawable getLineDrawable() {
        return this.mLineDrawable;
    }

    public void setLineDrawable(Drawable drawable) {
        this.mLineDrawable = drawable;
        this.invalidate();
    }

    public void setLineDrawable(int resourceId) {
        Drawable drawable = this.getContext().getResources().getDrawable(resourceId);
        this.setLineDrawable(drawable);
    }

    public int getLineDrawableHeight() {
        return this.mLineDrawableHeight;
    }

    public void setLineDrawableHeight(int lineDrawableHeight) {
        this.mLineDrawableHeight = lineDrawableHeight;
        this.invalidate();
    }

    public int getLineDrawableOffset() {
        return this.mLineDrawableOffset;
    }

    public void setLineDrawableOffset(int lineDrawableOffset) {
        this.mLineDrawableOffset = lineDrawableOffset;
        this.invalidate();
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExtendedEditText);
        String typeFaceAssetPath = a.getString(R.styleable.ExtendedEditText_typeFaceAssetPath);
        Typeface typeface = TypefaceHelper.get(context, typeFaceAssetPath);
        if (typeface != null) {
            Typeface oldTypeface = this.getTypeface();
            if (oldTypeface != null) {
                int oldTypefaceStyle = oldTypeface.getStyle();
                this.setTypeface(typeface, oldTypefaceStyle);
            } else {
                this.setTypeface(typeface);
            }
        }
        this.mLineDrawable = a.getDrawable(R.styleable.ExtendedEditText_lineDrawable);
        this.mLineDrawableHeight = a.getDimensionPixelSize(R.styleable.ExtendedEditText_lineDrawableHeight, 1);
        this.mLineDrawableOffset = a.getDimensionPixelSize(R.styleable.ExtendedEditText_lineDrawableOffset, 0);
        a.recycle();
    }

    public void addInputFilter(InputFilter ... addFilters) {
        InputFilter[] oldFilters = this.getFilters();
        InputFilter[] newFilters = new InputFilter[oldFilters.length + addFilters.length];
        System.arraycopy(oldFilters, 0, newFilters, 0, oldFilters.length);
        System.arraycopy(addFilters, 0, newFilters, oldFilters.length, addFilters.length);
        this.setFilters(newFilters);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mLineDrawable != null) {
            int lineCount = this.getLineCount();
            for (int i = 0; i < lineCount; ++i) {
                this.getLineBounds(i, this.mRect);
                float top = this.mRect.bottom - this.mLineDrawableHeight + this.mLineDrawableOffset;
                float bottom = this.mRect.bottom + this.mLineDrawableOffset;
                this.mLineDrawable.setBounds(this.mRect.left, (int)top, this.mRect.right, (int)bottom);
                this.mLineDrawable.draw(canvas);
            }
        }
    }

    private void updateClearView() {
        if (this.mClearView != null) {
            if (this.isEnabled()) {
                this.mClearView.setVisibility(TextUtils.isEmpty((CharSequence)this.getText()) ? 8 : 0);
            } else {
                this.mClearView.setVisibility(8);
            }
        }
    }

    public void setClearView(View view) {
        this.mClearView = view;
        this.updateClearView();
        this.mClearView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ExtendedEditText.this.setText(null);
            }
        });
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        this.updateClearView();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateClearView();
    }
}

