/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class ExtendedBaseAdapter<T>
extends BaseAdapter {
    protected Context mContext;
    protected LayoutInflater mLayoutInflater;
    protected List<T> mData = new ArrayList<T>();
    protected View.OnClickListener mOnClickListener;

    public ExtendedBaseAdapter(Context context) {
        this.mContext = context;
        String serviceName = "layout_inflater";
        Object service = this.mContext.getSystemService(serviceName);
        this.mLayoutInflater = (LayoutInflater)service;
    }

    public void setData(List<T> data) {
        this.mData.clear();
        if (data != null) {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void addData(List<T> data) {
        if (data != null) {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void addData(T data) {
        this.mData.add(data);
        this.notifyDataSetChanged();
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.mOnClickListener = l;
    }

    public int getCount() {
        return this.mData == null ? 0 : this.mData.size();
    }

    public T getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }
}

