/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.UITimer;
import site.iway.androidhelpers.UnitHelper;
import site.iway.androidhelpers.ViewHelper;
import site.iway.javahelpers.MathHelper;

public class DrawerLayout
extends ViewGroup {
    private int mMotionDetectXRangeInPixel;
    private int mMotionDetectYRangeInPixel;
    private int mLeftViewIdFromAttr;
    private int mRightViewIdFromAttr;
    private int mCenterViewIdFromAttr;
    private View mLeftView;
    private View mRightView;
    private View mCenterView;
    private int mLeftViewOffset = 0;
    private int mRightViewOffset = 0;
    private int mCenterViewOffset = 0;
    private float mCurrentCenterViewOffset = 0.0f;
    private float mTargetCenterViewOffset = 0.0f;
    private UITimer mAnimator = new UITimer(){

        @Override
        public void doOnUIThread() {
            float change = (DrawerLayout.this.mTargetCenterViewOffset - DrawerLayout.this.mCurrentCenterViewOffset) * 0.15f;
            if (change == 0.0f) {
                this.stop();
            } else if (Math.abs(DrawerLayout.this.mTargetCenterViewOffset - DrawerLayout.this.mCurrentCenterViewOffset) < 1.0f) {
                DrawerLayout.this.moveViews((int)DrawerLayout.this.mTargetCenterViewOffset);
                this.stop();
            } else {
                DrawerLayout.this.mCurrentCenterViewOffset = DrawerLayout.this.mCurrentCenterViewOffset + change;
                DrawerLayout.this.moveViews((int)DrawerLayout.this.mCurrentCenterViewOffset);
            }
        }
    };
    private boolean mShouldHandleSelfDefined = false;
    private boolean mShouldHandleSelf = false;
    private float mSavedTouchDownX;
    private float mSavedTouchDownY;
    private long mSavedTouchDownTime;
    private float mSavedCenterViewOffset;
    private static final int TO_SHOW_LEFT_VIEW = -1;
    private static final int TO_SHOW_NONE = 0;
    private static final int TO_SHOW_RIGHT_VIEW = 1;
    private int mToShowTarget;
    private boolean mShouldDispatchToLeftView;
    private boolean mShouldDispatchToRightView;
    private boolean mShouldDispatchToCenterView;

    public DrawerLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.resolveAttrs(context, attrs);
    }

    public DrawerLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public DrawerLayout(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DrawerLayout);
        this.mLeftViewIdFromAttr = a.getResourceId(R.styleable.DrawerLayout_leftViewId, 0);
        this.mRightViewIdFromAttr = a.getResourceId(R.styleable.DrawerLayout_rightViewId, 0);
        this.mCenterViewIdFromAttr = a.getResourceId(R.styleable.DrawerLayout_centerViewId, 0);
        a.recycle();
        this.mMotionDetectXRangeInPixel = UnitHelper.dipToPxInt(context, 7.5f);
        this.mMotionDetectYRangeInPixel = UnitHelper.dipToPxInt(context, 7.5f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            this.measureChild(this.getChildAt(i), widthMeasureSpec, heightMeasureSpec);
        }
        this.setMeasuredDimension(widthSize, heightSize);
    }

    private boolean canShowLeftView() {
        return this.mLeftView != null && !this.mCenterView.canScrollHorizontally(-1);
    }

    private boolean canShowRightView() {
        return this.mRightView != null && !this.mCenterView.canScrollHorizontally(1);
    }

    public boolean isLeftViewPartVisible() {
        return this.mCenterViewOffset > 0;
    }

    public boolean isLeftViewWholeVisible() {
        return this.mCenterViewOffset >= this.mLeftView.getWidth();
    }

    public boolean isRightViewPartVisible() {
        return this.mCenterViewOffset < 0;
    }

    public boolean isRightViewWholeVisible() {
        return this.mCenterViewOffset <= -this.mRightView.getWidth();
    }

    public boolean isCenterViewPartVisible() {
        return this.mCenterViewOffset < 0 || this.mCenterViewOffset > 0;
    }

    public boolean isCenterViewWholeVisible() {
        return this.mCenterViewOffset == 0;
    }

    private void setViewVisibility(boolean leftView, boolean rightView) {
        if (this.mLeftView != null) {
            this.mLeftView.setVisibility(leftView ? 0 : 4);
        }
        if (this.mRightView != null) {
            this.mRightView.setVisibility(rightView ? 0 : 4);
        }
    }

    public int getLeftViewOffset() {
        return this.mLeftViewOffset;
    }

    public int getRightViewOffset() {
        return this.mRightViewOffset;
    }

    public int getCenterViewOffset() {
        return this.mCenterViewOffset;
    }

    private void layoutLeftView() {
        int left = this.mLeftViewOffset;
        int right = left + this.mLeftView.getWidth();
        int top = this.mLeftView.getTop();
        int bottom = this.mLeftView.getBottom();
        this.mLeftView.layout(left, top, right, bottom);
    }

    private void layoutRightView() {
        int left = this.mRightViewOffset + this.getWidth() - this.mRightView.getWidth();
        int right = left + this.mRightView.getWidth();
        int top = this.mRightView.getTop();
        int bottom = this.mRightView.getBottom();
        this.mRightView.layout(left, top, right, bottom);
    }

    private void layoutCenterView() {
        int left = 0 + this.mCenterViewOffset;
        int right = left + this.mCenterView.getWidth();
        int top = this.mCenterView.getTop();
        int bottom = this.mCenterView.getBottom();
        this.mCenterView.layout(left, top, right, bottom);
    }

    protected float getHidingPercentOfSideViews() {
        return 50.0f;
    }

    protected void onViewsReLayout() {
    }

    private void moveViews(int centerViewOffset) {
        if (this.mCenterViewOffset == centerViewOffset) {
            return;
        }
        float hidingPercentOfSideViews = this.getHidingPercentOfSideViews();
        if (hidingPercentOfSideViews > 100.0f) {
            hidingPercentOfSideViews = 100.0f;
        }
        if (hidingPercentOfSideViews < 0.0f) {
            hidingPercentOfSideViews = 0.0f;
        }
        if (this.mLeftView != null && centerViewOffset > 0) {
            float mLeftViewOffsetF = -hidingPercentOfSideViews * (float)(this.mLeftView.getWidth() - centerViewOffset) / 100.0f;
            this.mLeftViewOffset = MathHelper.pixel((float)mLeftViewOffsetF);
            this.layoutLeftView();
        }
        if (this.mRightView != null && centerViewOffset < 0) {
            float mRightViewOffsetF = hidingPercentOfSideViews * (float)(this.mRightView.getWidth() + centerViewOffset) / 100.0f;
            this.mRightViewOffset = MathHelper.pixel((float)mRightViewOffsetF);
            this.layoutRightView();
        }
        if (this.mCenterView != null) {
            this.mCenterViewOffset = centerViewOffset;
            this.layoutCenterView();
        }
        this.onViewsReLayout();
    }

    private void animateCenterViewTo(int offset) {
        this.mCurrentCenterViewOffset = this.mCenterViewOffset;
        this.mTargetCenterViewOffset = offset;
        this.mAnimator.start(true);
    }

    public void showLeftView() {
        if (this.mLeftView == null) {
            return;
        }
        this.setViewVisibility(true, false);
        this.bringChildToFront(this.mLeftView);
        this.bringChildToFront(this.mCenterView);
        this.animateCenterViewTo(this.mLeftView.getWidth());
    }

    public void showRightView() {
        if (this.mRightView == null) {
            return;
        }
        this.setViewVisibility(false, true);
        this.bringChildToFront(this.mRightView);
        this.bringChildToFront(this.mCenterView);
        this.animateCenterViewTo(-this.mRightView.getWidth());
    }

    public void showCenterView() {
        if (this.mCenterView == null) {
            return;
        }
        this.animateCenterViewTo(0);
    }

    private void saveStates(MotionEvent ev) {
        this.mSavedTouchDownX = ev.getX();
        this.mSavedTouchDownY = ev.getY();
        this.mSavedTouchDownTime = System.currentTimeMillis();
        this.mSavedCenterViewOffset = this.mCenterViewOffset;
    }

    private void dispatchMotionEventToViews(MotionEvent ev) {
        float offsetY;
        float offsetX;
        if (this.mShouldDispatchToLeftView && this.isLeftViewPartVisible()) {
            offsetX = this.mLeftView.getLeft();
            offsetY = this.mLeftView.getTop();
            ev.offsetLocation(-offsetX, -offsetY);
            this.mShouldDispatchToLeftView = this.mLeftView.dispatchTouchEvent(ev);
            ev.offsetLocation(offsetX, offsetY);
        }
        if (this.mShouldDispatchToRightView && this.isRightViewPartVisible()) {
            offsetX = this.mRightView.getLeft();
            offsetY = this.mRightView.getTop();
            ev.offsetLocation(-offsetX, -offsetY);
            this.mShouldDispatchToLeftView = this.mRightView.dispatchTouchEvent(ev);
            ev.offsetLocation(offsetX, offsetY);
        }
        if (this.mShouldDispatchToCenterView && this.isCenterViewWholeVisible()) {
            offsetX = this.mCenterView.getLeft();
            offsetY = this.mCenterView.getTop();
            ev.offsetLocation(-offsetX, -offsetY);
            this.mShouldDispatchToLeftView = this.mCenterView.dispatchTouchEvent(ev);
            ev.offsetLocation(offsetX, offsetY);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mAnimator.stop();
                this.mShouldHandleSelfDefined = false;
                this.mShouldHandleSelf = false;
                this.mToShowTarget = 0;
                this.mShouldDispatchToLeftView = false;
                this.mShouldDispatchToRightView = false;
                this.mShouldDispatchToCenterView = false;
                if (this.mCenterViewOffset != 0) {
                    this.mShouldHandleSelfDefined = true;
                    if (ViewHelper.isMotionEventInView(ev, this.mCenterView)) {
                        this.mShouldHandleSelf = true;
                        this.mToShowTarget = this.mCenterViewOffset > 0 ? -1 : 1;
                        this.saveStates(ev);
                        break;
                    }
                    this.mShouldHandleSelf = false;
                    if (this.isLeftViewPartVisible()) {
                        this.mShouldDispatchToLeftView = this.mLeftView.dispatchTouchEvent(ev);
                        this.showLeftView();
                    }
                    if (!this.isRightViewPartVisible()) break;
                    this.mShouldDispatchToRightView = this.mRightView.dispatchTouchEvent(ev);
                    this.showRightView();
                    break;
                }
                this.saveStates(ev);
                this.mShouldDispatchToCenterView = this.mCenterView.dispatchTouchEvent(ev);
                break;
            }
            case 2: {
                if (!this.mShouldHandleSelfDefined) {
                    if (ev.getPointerCount() > 1) {
                        this.mShouldHandleSelfDefined = true;
                        this.mShouldHandleSelf = false;
                    } else if (Math.abs(ev.getY() - this.mSavedTouchDownY) > (float)this.mMotionDetectYRangeInPixel) {
                        this.mShouldHandleSelfDefined = true;
                        this.mShouldHandleSelf = false;
                    } else if (ev.getX() - this.mSavedTouchDownX > 0.0f && (this.mLeftView == null || !this.canShowLeftView())) {
                        this.mShouldHandleSelfDefined = true;
                        this.mShouldHandleSelf = false;
                    } else if (ev.getX() - this.mSavedTouchDownX > (float)this.mMotionDetectXRangeInPixel) {
                        this.mShouldHandleSelfDefined = true;
                        this.mShouldHandleSelf = true;
                        this.saveStates(ev);
                        this.mToShowTarget = -1;
                        this.setViewVisibility(true, false);
                        if (this.mShouldDispatchToCenterView) {
                            ViewHelper.cancelMotionEventInView(ev, this.mCenterView);
                        }
                    } else if (ev.getX() - this.mSavedTouchDownX < 0.0f && (this.mRightView == null || !this.canShowRightView())) {
                        this.mShouldHandleSelfDefined = true;
                        this.mShouldHandleSelf = false;
                    } else if (ev.getX() - this.mSavedTouchDownX < (float)(-this.mMotionDetectXRangeInPixel)) {
                        this.mShouldHandleSelfDefined = true;
                        this.mShouldHandleSelf = true;
                        this.saveStates(ev);
                        this.mToShowTarget = 1;
                        this.setViewVisibility(false, true);
                        if (this.mShouldDispatchToCenterView) {
                            ViewHelper.cancelMotionEventInView(ev, this.mCenterView);
                        }
                    }
                }
                if (!this.mShouldHandleSelfDefined) break;
                if (this.mShouldHandleSelf) {
                    switch (this.mToShowTarget) {
                        case -1: {
                            float targetOffset = ev.getX() - this.mSavedTouchDownX + this.mSavedCenterViewOffset;
                            if (targetOffset > (float)this.mLeftView.getWidth()) {
                                targetOffset = this.mLeftView.getWidth();
                                this.saveStates(ev);
                            } else if (targetOffset < 0.0f) {
                                targetOffset = 0.0f;
                                this.saveStates(ev);
                            }
                            this.moveViews((int)targetOffset);
                            break;
                        }
                        case 1: {
                            float targetOffset = ev.getX() - this.mSavedTouchDownX + this.mSavedCenterViewOffset;
                            if (targetOffset > 0.0f) {
                                targetOffset = 0.0f;
                                this.saveStates(ev);
                            } else if (targetOffset < (float)(-this.mRightView.getWidth())) {
                                targetOffset = -this.mRightView.getWidth();
                                this.saveStates(ev);
                            }
                            this.moveViews((int)targetOffset);
                        }
                    }
                    break;
                }
                this.dispatchMotionEventToViews(ev);
                break;
            }
            case 1: 
            case 3: {
                if (this.mShouldHandleSelfDefined && this.mShouldHandleSelf) {
                    switch (this.mToShowTarget) {
                        case -1: {
                            if (System.currentTimeMillis() - this.mSavedTouchDownTime < 150L) {
                                if (ev.getX() - this.mSavedTouchDownX > 0.0f) {
                                    this.showLeftView();
                                    break;
                                }
                                if (!(ev.getX() - this.mSavedTouchDownX < 0.0f)) break;
                                this.showCenterView();
                                break;
                            }
                            float targetOffset = ev.getX() - this.mSavedTouchDownX + this.mSavedCenterViewOffset;
                            if (targetOffset > (float)(this.mLeftView.getWidth() / 2)) {
                                this.showLeftView();
                                break;
                            }
                            this.showCenterView();
                            break;
                        }
                        case 1: {
                            if (System.currentTimeMillis() - this.mSavedTouchDownTime < 150L) {
                                if (ev.getX() - this.mSavedTouchDownX < 0.0f) {
                                    this.showRightView();
                                    break;
                                }
                                if (!(ev.getX() - this.mSavedTouchDownX > 0.0f)) break;
                                this.showCenterView();
                                break;
                            }
                            float targetOffset = ev.getX() - this.mSavedTouchDownX + this.mSavedCenterViewOffset;
                            if (targetOffset > (float)(-this.mRightView.getWidth() / 2)) {
                                this.showCenterView();
                                break;
                            }
                            this.showRightView();
                        }
                    }
                    break;
                }
                if (this.mShouldHandleSelfDefined && !this.mShouldHandleSelf) {
                    this.dispatchMotionEventToViews(ev);
                    break;
                }
                if (!this.mShouldDispatchToCenterView) break;
                this.mCenterView.dispatchTouchEvent(ev);
                break;
            }
            default: {
                if (!this.mShouldHandleSelfDefined || this.mShouldHandleSelf) break;
                this.dispatchMotionEventToViews(ev);
            }
        }
        return true;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int right;
        int left;
        this.mLeftView = this.findViewById(this.mLeftViewIdFromAttr);
        this.mRightView = this.findViewById(this.mRightViewIdFromAttr);
        this.mCenterView = this.findViewById(this.mCenterViewIdFromAttr);
        if (this.mLeftView != null) {
            left = this.mLeftViewOffset;
            right = left + this.mLeftView.getMeasuredWidth();
            this.mLeftView.layout(left, 0, right, b - t);
        }
        if (this.mRightView != null) {
            left = this.mRightViewOffset + r - l - this.mRightView.getMeasuredWidth();
            right = left + this.mRightView.getMeasuredWidth();
            this.mRightView.layout(left, 0, right, b - t);
        }
        if (this.mCenterView != null) {
            left = 0 + this.mCenterViewOffset;
            right = left + this.mCenterView.getMeasuredWidth();
            this.mCenterView.layout(left, 0, right, b - t);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAnimator.start(true);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAnimator.stop();
    }
}

