/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceHelper {
    public static void callPhone(Context context, String phoneNumber) {
        Uri uri = Uri.parse((String)("tel:" + phoneNumber));
        Intent phoneIntent = new Intent("android.intent.action.CALL", uri);
        context.startActivity(phoneIntent);
    }

    public static void sendSms(Context context, String content, String ... receivers) {
        StringBuilder stringBuilder = new StringBuilder();
        String splitter = ";";
        for (String receiver : receivers) {
            stringBuilder.append(splitter);
            stringBuilder.append(receiver);
        }
        String receiver = stringBuilder.substring(splitter.length());
        Uri uri = Uri.parse((String)("smsto:" + receiver));
        Intent intent = new Intent("android.intent.action.SENDTO", uri);
        intent.putExtra("sms_body", content);
        context.startActivity(intent);
    }

    public static String getSDCardPath() {
        File externalStorageDirectory = Environment.getExternalStorageDirectory();
        return externalStorageDirectory.getPath();
    }

    public static boolean isSDCardInstalled() {
        String externalStorageState = Environment.getExternalStorageState();
        return "mounted".equals(externalStorageState);
    }

    public static long getSDCardFreeSize() {
        File path = Environment.getExternalStorageDirectory();
        StatFs sf = new StatFs(path.getPath());
        if (Build.VERSION.SDK_INT < 18) {
            long blockSize = sf.getBlockSize();
            long freeBlocks = sf.getAvailableBlocks();
            return freeBlocks * blockSize;
        }
        long blockSize = sf.getBlockSizeLong();
        long freeBlocks = sf.getAvailableBlocksLong();
        return freeBlocks * blockSize;
    }

    public static long getSDCardTotalSize() {
        File path = Environment.getExternalStorageDirectory();
        StatFs sf = new StatFs(path.getPath());
        if (Build.VERSION.SDK_INT < 18) {
            long blockSize = sf.getBlockSize();
            long allBlocks = sf.getBlockCount();
            return allBlocks * blockSize;
        }
        long blockSize = sf.getBlockSizeLong();
        long allBlocks = sf.getBlockCountLong();
        return allBlocks * blockSize;
    }

    public static boolean isNetworkAvailable(Context context) {
        NetworkInfo info;
        Object service = context.getSystemService("connectivity");
        ConnectivityManager connectivityManager = (ConnectivityManager)service;
        return connectivityManager != null && (info = connectivityManager.getActiveNetworkInfo()) != null && info.isConnected();
    }

    public static boolean isWiFiConnected(Context context) {
        WifiInfo info;
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        return wifiManager != null && wifiManager.isWifiEnabled() && (info = wifiManager.getConnectionInfo()) != null && info.getIpAddress() != 0;
    }

    public static boolean isFlightModeOn(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        int result = Settings.System.getInt((ContentResolver)contentResolver, (String)"airplane_mode_on", (int)0);
        return result == 1;
    }

    public static void turnOnFlightMode(Context context) {
        if (!DeviceHelper.isFlightModeOn(context)) {
            ContentResolver contentResolver = context.getContentResolver();
            Settings.System.putInt((ContentResolver)contentResolver, (String)"airplane_mode_on", (int)1);
            Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
            context.sendBroadcast(intent);
        }
    }

    public static void turnOffFlightMode(Context context) {
        if (DeviceHelper.isFlightModeOn(context)) {
            ContentResolver contentResolver = context.getContentResolver();
            Settings.System.putInt((ContentResolver)contentResolver, (String)"airplane_mode_on", (int)0);
            Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
            context.sendBroadcast(intent);
        }
    }

    public static int getHeapGrowthLimit(Context context) {
        Object service = context.getSystemService("activity");
        ActivityManager activityManager = (ActivityManager)service;
        int memoryClass = activityManager.getMemoryClass();
        return memoryClass * 1024 * 1024;
    }

    public static int getHeapSize(Context context) {
        Object service = context.getSystemService("activity");
        ActivityManager activityManager = (ActivityManager)service;
        int largeMemoryClass = activityManager.getLargeMemoryClass();
        return largeMemoryClass * 1024 * 1024;
    }

    public static int getCPUCoreCount() {
        File cpuDirectory = new File("/sys/devices/system/cpu/");
        File[] cpuFiles = cpuDirectory.listFiles();
        if (cpuFiles == null) {
            return 0;
        }
        int cpuCoreCount = 0;
        Pattern pattern = Pattern.compile("cpu[0-9]*");
        for (File cpuFile : cpuFiles) {
            String name = cpuFile.getName();
            Matcher matcher = pattern.matcher(name);
            if (!matcher.matches()) continue;
            ++cpuCoreCount;
        }
        return cpuCoreCount;
    }

    public static String getMacAddress(Context context) {
        WifiInfo info;
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        if (wifiManager != null && (info = wifiManager.getConnectionInfo()) != null) {
            return info.getMacAddress();
        }
        return null;
    }

    public static String getDeviceId(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getDeviceId();
    }

    public static String getSubscriberId(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        return telephonyManager.getSubscriberId();
    }

    public static boolean isSimulator(Context context) {
        return "000000000000000".equals(DeviceHelper.getDeviceId(context));
    }

    public static boolean isSensorExisted(Context context, int sensorType) {
        SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
        return sensorManager != null && sensorManager.getDefaultSensor(sensorType) != null;
    }
}

