/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

public class CrashDetector {
    private static OnCrashDetectedListener sListener;
    private static Thread.UncaughtExceptionHandler sOldHandler;
    private static Thread.UncaughtExceptionHandler sNewHandler;

    public static void initialize(OnCrashDetectedListener listener) {
        sListener = listener;
        sOldHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(sNewHandler);
    }

    static {
        sNewHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable ex) {
                if (sListener != null) {
                    sListener.onCrashDetected(thread, ex);
                }
                if (sOldHandler != null) {
                    sOldHandler.uncaughtException(thread, ex);
                }
            }
        };
    }

    public static interface OnCrashDetectedListener {
        public void onCrashDetected(Thread var1, Throwable var2);
    }
}

