/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.UITimer;

public class CircleProgressBar
extends View {
    private int mProgressBackColor;
    private int mProgressFrontColor;
    private float mProgressWidth;
    private float mCircleDiameter;
    private float mStartAngleOffset;
    private float mSourceProgress;
    private float mTargetProgress;
    public UITimer mAnimator = new UITimer(){

        @Override
        public void doOnUIThread() {
            if (CircleProgressBar.this.mCircleRect == null) {
                return;
            }
            double change = 0.15 * (double)(CircleProgressBar.this.mTargetProgress - CircleProgressBar.this.mSourceProgress);
            if (change == 0.0) {
                this.stop();
            } else if (Math.abs(Math.tan(change / 100.0 * Math.PI * 2.0) * (double)CircleProgressBar.this.mCircleDiameter / 2.0) < 0.1) {
                CircleProgressBar.this.mSourceProgress = CircleProgressBar.this.mTargetProgress;
                this.stop();
            } else {
                CircleProgressBar.this.mSourceProgress = (float)((double)CircleProgressBar.this.mSourceProgress + change);
            }
            CircleProgressBar.this.invalidate();
        }
    };
    protected Paint mDrawPaint;
    protected float mCenterX;
    protected float mCenterY;
    protected RectF mCircleRect;
    protected float mProgressFrontStartAngle;
    protected float mProgressFrontSweepAngle;
    protected float mProgressBackStartAngle;
    protected float mProgressBackSweepAngle;
    protected float mClearRadius;

    public CircleProgressBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.resolveAttrs(context, attrs);
    }

    public CircleProgressBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttrs(context, attrs);
    }

    public CircleProgressBar(Context context) {
        super(context);
        this.resolveAttrs(context, null);
    }

    private void resolveAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircleProgressBar);
        this.mProgressBackColor = a.getColor(R.styleable.CircleProgressBar_progressBackColor, -3355444);
        this.mProgressFrontColor = a.getColor(R.styleable.CircleProgressBar_progressFrontColor, -6710887);
        Resources resources = a.getResources();
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        this.mProgressWidth = a.getDimension(R.styleable.CircleProgressBar_progressWidth, displayMetrics.density * 20.0f);
        this.mCircleDiameter = a.getDimension(R.styleable.CircleProgressBar_circleDiameter, displayMetrics.density * 200.0f);
        this.mStartAngleOffset = a.getFloat(R.styleable.CircleProgressBar_startAngleOffset, 0.0f);
        float progress = a.getFloat(R.styleable.CircleProgressBar_progress, 0.0f);
        this.setProgress(progress, false);
        a.recycle();
    }

    public int getProgressBackColor() {
        return this.mProgressBackColor;
    }

    public void setProgressBackColor(int progressBackColor) {
        this.mProgressBackColor = progressBackColor;
    }

    public int getProgressFrontColor() {
        return this.mProgressFrontColor;
    }

    public void setProgressFrontColor(int progressFrontColor) {
        this.mProgressFrontColor = progressFrontColor;
    }

    public float getProgressWidth() {
        return this.mProgressWidth;
    }

    public void setProgressWidth(float progressWidth) {
        this.mProgressWidth = progressWidth;
    }

    public float getCircleDiameter() {
        return this.mCircleDiameter;
    }

    public void setCircleDiameter(float circleDiameter) {
        this.mCircleDiameter = circleDiameter;
    }

    public float getStartAngleOffset() {
        return this.mStartAngleOffset;
    }

    public void setStartAngleOffset(float startAngleOffset) {
        this.mStartAngleOffset = startAngleOffset;
    }

    public float getProgress() {
        return this.mTargetProgress;
    }

    public void setProgress(float progress, boolean animated) {
        if (progress < 0.0f) {
            progress = 0.0f;
        }
        if (progress > 100.0f) {
            progress = 100.0f;
        }
        this.mTargetProgress = progress;
        this.mSourceProgress = animated ? this.mSourceProgress : this.mTargetProgress;
        this.mAnimator.start(true);
    }

    protected void computeValues() {
        float viewWidth = this.getWidth();
        float viewHeight = this.getHeight();
        this.mCenterX = viewWidth / 2.0f;
        this.mCenterY = viewHeight / 2.0f;
        float radius = this.mCircleDiameter / 2.0f;
        float left = this.mCenterX - radius;
        float right = this.mCenterX + radius;
        float top = this.mCenterY - radius;
        float bottom = this.mCenterY + radius;
        if (this.mCircleRect == null) {
            this.mCircleRect = new RectF(left, top, right, bottom);
        } else {
            this.mCircleRect.set(left, top, right, bottom);
        }
        this.mProgressFrontStartAngle = -90.0f + this.mStartAngleOffset;
        this.mProgressFrontSweepAngle = this.mSourceProgress / 100.0f * 360.0f;
        this.mProgressBackStartAngle = this.mProgressFrontStartAngle + this.mProgressFrontSweepAngle;
        this.mProgressBackSweepAngle = 360.0f - this.mProgressFrontSweepAngle;
        this.mClearRadius = (this.mCircleDiameter - this.mProgressWidth * 2.0f) / 2.0f;
    }

    protected void drawArcs(Canvas canvas) {
        if (this.mDrawPaint == null) {
            this.mDrawPaint = new Paint();
            this.mDrawPaint.setStyle(Paint.Style.STROKE);
            this.mDrawPaint.setStrokeWidth(this.mProgressWidth);
            this.mDrawPaint.setAntiAlias(true);
        }
        this.mDrawPaint.setColor(this.mProgressFrontColor);
        canvas.drawArc(this.mCircleRect, this.mProgressFrontStartAngle, this.mProgressFrontSweepAngle, false, this.mDrawPaint);
        this.mDrawPaint.setColor(this.mProgressBackColor);
        canvas.drawArc(this.mCircleRect, this.mProgressBackStartAngle, this.mProgressBackSweepAngle, false, this.mDrawPaint);
    }

    protected void onDraw(Canvas canvas) {
        this.computeValues();
        this.drawArcs(canvas);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAnimator.start(true);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAnimator.stop();
    }
}

