/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.hardware.Camera;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.WindowHelper;
import site.iway.javahelpers.MathHelper;
import site.iway.javahelpers.Scale;
import site.iway.javahelpers.XAlign;
import site.iway.javahelpers.YAlign;

public class CameraPreview
extends FrameLayout
implements SurfaceHolder.Callback {
    private int mCameraId;
    private boolean mCameraIdChanged;
    private boolean mFocusByClick;
    private boolean mDetectQRCode;
    private Activity mActivity;
    private SurfaceView mSurfaceView;
    private SurfaceHolder mSurfaceHolder;
    private boolean mSurfaceRunning;
    private OnQRCodeDetectedListener mOnQRCodeDetectedListener;
    private OnPreviewErrorListener mOnPreviewErrorListener;
    private Camera mCamera;
    private Camera.Parameters mParameters;
    private ReentrantLock mPreviewDataLock = new ReentrantLock();
    private byte[] mPreviewData;
    private int mPreviewDataWidth;
    private int mPreviewDataHeight;
    private boolean mAutoFocusing;
    private View.OnClickListener mRequestAutoFocusListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (CameraPreview.this.mFocusByClick) {
                CameraPreview.this.autoFocus();
            }
        }
    };
    private RotationAndQRCodeDetector mRotationAndQRCodeDetector;

    public CameraPreview(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.resolveAttr(context, attrs);
    }

    public CameraPreview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttr(context, attrs);
    }

    public CameraPreview(Context context) {
        super(context);
        this.resolveAttr(context, null);
    }

    public void setOnQRCodeDetectedListener(OnQRCodeDetectedListener l) {
        this.mOnQRCodeDetectedListener = l;
    }

    public void setOnPreviewErrorListener(OnPreviewErrorListener l) {
        this.mOnPreviewErrorListener = l;
    }

    private void resolveAttr(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CameraPreview);
        this.mCameraId = a.getInt(R.styleable.CameraPreview_cameraId, 0);
        this.mCameraIdChanged = true;
        this.mFocusByClick = a.getBoolean(R.styleable.CameraPreview_focusByClick, false);
        this.mDetectQRCode = a.getBoolean(R.styleable.CameraPreview_detectQRCode, false);
        a.recycle();
        this.mActivity = (Activity)context;
        this.mSurfaceView = new SurfaceView(context);
        this.addView((View)this.mSurfaceView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mSurfaceHolder = this.mSurfaceView.getHolder();
        this.mSurfaceHolder.addCallback((SurfaceHolder.Callback)this);
        this.mSurfaceRunning = false;
        this.setOnClickListener(this.mRequestAutoFocusListener);
    }

    public void setCameraId(int cameraId) {
        if (this.mCameraId != cameraId) {
            this.mCameraId = cameraId;
            this.mCameraIdChanged = true;
            this.reInitialize();
        }
    }

    public void reInitialize() {
        if (this.mSurfaceRunning) {
            this.tryInitializeCamera();
        }
    }

    public void setFocusByClick(boolean focusByClick) {
        this.mFocusByClick = focusByClick;
    }

    public void setDetectQRCode(boolean detectQRCode) {
        this.mDetectQRCode = detectQRCode;
    }

    private void tryInitializeCamera() {
        block16: {
            this.destroyCameraIfExisted();
            try {
                if (this.mCameraIdChanged) {
                    this.mCamera = Camera.open((int)this.mCameraId);
                    this.mParameters = this.mCamera.getParameters();
                    this.mCameraIdChanged = false;
                }
                Camera.Size suggestedPreviewSize = null;
                boolean surfaceViewChanged = false;
                int viewWidth = this.getWidth();
                int viewHeight = this.getHeight();
                int paddingLeft = this.getPaddingLeft();
                int paddingTop = this.getPaddingTop();
                int paddingRight = this.getPaddingRight();
                int paddingBottom = this.getPaddingBottom();
                int clientWidth = viewWidth - paddingLeft - paddingRight;
                int clientHeight = viewHeight - paddingTop - paddingBottom;
                int windowOrientation = WindowHelper.getWindowRotationDegrees(this.mActivity);
                if (clientWidth > 0 && clientHeight > 0) {
                    List supportedPreviewSizes = this.mParameters.getSupportedPreviewSizes();
                    Collections.sort(supportedPreviewSizes, new Comparator<Camera.Size>(){

                        @Override
                        public int compare(Camera.Size o1, Camera.Size o2) {
                            return o1.width * o1.height - o2.width * o2.height;
                        }
                    });
                    for (Camera.Size size : supportedPreviewSizes) {
                        int previewWidth = size.width;
                        int previewHeight = size.height;
                        if (windowOrientation % 180 == 0) {
                            previewWidth = size.height;
                            previewHeight = size.width;
                        }
                        if (previewWidth < clientWidth || previewHeight < clientHeight) continue;
                        suggestedPreviewSize = size;
                        break;
                    }
                    if (suggestedPreviewSize == null) {
                        suggestedPreviewSize = (Camera.Size)supportedPreviewSizes.get(supportedPreviewSizes.size() - 1);
                    }
                    this.mParameters.setPreviewSize(suggestedPreviewSize.width, suggestedPreviewSize.height);
                    int previewWidth = suggestedPreviewSize.width;
                    int previewHeight = suggestedPreviewSize.height;
                    if (windowOrientation % 180 == 0) {
                        previewWidth = suggestedPreviewSize.height;
                        previewHeight = suggestedPreviewSize.width;
                    }
                    float surfaceScale = Scale.CenterCrop.getScale((float)clientWidth, (float)clientHeight, (float)previewWidth, (float)previewHeight);
                    int targetWidth = MathHelper.pixel((float)(surfaceScale * (float)previewWidth));
                    int targetHeight = MathHelper.pixel((float)(surfaceScale * (float)previewHeight));
                    float targetLeft = MathHelper.pixel((float)XAlign.CenterCenter.getX((float)paddingLeft, (float)clientWidth, (float)targetWidth * 1.0f));
                    float targetTop = MathHelper.pixel((float)YAlign.CenterCenter.getY((float)paddingTop, (float)clientHeight, (float)targetHeight * 1.0f));
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mSurfaceView.getLayoutParams();
                    float translationX = this.mSurfaceView.getTranslationX();
                    float translationY = this.mSurfaceView.getTranslationY();
                    if (layoutParams.width != targetWidth || layoutParams.height != targetHeight || translationX != targetLeft || translationY != targetTop) {
                        layoutParams.width = targetWidth;
                        layoutParams.height = targetHeight;
                        this.mSurfaceView.setTranslationX(targetLeft);
                        this.mSurfaceView.setTranslationY(targetTop);
                        this.mSurfaceView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        surfaceViewChanged = true;
                    }
                }
                if (surfaceViewChanged) {
                    this.destroyCameraIfExisted();
                } else {
                    if (this.mCamera == null) {
                        this.mCamera = Camera.open((int)this.mCameraId);
                    }
                    Camera.CameraInfo info = new Camera.CameraInfo();
                    Camera.getCameraInfo((int)this.mCameraId, (Camera.CameraInfo)info);
                    int cameraFacing = info.facing;
                    int cameraOrientation = info.orientation;
                    int displayOrientation = 0;
                    switch (cameraFacing) {
                        case 1: {
                            displayOrientation = (cameraOrientation + windowOrientation) % 360;
                            displayOrientation = (360 - displayOrientation) % 360;
                            break;
                        }
                        case 0: {
                            displayOrientation = (cameraOrientation - windowOrientation + 360) % 360;
                        }
                    }
                    this.mCamera.setDisplayOrientation(displayOrientation);
                    this.mCamera.setParameters(this.mParameters);
                    this.mCamera.setPreviewCallback(new Camera.PreviewCallback(){

                        public void onPreviewFrame(byte[] data, Camera camera) {
                            if (CameraPreview.this.mPreviewDataLock.tryLock()) {
                                if (CameraPreview.this.mPreviewData == null) {
                                    CameraPreview.access$102(CameraPreview.this, data);
                                    Camera.Size previewSize = CameraPreview.this.mParameters.getPreviewSize();
                                    CameraPreview.this.mPreviewDataWidth = previewSize.width;
                                    CameraPreview.this.mPreviewDataHeight = previewSize.height;
                                }
                                CameraPreview.this.mPreviewDataLock.unlock();
                            }
                        }
                    });
                    this.mCamera.setPreviewDisplay(this.mSurfaceHolder);
                    this.mCamera.startPreview();
                }
            }
            catch (Exception e) {
                this.destroyCameraIfExisted();
                if (this.mOnPreviewErrorListener == null) break block16;
                this.mOnPreviewErrorListener.onPreviewError(e);
            }
        }
    }

    private void destroyCameraIfExisted() {
        if (this.mCamera != null) {
            this.mCamera.stopPreview();
            this.mCamera.setPreviewCallback(null);
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this.mSurfaceRunning = true;
        this.tryInitializeCamera();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.destroyCameraIfExisted();
        this.mSurfaceRunning = false;
    }

    public void autoFocus() {
        if (this.mCamera != null && !this.mAutoFocusing) {
            this.mAutoFocusing = true;
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                    CameraPreview.this.mAutoFocusing = false;
                }
            });
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mRotationAndQRCodeDetector != null) {
            this.mRotationAndQRCodeDetector.cancel();
        }
        this.mRotationAndQRCodeDetector = new RotationAndQRCodeDetector();
        this.mRotationAndQRCodeDetector.start();
    }

    protected void onDetachedFromWindow() {
        if (this.mRotationAndQRCodeDetector != null) {
            this.mRotationAndQRCodeDetector.cancel();
        }
        super.onDetachedFromWindow();
    }

    static /* synthetic */ byte[] access$102(CameraPreview x0, byte[] x1) {
        x0.mPreviewData = x1;
        return x1;
    }

    private class RotationAndQRCodeDetector
    extends Thread {
        private int mLastWindowRotationDegrees;
        private boolean mIsCanceled;

        private RotationAndQRCodeDetector() {
        }

        @Override
        public void run() {
            while (!this.mIsCanceled) {
                int currentWindowRotationDegrees = WindowHelper.getWindowRotationDegrees(CameraPreview.this.mActivity);
                if (currentWindowRotationDegrees != this.mLastWindowRotationDegrees) {
                    if (this.mLastWindowRotationDegrees == 90 && currentWindowRotationDegrees == 270 || this.mLastWindowRotationDegrees == 270 && currentWindowRotationDegrees == 90) {
                        CameraPreview.this.post(new Runnable(){

                            @Override
                            public void run() {
                                CameraPreview.this.reInitialize();
                            }
                        });
                    }
                    this.mLastWindowRotationDegrees = currentWindowRotationDegrees;
                }
                if (CameraPreview.this.mDetectQRCode) {
                    byte[] savedPreviewData = null;
                    int savedPreviewDataWidth = 0;
                    int savedPreviewDataHeight = 0;
                    if (CameraPreview.this.mPreviewDataLock.tryLock()) {
                        savedPreviewData = CameraPreview.this.mPreviewData;
                        savedPreviewDataWidth = CameraPreview.this.mPreviewDataWidth;
                        savedPreviewDataHeight = CameraPreview.this.mPreviewDataHeight;
                        CameraPreview.access$102(CameraPreview.this, null);
                        CameraPreview.this.mPreviewDataWidth = 0;
                        CameraPreview.this.mPreviewDataHeight = 0;
                        CameraPreview.this.mPreviewDataLock.unlock();
                    }
                    if (savedPreviewData != null && savedPreviewData.length > 0 && savedPreviewDataWidth > 0 && savedPreviewDataHeight > 0) {
                        PlanarYUVLuminanceSource source = new PlanarYUVLuminanceSource(savedPreviewData, savedPreviewDataWidth, savedPreviewDataHeight, 0, 0, savedPreviewDataWidth, savedPreviewDataHeight, false);
                        BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
                        QRCodeReader qrCodeReader = new QRCodeReader();
                        try {
                            Result result = qrCodeReader.decode(bitmap);
                            final String text = result.getText();
                            if (CameraPreview.this.mOnQRCodeDetectedListener != null) {
                                CameraPreview.this.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        CameraPreview.this.mOnQRCodeDetectedListener.onQRCodeDetected(text);
                                    }
                                });
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void cancel() {
            this.mIsCanceled = true;
        }
    }

    public static interface OnPreviewErrorListener {
        public void onPreviewError(Exception var1);
    }

    public static interface OnQRCodeDetectedListener {
        public void onQRCodeDetected(String var1);
    }
}

