/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import java.util.HashMap;
import java.util.Map;
import site.iway.androidhelpers.BitmapCache;
import site.iway.androidhelpers.BitmapCallback;
import site.iway.androidhelpers.BitmapFilter;
import site.iway.androidhelpers.BitmapFilterClip;
import site.iway.androidhelpers.BitmapRequest;
import site.iway.androidhelpers.BitmapSource;
import site.iway.androidhelpers.BitmapSourceAsset;
import site.iway.androidhelpers.BitmapSourceFile;
import site.iway.androidhelpers.BitmapSourceResource;
import site.iway.androidhelpers.BitmapSourceURL;
import site.iway.androidhelpers.CanvasHelper;
import site.iway.androidhelpers.R;
import site.iway.javahelpers.Scale;

public class BitmapView
extends View
implements BitmapCallback {
    private static Map<String, BitmapFilter> mCachedBitmapFilters = new HashMap<String, BitmapFilter>();
    private Drawable mBackDrawable;
    private Drawable mForeDrawable;
    private Drawable mEmptyDrawable;
    private Drawable mErrorDrawable;
    private Scale mScale;
    private boolean mUseDefaultFilter;
    private float mRoundCornerRadius;
    private Animation mFinishAnimation;
    private boolean mHasAttachedToWindow;
    private BitmapSource mBitmapSource;
    private BitmapRequest mBitmapRequest;
    private Rect mClientRect = new Rect();
    private RectF mClientRectF = new RectF();
    private Paint mPaint;

    private static BitmapFilter createBitmapFilter(Scale s, int w, int h, float r) {
        String key;
        BitmapFilter value;
        if (mCachedBitmapFilters == null) {
            mCachedBitmapFilters = new HashMap<String, BitmapFilter>();
        }
        if ((value = mCachedBitmapFilters.get(key = s.ordinal() + "," + w + "," + h + "," + r)) == null) {
            value = new BitmapFilterClip(s, w, h, r);
            mCachedBitmapFilters.put(key, value);
        }
        return value;
    }

    public BitmapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.resolveAttr(context, attrs);
    }

    public BitmapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.resolveAttr(context, attrs);
    }

    public BitmapView(Context context) {
        super(context);
        this.resolveAttr(context, null);
    }

    public Drawable getBackDrawable() {
        return this.mBackDrawable;
    }

    public void setBackDrawable(Drawable backDrawable) {
        this.mBackDrawable = backDrawable;
        this.invalidate();
    }

    public void setBackDrawableResource(int resId) {
        Drawable drawable = this.getContext().getResources().getDrawable(resId);
        this.setBackDrawable(drawable);
    }

    public Drawable getForeDrawable() {
        return this.mForeDrawable;
    }

    public void setForeDrawable(Drawable foreDrawable) {
        this.mForeDrawable = foreDrawable;
        this.invalidate();
    }

    public void setForeDrawableResource(int resId) {
        Drawable drawable = this.getContext().getResources().getDrawable(resId);
        this.setForeDrawable(drawable);
    }

    public Drawable getEmptyDrawable() {
        return this.mEmptyDrawable;
    }

    public void setEmptyDrawable(Drawable drawable) {
        this.mEmptyDrawable = drawable;
        this.invalidate();
    }

    public void setEmptyDrawableResource(int resId) {
        Drawable drawable = this.getContext().getResources().getDrawable(resId);
        this.setEmptyDrawable(drawable);
    }

    public Drawable getErrorDrawable() {
        return this.mErrorDrawable;
    }

    public void setErrorDrawable(Drawable drawable) {
        this.mErrorDrawable = drawable;
        this.invalidate();
    }

    public void setErrorDrawableResource(int resId) {
        Drawable drawable = this.getContext().getResources().getDrawable(resId);
        this.setErrorDrawable(drawable);
    }

    public Scale getScale() {
        return this.mScale;
    }

    public void setScale(Scale scale) {
        this.mScale = scale;
        this.invalidate();
    }

    public boolean isUseDefaultFilter() {
        return this.mUseDefaultFilter;
    }

    public void setUseDefaultFilter(boolean useDefaultFilter) {
        this.mUseDefaultFilter = useDefaultFilter;
        this.invalidate();
    }

    public float getRoundCornerRadius() {
        return this.mRoundCornerRadius;
    }

    public void setRoundCornerRadius(float roundCornerRadius) {
        this.mRoundCornerRadius = roundCornerRadius;
        this.invalidate();
    }

    public Animation getFinishAnimation() {
        return this.mFinishAnimation;
    }

    public void setFinishAnimation(Animation animation) {
        this.mFinishAnimation = animation;
    }

    public void setFinishAnimation(int animationResId) {
        if (animationResId != 0) {
            Context context = this.getContext();
            this.mFinishAnimation = AnimationUtils.loadAnimation((Context)context, (int)animationResId);
        } else {
            this.mFinishAnimation = null;
        }
    }

    private void resolveAttr(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BitmapView);
        this.mBackDrawable = a.getDrawable(R.styleable.BitmapView_backDrawable);
        this.mForeDrawable = a.getDrawable(R.styleable.BitmapView_foreDrawable);
        this.mEmptyDrawable = a.getDrawable(R.styleable.BitmapView_emptyDrawable);
        this.mErrorDrawable = a.getDrawable(R.styleable.BitmapView_errorDrawable);
        int scaleType = a.getInt(R.styleable.BitmapView_scaleType, 0);
        switch (scaleType) {
            case 0: {
                this.mScale = Scale.None;
                break;
            }
            case 1: {
                this.mScale = Scale.Center;
                break;
            }
            case 2: {
                this.mScale = Scale.CenterFit;
                break;
            }
            case 3: {
                this.mScale = Scale.CenterCrop;
                break;
            }
            case 4: {
                this.mScale = Scale.CenterInside;
            }
        }
        this.mUseDefaultFilter = a.getBoolean(R.styleable.BitmapView_useDefaultFilter, false);
        this.mRoundCornerRadius = a.getDimension(R.styleable.BitmapView_roundCornerRadius, 0.0f);
        this.setFinishAnimation(a.getResourceId(R.styleable.BitmapView_finishAnimation, 0));
        a.recycle();
    }

    public void loadFromSource(BitmapSource source) {
        this.mBitmapSource = source;
        this.mBitmapRequest = null;
        this.clearAnimation();
        this.invalidate();
    }

    public void loadFromAssetSource(String asset, BitmapFilter filter) {
        this.loadFromSource(new BitmapSourceAsset(asset, filter));
    }

    public void loadFromAssetSource(String asset) {
        this.loadFromAssetSource(asset, null);
    }

    public void loadFromFileSource(String file, BitmapFilter filter) {
        this.loadFromSource(new BitmapSourceFile(file, filter));
    }

    public void loadFromFileSource(String file) {
        this.loadFromFileSource(file, null);
    }

    public void loadFromResourceSource(int resourceId, BitmapFilter filter) {
        this.loadFromSource(new BitmapSourceResource(resourceId, filter));
    }

    public void loadFromResourceSource(int resourceId) {
        this.loadFromResourceSource(resourceId, null);
    }

    public void loadFromURLSource(String url, BitmapFilter filter) {
        this.loadFromSource(new BitmapSourceURL(url, filter));
    }

    public void loadFromURLSource(String url) {
        this.loadFromURLSource(url, null);
    }

    @Override
    public void onBitmapLoadProgressChange(BitmapRequest request) {
        int progress;
        if (this.mHasAttachedToWindow && request == this.mBitmapRequest && ((progress = request.getProgress()) == 4 || progress == 5)) {
            if (this.mFinishAnimation != null) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        BitmapView.this.startAnimation(BitmapView.this.mFinishAnimation);
                    }
                });
            }
            this.postInvalidate();
        }
    }

    private void setClientRect() {
        int clientLeft = this.getPaddingLeft();
        int clientTop = this.getPaddingTop();
        int clientRight = this.getWidth() - this.getPaddingRight();
        int clientBottom = this.getHeight() - this.getPaddingBottom();
        this.mClientRect.set(clientLeft, clientTop, clientRight, clientBottom);
        this.mClientRectF.set((float)clientLeft, (float)clientTop, (float)clientRight, (float)clientBottom);
    }

    private void drawDrawable(Canvas canvas, Drawable drawable) {
        if (drawable != null) {
            drawable.setBounds(this.mClientRect);
            drawable.draw(canvas);
        }
    }

    private boolean checkBitmapSource() {
        int h;
        int w;
        BitmapFilter filter;
        if (this.mUseDefaultFilter && this.mBitmapSource.filter != (filter = BitmapView.createBitmapFilter(this.mScale, w = this.mClientRect.width(), h = this.mClientRect.height(), this.mRoundCornerRadius))) {
            int type = this.mBitmapSource.type;
            String content = this.mBitmapSource.content;
            this.mBitmapSource = new BitmapSource(type, content, filter);
            return true;
        }
        return false;
    }

    protected void onDraw(Canvas canvas) {
        this.setClientRect();
        this.drawDrawable(canvas, this.mBackDrawable);
        if (this.mBitmapSource == null) {
            this.drawDrawable(canvas, this.mEmptyDrawable);
        } else {
            boolean bitmapSourceChanged = this.checkBitmapSource();
            Bitmap cachedBitmap = BitmapCache.get(this.mBitmapSource);
            if (cachedBitmap == null) {
                if (this.mBitmapRequest == null || bitmapSourceChanged) {
                    this.mBitmapRequest = new BitmapRequest(this.mBitmapSource, this);
                    BitmapCache.requestNow(this.mBitmapRequest);
                    this.drawDrawable(canvas, this.mEmptyDrawable);
                } else {
                    switch (this.mBitmapRequest.getProgress()) {
                        case 4: {
                            this.mBitmapRequest = new BitmapRequest(this.mBitmapSource, this);
                            BitmapCache.requestNow(this.mBitmapRequest);
                            this.drawDrawable(canvas, this.mEmptyDrawable);
                            break;
                        }
                        case 5: {
                            this.drawDrawable(canvas, this.mErrorDrawable);
                            break;
                        }
                        default: {
                            this.drawDrawable(canvas, this.mEmptyDrawable);
                            break;
                        }
                    }
                }
            } else {
                if (this.mPaint == null) {
                    this.mPaint = new Paint();
                    this.mPaint.setAntiAlias(true);
                    this.mPaint.setFilterBitmap(true);
                }
                CanvasHelper.drawBitmap(canvas, this.mClientRectF, cachedBitmap, null, this.mScale, this.mPaint);
            }
        }
        this.drawDrawable(canvas, this.mForeDrawable);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mHasAttachedToWindow = true;
    }

    private void cancelBitmapRequestIfExists() {
        if (this.mBitmapRequest != null) {
            this.mBitmapRequest.cancel();
            this.mBitmapRequest = null;
        }
    }

    public void onStartTemporaryDetach() {
        this.cancelBitmapRequestIfExists();
        super.onStartTemporaryDetach();
    }

    protected void onDetachedFromWindow() {
        this.cancelBitmapRequestIfExists();
        this.mHasAttachedToWindow = false;
        super.onDetachedFromWindow();
    }
}

