/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import site.iway.androidhelpers.BitmapFilter;

public class BitmapSource {
    public static final int TYPE_INVALID = -1;
    public static final int TYPE_ASSET = 3;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_RESOURCE = 2;
    public static final int TYPE_URL = 0;
    final int type;
    final String content;
    final BitmapFilter filter;
    final String id;
    final int hashCode;

    BitmapSource(int type, String content, BitmapFilter filter) {
        if (type < 0 || type > 3) {
            type = -1;
        }
        this.type = type;
        this.content = content;
        this.filter = filter;
        this.id = filter == null ? type + "|" + content : type + "|" + content + "|" + filter.id();
        this.hashCode = this.id.hashCode();
    }

    public BitmapSource(int type, String content) {
        this(type, content, null);
    }

    public int type() {
        return this.type;
    }

    public String content() {
        return this.content;
    }

    public String id() {
        return this.id;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BitmapSource) {
            BitmapSource other = (BitmapSource)o;
            return this.id.equals(other.id);
        }
        return false;
    }
}

