/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import site.iway.androidhelpers.BitmapCallback;
import site.iway.androidhelpers.BitmapSource;

public class BitmapRequest {
    public static final int READY_TO_START = 0;
    public static final int PREPARING = 1;
    public static final int DECODING = 2;
    public static final int FILTERING = 3;
    public static final int GET_BITMAP = 4;
    public static final int GET_ERROR = 5;
    private final BitmapSource mSource;
    private final BitmapCallback mCallback;
    private volatile int mProgress;
    private volatile boolean mCanceled;

    public BitmapRequest(BitmapSource source, BitmapCallback callback) {
        if (source == null) {
            throw new NullPointerException("Param source can not be null.");
        }
        if (callback == null) {
            throw new NullPointerException("Param callback can not be null.");
        }
        this.mSource = source;
        this.mCallback = callback;
        this.mProgress = 0;
    }

    public BitmapSource getSource() {
        return this.mSource;
    }

    public BitmapCallback getCallback() {
        return this.mCallback;
    }

    public int getProgress() {
        return this.mProgress;
    }

    public boolean isCanceled() {
        return this.mCanceled;
    }

    public void cancel() {
        this.mCanceled = true;
    }

    void updateProgress(int progress) {
        if (this.mProgress != progress) {
            this.mProgress = progress;
            this.mCallback.onBitmapLoadProgressChange(this);
        }
    }
}

