/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import site.iway.androidhelpers.CanvasHelper;
import site.iway.javahelpers.MathHelper;
import site.iway.javahelpers.Scale;

public class BitmapHelper {
    public static Bitmap addReflection(Bitmap source, float percentFromBottom, int reflectionHeight, int startAlpha, int endAlpha) {
        if (reflectionHeight < 0) {
            throw new IllegalArgumentException("reflectionHeight > 0");
        }
        if (percentFromBottom <= 0.0f || percentFromBottom > 1.0f) {
            throw new IllegalArgumentException("0 < percentFromBottom <= 1");
        }
        if (startAlpha < 0 || startAlpha > 255) {
            throw new IllegalArgumentException("0 <= startAlpha <= 255");
        }
        if (endAlpha < 0 || endAlpha > 255) {
            throw new IllegalArgumentException("0 <= endAlpha <= 255");
        }
        Bitmap targetBitmap = Bitmap.createBitmap((int)source.getWidth(), (int)(source.getHeight() + reflectionHeight), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(targetBitmap);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        Matrix matrix = new Matrix();
        float scale = (float)reflectionHeight / (float)source.getHeight() / percentFromBottom;
        matrix.preTranslate(0.0f, (float)source.getHeight() + scale * (float)source.getHeight());
        matrix.preScale(1.0f, -scale);
        canvas.drawRect(0.0f, (float)source.getHeight(), (float)source.getWidth(), (float)(source.getHeight() + reflectionHeight), paint);
        canvas.drawBitmap(source, matrix, paint);
        int yStart = source.getHeight();
        int yEnd = targetBitmap.getHeight();
        int startColor = 0xFFFFFF | startAlpha << 24;
        int entColor = 0xFFFFFF | endAlpha << 24;
        LinearGradient shader = new LinearGradient(0.0f, (float)yStart, 0.0f, (float)yEnd, startColor, entColor, Shader.TileMode.CLAMP);
        paint.setShader((Shader)shader);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        canvas.drawRect(0.0f, (float)source.getHeight(), (float)source.getWidth(), (float)(source.getHeight() + reflectionHeight), paint);
        return targetBitmap;
    }

    public static Bitmap addReflection(Bitmap source, float percentFromBottom, int reflectionHeight) {
        return BitmapHelper.addReflection(source, percentFromBottom, reflectionHeight, 255, 0);
    }

    public static Bitmap addReflection(Bitmap source) {
        return BitmapHelper.addReflection(source, 0.3f, source.getHeight() / 3);
    }

    public static Bitmap roundCorner(Bitmap source, float radiusX, float radiusY) {
        if (source == null || source.getWidth() == 0 || source.getHeight() == 0) {
            return null;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        Bitmap target = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(target);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        paint.setColor(-16777216);
        RectF rectF = new RectF(0.0f, 0.0f, (float)width, (float)height);
        canvas.drawRoundRect(rectF, radiusX, radiusY, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        return target;
    }

    public static Bitmap roundCorner(Bitmap source, float radius) {
        return BitmapHelper.roundCorner(source, radius, radius);
    }

    public static Bitmap blur(Bitmap source, int radius) {
        int stackStart;
        int x;
        int stackPointer;
        int rbs;
        int[] sir;
        int p;
        int rInSum;
        int gInSum;
        int bInSum;
        int rOutSum;
        int gOutSum;
        int bOutSum;
        int rSum;
        int gSum;
        int bSum;
        int y;
        int i;
        if (source == null) {
            return null;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        if (width == 0) {
            return null;
        }
        if (height == 0) {
            return null;
        }
        int[] pixelsFromSource = new int[width * height];
        source.getPixels(pixelsFromSource, 0, width, 0, 0, width, height);
        int wm = width - 1;
        int hm = height - 1;
        int wh = width * height;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vMin = new int[Math.max(width, height)];
        int divSum = div + 1 >> 1;
        divSum *= divSum;
        int[] dv = new int[256 * divSum];
        for (i = 0; i < 256 * divSum; ++i) {
            dv[i] = i / divSum;
        }
        int yi = 0;
        int yw = 0;
        int[][] stack = new int[div][3];
        int r1 = radius + 1;
        for (y = 0; y < height; ++y) {
            bSum = 0;
            gSum = 0;
            rSum = 0;
            bOutSum = 0;
            gOutSum = 0;
            rOutSum = 0;
            bInSum = 0;
            gInSum = 0;
            rInSum = 0;
            for (i = -radius; i <= radius; ++i) {
                p = pixelsFromSource[yi + Math.min(wm, Math.max(i, 0))];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rbs = r1 - Math.abs(i);
                rSum += sir[0] * rbs;
                gSum += sir[1] * rbs;
                bSum += sir[2] * rbs;
                if (i > 0) {
                    rInSum += sir[0];
                    gInSum += sir[1];
                    bInSum += sir[2];
                    continue;
                }
                rOutSum += sir[0];
                gOutSum += sir[1];
                bOutSum += sir[2];
            }
            stackPointer = radius;
            for (x = 0; x < width; ++x) {
                r[yi] = dv[rSum];
                g[yi] = dv[gSum];
                b[yi] = dv[bSum];
                rSum -= rOutSum;
                gSum -= gOutSum;
                bSum -= bOutSum;
                stackStart = stackPointer - radius + div;
                sir = stack[stackStart % div];
                rOutSum -= sir[0];
                gOutSum -= sir[1];
                bOutSum -= sir[2];
                if (y == 0) {
                    vMin[x] = Math.min(x + radius + 1, wm);
                }
                p = pixelsFromSource[yw + vMin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rSum += (rInSum += sir[0]);
                gSum += (gInSum += sir[1]);
                bSum += (bInSum += sir[2]);
                stackPointer = (stackPointer + 1) % div;
                sir = stack[stackPointer % div];
                rOutSum += sir[0];
                gOutSum += sir[1];
                bOutSum += sir[2];
                rInSum -= sir[0];
                gInSum -= sir[1];
                bInSum -= sir[2];
                ++yi;
            }
            yw += width;
        }
        for (x = 0; x < width; ++x) {
            bSum = 0;
            gSum = 0;
            rSum = 0;
            bOutSum = 0;
            gOutSum = 0;
            rOutSum = 0;
            bInSum = 0;
            gInSum = 0;
            rInSum = 0;
            int yp = -radius * width;
            for (i = -radius; i <= radius; ++i) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                rbs = r1 - Math.abs(i);
                rSum += r[yi] * rbs;
                gSum += g[yi] * rbs;
                bSum += b[yi] * rbs;
                if (i > 0) {
                    rInSum += sir[0];
                    gInSum += sir[1];
                    bInSum += sir[2];
                } else {
                    rOutSum += sir[0];
                    gOutSum += sir[1];
                    bOutSum += sir[2];
                }
                if (i >= hm) continue;
                yp += width;
            }
            yi = x;
            stackPointer = radius;
            for (y = 0; y < height; ++y) {
                pixelsFromSource[yi] = 0xFF000000 & pixelsFromSource[yi] | dv[rSum] << 16 | dv[gSum] << 8 | dv[bSum];
                rSum -= rOutSum;
                gSum -= gOutSum;
                bSum -= bOutSum;
                stackStart = stackPointer - radius + div;
                sir = stack[stackStart % div];
                rOutSum -= sir[0];
                gOutSum -= sir[1];
                bOutSum -= sir[2];
                if (x == 0) {
                    vMin[y] = Math.min(y + r1, hm) * width;
                }
                p = x + vMin[y];
                sir[0] = r[p];
                sir[1] = g[p];
                sir[2] = b[p];
                rSum += (rInSum += sir[0]);
                gSum += (gInSum += sir[1]);
                bSum += (bInSum += sir[2]);
                stackPointer = (stackPointer + 1) % div;
                sir = stack[stackPointer];
                rOutSum += sir[0];
                gOutSum += sir[1];
                bOutSum += sir[2];
                rInSum -= sir[0];
                gInSum -= sir[1];
                bInSum -= sir[2];
                yi += width;
            }
        }
        return Bitmap.createBitmap((int[])pixelsFromSource, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    public static Bitmap emboss(Bitmap source) {
        if (source == null || source.getWidth() == 0 || source.getHeight() == 0) {
            return null;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        int[] pixelsFromSource = new int[width * height];
        source.getPixels(pixelsFromSource, 0, width, 0, 0, width, height);
        int length = height - 1;
        for (int i = 1; i < length; ++i) {
            int len = width - 1;
            for (int k = 1; k < len; ++k) {
                int pos = i * width + k;
                int pixColor = pixelsFromSource[pos];
                int pixR = Color.red((int)pixColor);
                int pixG = Color.green((int)pixColor);
                int pixB = Color.blue((int)pixColor);
                pixColor = pixelsFromSource[pos + 1];
                int newR = Color.red((int)pixColor) - pixR + 127;
                int newG = Color.green((int)pixColor) - pixG + 127;
                int newB = Color.blue((int)pixColor) - pixB + 127;
                newR = Math.min(255, Math.max(0, newR));
                newG = Math.min(255, Math.max(0, newG));
                newB = Math.min(255, Math.max(0, newB));
                pixelsFromSource[pos] = Color.argb((int)255, (int)newR, (int)newG, (int)newB);
            }
        }
        return Bitmap.createBitmap((int[])pixelsFromSource, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    public static Bitmap greyScale(Bitmap source) {
        if (source == null || source.getWidth() == 0 || source.getHeight() == 0) {
            return null;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        Bitmap target = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int pixel = source.getPixel(i, j);
                int a = (pixel & 0xFF000000) >> 24;
                int r = (pixel & 0xFF0000) >> 16;
                int g = (pixel & 0xFF00) >> 8;
                int b = pixel & 0xFF;
                int gray = r * 76 + g * 151 + b * 28 >> 8;
                int color = Color.argb((int)a, (int)gray, (int)gray, (int)gray);
                target.setPixel(i, j, color);
            }
        }
        return target;
    }

    public static Bitmap mirror(Bitmap source, boolean horizontal, boolean vertical) {
        if (source == null || source.getWidth() == 0 || source.getHeight() == 0) {
            return null;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        Matrix m = new Matrix();
        float sx = horizontal ? -1.0f : 1.0f;
        float sy = vertical ? -1.0f : 1.0f;
        float w = width;
        float h = height;
        float px = w / 2.0f;
        float py = h / 2.0f;
        m.setScale(sx, sy, px, py);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)width, (int)height, (Matrix)m, (boolean)false);
    }

    public static Bitmap rotate(Bitmap source, float degrees) {
        if (source == null || source.getWidth() == 0 || source.getHeight() == 0) {
            return null;
        }
        int width = source.getWidth();
        int height = source.getHeight();
        Matrix m = new Matrix();
        float w = width;
        float h = height;
        float px = w / 2.0f;
        float py = h / 2.0f;
        m.setRotate(degrees, px, py);
        return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)width, (int)height, (Matrix)m, (boolean)true);
    }

    public static Bitmap rotateByExifInfo(Bitmap source, String path) {
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            String tagName = "Orientation";
            int defaultValue = 1;
            int orientation = exifInterface.getAttributeInt(tagName, defaultValue);
            switch (orientation) {
                case 1: {
                    return source;
                }
                case 6: {
                    return BitmapHelper.rotate(source, 90.0f);
                }
                case 3: {
                    return BitmapHelper.rotate(source, 180.0f);
                }
                case 8: {
                    return BitmapHelper.rotate(source, 270.0f);
                }
            }
            return source;
        }
        catch (Exception e) {
            return source;
        }
    }

    public static Bitmap scale(Bitmap source, float scaleX, float scaleY) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        int targetWidth = MathHelper.pixel((float)((float)sourceWidth * scaleX));
        int targetHeight = MathHelper.pixel((float)((float)sourceHeight * scaleY));
        return Bitmap.createScaledBitmap((Bitmap)source, (int)targetWidth, (int)targetHeight, (boolean)true);
    }

    public static Bitmap scale(Bitmap source, float scale) {
        return BitmapHelper.scale(source, scale, scale);
    }

    public static Bitmap scale(Bitmap source, Scale scale, int width, int height) {
        int sourceWidth = source.getWidth();
        int sourceHeight = source.getHeight();
        float scaleValue = scale.getScale((float)width, (float)height, (float)sourceWidth, (float)sourceHeight);
        return BitmapHelper.scale(source, scaleValue);
    }

    public static Bitmap clip(Bitmap source, Scale scale, int width, int height, float radius) {
        if (source == null || width < 0 || height < 0) {
            return null;
        }
        Bitmap target = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(target);
        RectF rectF = new RectF(0.0f, 0.0f, (float)width, (float)height);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        paint.setFilterBitmap(true);
        if (radius > 0.0f) {
            paint.setColor(-16777216);
            canvas.drawRoundRect(rectF, radius, radius, paint);
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        }
        CanvasHelper.drawBitmap(canvas, rectF, source, null, scale, paint);
        return target;
    }

    public static BitmapFactory.Options decodeJustBounds(String path) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        options.inJustDecodeBounds = false;
        return options;
    }

    public static Bitmap decodeRestrictDataSize(String path, int maxDataSize) {
        BitmapFactory.Options options = BitmapHelper.decodeJustBounds(path);
        int width = options.outWidth;
        int height = options.outHeight;
        int scale = 1;
        while (width * height * 4 > maxDataSize) {
            scale *= 2;
            width /= 2;
            height /= 2;
        }
        options.inSampleSize = scale;
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }

    public static byte[] convertToBytes(Bitmap bitmap, Bitmap.CompressFormat format, int quality) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(format, quality, (OutputStream)stream);
        byte[] data = stream.toByteArray();
        try {
            stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public static byte[] compressJPEG(Bitmap bitmap, int quality) {
        return BitmapHelper.convertToBytes(bitmap, Bitmap.CompressFormat.JPEG, quality);
    }

    public static byte[] compressJPEG(Bitmap bitmap, int dataLength, int testStep) {
        for (int quality = 100; quality > 0; quality -= testStep) {
            byte[] data = BitmapHelper.compressJPEG(bitmap, quality);
            if (data.length >= dataLength) continue;
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToFile(Bitmap bitmap, File file) {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)outputStream);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static boolean saveToFile(Bitmap bitmap, String path) {
        File file = new File(path);
        return BitmapHelper.saveToFile(bitmap, file);
    }
}

