/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.util.Log;
import android.util.LruCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.concurrent.LinkedBlockingDeque;
import site.iway.androidhelpers.BitmapCallback;
import site.iway.androidhelpers.BitmapRequest;
import site.iway.androidhelpers.BitmapSource;
import site.iway.androidhelpers.DeviceHelper;
import site.iway.javahelpers.FileSystemHelper;
import site.iway.javahelpers.HttpFileDownloader;
import site.iway.javahelpers.StringHelper;

public class BitmapCache {
    private static final String LOG_TAG = "BitmapCache";
    private static boolean LOG_ENABLED;
    private static Logger LOGGER;
    private static Context CONTEXT;
    private static int LOADER_COUNT;
    private static int LOADER_THREAD_PRIORITY;
    private static int MAX_RAM_USAGE_OF_SINGLE_BITMAP;
    private static int MAX_RAM_USAGE_OF_ALL_BITMAPS;
    private static Class<? extends HttpFileDownloader> DOWNLOADER_CLASS;
    private static File DOWNLOAD_DIRECTORY;
    private static LruCache<BitmapSource, Bitmap> sLruCache;
    private static LinkedBlockingDeque<BitmapRequest> sDeque;
    private static BitmapLoader[] sLoaders;
    static boolean mInitialized;
    private static final BitmapCallback EMPTY_CALLBACK;

    private static void log(String msg, Throwable tr) {
        if (LOG_ENABLED) {
            if (LOGGER == null) {
                if (tr == null) {
                    Log.d((String)LOG_TAG, (String)msg);
                } else {
                    Log.d((String)LOG_TAG, (String)msg, (Throwable)tr);
                }
            } else {
                LOGGER.d(LOG_TAG, msg, tr);
            }
        }
    }

    private static void log(String msg) {
        BitmapCache.log(msg, null);
    }

    static void throwIfAlreadyInitialized() {
        if (mInitialized) {
            throw new RuntimeException("Already initialized.");
        }
    }

    public static void setLogEnabled(boolean logEnabled) {
        LOG_ENABLED = logEnabled;
    }

    public static void setLogger(Logger logger) {
        LOGGER = logger;
    }

    public static void setContext(Context context) {
        CONTEXT = context;
    }

    public static void setLoaderCount(int count) {
        BitmapCache.throwIfAlreadyInitialized();
        LOADER_COUNT = count;
    }

    public static void setLoaderThreadPriority(int priority) {
        BitmapCache.throwIfAlreadyInitialized();
        LOADER_THREAD_PRIORITY = priority;
    }

    public static void setMaxRAMUsageForSingleBitmap(int usage) {
        BitmapCache.throwIfAlreadyInitialized();
        MAX_RAM_USAGE_OF_SINGLE_BITMAP = usage;
    }

    public static void setMaxRamUsageOfAllBitmaps(int maxRamUsageOfAllBitmaps) {
        MAX_RAM_USAGE_OF_ALL_BITMAPS = maxRamUsageOfAllBitmaps;
    }

    public static void setDownloaderClass(Class<? extends HttpFileDownloader> downloaderClass) {
        DOWNLOADER_CLASS = downloaderClass;
    }

    public static void setDownloadDirectory(File downloadDirectory) {
        BitmapCache.throwIfAlreadyInitialized();
        if (FileSystemHelper.createDirectory((File)downloadDirectory)) {
            DOWNLOAD_DIRECTORY = downloadDirectory;
        } else {
            BitmapCache.log("Failed to create download directory, downloader won't work.");
        }
    }

    public static void setDownloadDirectory(String downloadDirectoryName) {
        File cacheDir = CONTEXT.getCacheDir();
        File imageCacheDir = new File(cacheDir, downloadDirectoryName);
        BitmapCache.setDownloadDirectory(imageCacheDir);
    }

    public static void initialize() {
        BitmapCache.throwIfAlreadyInitialized();
        if (CONTEXT == null) {
            BitmapCache.log("Context is empty");
            throw new RuntimeException("Context must be set.");
        }
        if (LOADER_COUNT <= 0 || LOADER_COUNT > 3) {
            BitmapCache.log("LoaderCount is invalid, use 2 for default.");
            LOADER_COUNT = 2;
        }
        if (LOADER_THREAD_PRIORITY < 1 || LOADER_THREAD_PRIORITY > 10) {
            BitmapCache.log("LoaderThreadPriority is invalid, use Thread.NORM_PRIORITY for default.");
            LOADER_THREAD_PRIORITY = 5;
        }
        if (MAX_RAM_USAGE_OF_SINGLE_BITMAP <= 0 || MAX_RAM_USAGE_OF_SINGLE_BITMAP > 0x800000) {
            BitmapCache.log("MaxRAMUsageOfSingleBitmap is invalid, use 4MB for default.");
            MAX_RAM_USAGE_OF_SINGLE_BITMAP = 0x400000;
        }
        if (MAX_RAM_USAGE_OF_ALL_BITMAPS <= 0) {
            BitmapCache.log("MaxRamUsageOfAllBitmaps is invalid, use 1/3 of HeapGrowthLimit for default.");
            MAX_RAM_USAGE_OF_ALL_BITMAPS = DeviceHelper.getHeapGrowthLimit(CONTEXT) / 5;
        }
        if (DOWNLOADER_CLASS == null) {
            BitmapCache.log("DownloaderClass is not set, use HttpFileDownloader for default.");
            DOWNLOADER_CLASS = HttpFileDownloader.class;
        }
        if (DOWNLOAD_DIRECTORY == null) {
            BitmapCache.log("DownloadDirectory not set or set failed, use cacheDir/BitmapCache for default.");
            BitmapCache.setDownloadDirectory(LOG_TAG);
        }
        sLruCache = new LruCache<BitmapSource, Bitmap>(MAX_RAM_USAGE_OF_ALL_BITMAPS){

            protected int sizeOf(BitmapSource key, Bitmap value) {
                int size = 0;
                if (key != null) {
                    size += 1024;
                }
                if (value != null) {
                    size += 1024 + value.getByteCount();
                }
                return size;
            }
        };
        sDeque = new LinkedBlockingDeque();
        sLoaders = new BitmapLoader[LOADER_COUNT];
        for (int i = 0; i < LOADER_COUNT; ++i) {
            BitmapCache.sLoaders[i] = new BitmapLoader();
            sLoaders[i].setPriority(LOADER_THREAD_PRIORITY);
            sLoaders[i].setName("BitmapLoader-" + i);
            sLoaders[i].start();
        }
        mInitialized = true;
    }

    public static Bitmap get(BitmapSource bitmapSource) {
        return (Bitmap)sLruCache.get((Object)bitmapSource);
    }

    public static void requestNow(BitmapRequest bitmapRequest) {
        sDeque.addFirst(bitmapRequest);
    }

    public static void preRequest(BitmapSource bitmapSource) {
        BitmapCache.requestNow(new BitmapRequest(bitmapSource, EMPTY_CALLBACK));
    }

    static {
        EMPTY_CALLBACK = new BitmapCallback(){

            @Override
            public void onBitmapLoadProgressChange(BitmapRequest request) {
            }
        };
    }

    private static class BitmapLoader
    extends Thread {
        private BitmapRequest mWorkingRequest;
        private Rect mDecodeRect;
        private BitmapFactory.Options mDecodeOptions;

        private BitmapLoader() {
        }

        private InputStream getInputStream(BitmapSource source) throws Exception {
            switch (source.type) {
                case 0: {
                    String cacheFileName = StringHelper.md5((String)source.content);
                    File cacheFile = new File(DOWNLOAD_DIRECTORY, cacheFileName);
                    return new FileInputStream(cacheFile);
                }
                case 3: {
                    AssetManager assetManager = CONTEXT.getAssets();
                    return assetManager.open(source.content);
                }
                case 1: {
                    return new FileInputStream(source.content);
                }
                case 2: {
                    Resources resources = CONTEXT.getResources();
                    int resourceId = Integer.parseInt(source.content);
                    return resources.openRawResource(resourceId);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepareDecode(BitmapSource source) throws Exception {
            this.mDecodeOptions = new BitmapFactory.Options();
            this.mDecodeOptions.inJustDecodeBounds = true;
            InputStream inputStream = this.getInputStream(source);
            try {
                BitmapFactory.decodeStream((InputStream)inputStream, (Rect)this.mDecodeRect, (BitmapFactory.Options)this.mDecodeOptions);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.mDecodeOptions.outWidth <= 0 || this.mDecodeOptions.outHeight <= 0) {
                throw new RuntimeException("Try decode size failed.");
            }
            int width = this.mDecodeOptions.outWidth;
            int height = this.mDecodeOptions.outHeight;
            int scale = 1;
            while (width * height * 4 > MAX_RAM_USAGE_OF_SINGLE_BITMAP) {
                scale *= 2;
                width /= 2;
                height /= 2;
            }
            this.mDecodeOptions.inSampleSize = scale;
            this.mDecodeOptions.inJustDecodeBounds = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Bitmap doDecode(BitmapSource source) throws Exception {
            InputStream inputStream = this.getInputStream(source);
            try {
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, (Rect)this.mDecodeRect, (BitmapFactory.Options)this.mDecodeOptions);
                return bitmap;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    this.mWorkingRequest = (BitmapRequest)sDeque.takeFirst();
                    if (this.mWorkingRequest.isCanceled()) continue;
                    BitmapSource source = this.mWorkingRequest.getSource();
                    if (source.type == -1) {
                        throw new RuntimeException("Type is invalid.");
                    }
                    if (source.content == null || source.content.isEmpty()) {
                        throw new RuntimeException("Content is empty.");
                    }
                    if (source.type == 0) {
                        if (DOWNLOAD_DIRECTORY == null) {
                            throw new RuntimeException("Download directory not set.");
                        }
                        String url = source.content;
                        String cacheFileName = StringHelper.md5((String)url);
                        File cacheFile = new File(DOWNLOAD_DIRECTORY, cacheFileName);
                        String cacheFilePath = cacheFile.getAbsolutePath();
                        if (!cacheFile.exists()) {
                            Constructor constructor = DOWNLOADER_CLASS.getConstructor(String.class, String.class);
                            HttpFileDownloader httpFileDownloader = (HttpFileDownloader)constructor.newInstance(url, cacheFilePath);
                            httpFileDownloader.run();
                            if (!cacheFile.exists()) {
                                throw new IOException("Download failed.");
                            }
                        }
                        if (!cacheFile.setLastModified(System.currentTimeMillis())) {
                            String message = "TFBitmapRequest with source " + source.id + " cache file change last modified failed.";
                            BitmapCache.log(message);
                        }
                    }
                    this.mWorkingRequest.updateProgress(1);
                    this.prepareDecode(source);
                    this.mWorkingRequest.updateProgress(2);
                    Bitmap bitmap = this.doDecode(source);
                    if (bitmap == null) {
                        throw new RuntimeException("Decode failed.");
                    }
                    if (source.filter != null) {
                        this.mWorkingRequest.updateProgress(3);
                        bitmap = source.filter.filter(bitmap);
                        if (bitmap == null) {
                            throw new RuntimeException("Filter failed.");
                        }
                    }
                    sLruCache.put((Object)source, (Object)bitmap);
                    this.mWorkingRequest.updateProgress(4);
                    BitmapCache.log("BitmapRequest with source " + source.id + " get succeed.");
                    continue;
                }
                catch (Exception e) {
                    if (this.mWorkingRequest == null) continue;
                    BitmapSource source = this.mWorkingRequest.getSource();
                    this.mWorkingRequest.updateProgress(5);
                    BitmapCache.log("BitmapRequest with source " + source.id + " get failed.", e);
                    continue;
                }
                finally {
                    if (this.mWorkingRequest == null) continue;
                    this.mWorkingRequest = null;
                    this.mDecodeRect = null;
                    this.mDecodeOptions = null;
                    continue;
                }
                break;
            }
        }
    }

    public static interface Logger {
        public void d(String var1, String var2, Throwable var3);
    }
}

