/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Scroller;
import java.util.LinkedList;
import java.util.List;
import site.iway.androidhelpers.BitmapCache;
import site.iway.androidhelpers.BitmapSource;
import site.iway.androidhelpers.BitmapView;
import site.iway.androidhelpers.R;
import site.iway.androidhelpers.UITimer;
import site.iway.androidhelpers.UnitHelper;
import site.iway.androidhelpers.ViewProcessor;
import site.iway.javahelpers.ArrayHelper;
import site.iway.javahelpers.MathHelper;

public class BannerView
extends ViewGroup {
    private BannerIndexChangedListener mListener;
    private float mClickDetectRadius;
    private List<ViewGroup> mRequestDisallowInterceptTouchEventViewGroups;
    private boolean mWillPreloadNext;
    private Scroller mScroller;
    private BitmapView mBitmapViewCenter;
    private BitmapView mBitmapViewLeft;
    private BitmapView mBitmapViewRight;
    private int mViewWidth;
    private int mViewHeight;
    private BitmapSource[] mBitmapSources;
    private int mLastIndex;
    private int mCurrIndex;
    private boolean mHasAttachedToWindow;
    private UITimer mTimer;
    private boolean mSuperHandledTouchEvent;
    private float mTouchDownX;
    private float mTouchDownY;
    private float mTouchMoveX;
    private float mTouchMoveY;
    private float mTouchDownXOffset;
    private float mTouchDownScrollX;
    private VelocityTracker mVelocityTracker;
    private boolean mWillHandleTouchEvent;

    public BannerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initialize(context, attrs);
    }

    public BannerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    public BannerView(Context context) {
        super(context);
        this.initialize(context, null);
    }

    public void setBannerIndexChangedListener(BannerIndexChangedListener l) {
        this.mListener = l;
    }

    public float getClickDetectRadius() {
        return this.mClickDetectRadius;
    }

    public void setClickDetectRadius(float clickDetectRadius) {
        this.mClickDetectRadius = clickDetectRadius;
    }

    public void addRequestDisallowInterceptTouchEventViewGroup(ViewGroup viewGroup) {
        this.mRequestDisallowInterceptTouchEventViewGroups.add(viewGroup);
    }

    public void removeRequestDisallowInterceptTouchEventViewGroup(ViewGroup viewGroup) {
        this.mRequestDisallowInterceptTouchEventViewGroups.remove(viewGroup);
    }

    public void clearRequestDisallowInterceptTouchEventViewGroups() {
        this.mRequestDisallowInterceptTouchEventViewGroups.clear();
    }

    public boolean isWillPreloadNext() {
        return this.mWillPreloadNext;
    }

    public void setWillPreloadNext(boolean willPreloadNext) {
        this.mWillPreloadNext = willPreloadNext;
    }

    private void initialize(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.BannerView);
        this.setClickDetectRadius(a.getDimension(R.styleable.BannerView_clickDetectRadius, (float)UnitHelper.dipToPxInt(context, 5.0f)));
        this.setWillPreloadNext(a.getBoolean(R.styleable.BannerView_willPreloadNextPage, false));
        this.setAutoNextTime(a.getInt(R.styleable.BannerView_autoNextTime, 0));
        this.mRequestDisallowInterceptTouchEventViewGroups = new LinkedList<ViewGroup>();
        this.mScroller = new Scroller(context);
        int width = -1;
        int height = -1;
        this.mBitmapViewCenter = new BitmapView(context);
        this.mBitmapViewLeft = new BitmapView(context);
        this.mBitmapViewRight = new BitmapView(context);
        this.addView(this.mBitmapViewCenter, width, height);
        this.addView(this.mBitmapViewLeft, width, height);
        this.addView(this.mBitmapViewRight, width, height);
        a.recycle();
    }

    public void initializeBitmapViews(ViewProcessor viewProcessor) {
        viewProcessor.process(this.mBitmapViewCenter);
        viewProcessor.process(this.mBitmapViewLeft);
        viewProcessor.process(this.mBitmapViewRight);
    }

    public void setBitmapSources(BitmapSource ... bitmapSources) {
        this.cancelTouchEventIfNeeded();
        this.mBitmapSources = bitmapSources;
        this.setScrollX(0);
        this.requestLayout();
    }

    private boolean isScrollable() {
        return this.mBitmapSources != null && this.mBitmapSources.length > 1 && this.mViewWidth > 0 && this.mViewHeight > 0 && this.mHasAttachedToWindow;
    }

    public int getCurrentIndex() {
        int scrollX = this.getScrollX();
        int index = scrollX / this.mViewWidth;
        int offset = scrollX % this.mViewWidth;
        int halfWidth = this.mViewWidth / 2;
        if (index == 0) {
            if (offset > halfWidth) {
                ++index;
            }
            if (offset < -halfWidth) {
                --index;
            }
        } else if (index > 0) {
            if (offset > halfWidth) {
                ++index;
            }
        } else if (index < 0 && offset < -halfWidth) {
            --index;
        }
        return index;
    }

    public int getRealIndex() {
        if (ArrayHelper.isEmpty((Object[])this.mBitmapSources)) {
            return -1;
        }
        if (this.mViewWidth == 0 || this.mViewHeight == 0) {
            return 0;
        }
        int currentIndex = this.getCurrentIndex();
        return this.getBitmapSourceIndex(currentIndex);
    }

    private void swapViewsPrev() {
        BitmapView lastRight;
        BitmapView lastLeft = this.mBitmapViewLeft;
        BitmapView lastCenter = this.mBitmapViewCenter;
        this.mBitmapViewLeft = lastRight = this.mBitmapViewRight;
        this.mBitmapViewCenter = lastLeft;
        this.mBitmapViewRight = lastCenter;
    }

    private void swapViewsNext() {
        BitmapView lastLeft = this.mBitmapViewLeft;
        BitmapView lastCenter = this.mBitmapViewCenter;
        BitmapView lastRight = this.mBitmapViewRight;
        this.mBitmapViewLeft = lastCenter;
        this.mBitmapViewCenter = lastRight;
        this.mBitmapViewRight = lastLeft;
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.mCurrIndex = this.getCurrentIndex();
        if (this.mCurrIndex < this.mLastIndex) {
            this.swapViewsPrev();
        }
        if (this.mCurrIndex > this.mLastIndex) {
            this.swapViewsNext();
        }
        if (this.mCurrIndex != this.mLastIndex) {
            this.requestLayout();
            if (this.mListener != null) {
                BitmapSource bitmapSource;
                this.mListener.onBannerIndexChanged(this, this.mCurrIndex);
                if (this.mWillPreloadNext && (bitmapSource = this.getBitmapSource(this.mCurrIndex + 1)) != null) {
                    BitmapCache.preRequest(bitmapSource);
                }
            }
        }
        this.mLastIndex = this.mCurrIndex;
    }

    public void computeScroll() {
        super.computeScroll();
        boolean scrolling = this.mScroller.computeScrollOffset();
        if (scrolling) {
            int scrollX = this.mScroller.getCurrX();
            int scrollY = this.mScroller.getCurrY();
            this.scrollTo(scrollX, scrollY);
            this.postInvalidate();
        }
    }

    private void scrollToIndex(int index) {
        int width = this.getWidth();
        int startX = this.getScrollX();
        int startY = this.getScrollY();
        int dx = width * index - startX;
        int dy = 0;
        int duration = 500;
        this.mScroller.startScroll(startX, startY, dx, dy, duration);
        this.scrollTo(startX, startY);
        this.postInvalidate();
    }

    public void previous() {
        if (this.isScrollable()) {
            int index = this.getCurrentIndex();
            this.scrollToIndex(index - 1);
        }
    }

    public void next() {
        if (this.isScrollable()) {
            int index = this.getCurrentIndex();
            this.scrollToIndex(index + 1);
        }
    }

    public void setAutoNextTime(int millis) {
        if (this.mTimer != null) {
            this.mTimer.stop();
            this.mTimer = null;
        }
        if (millis > 0) {
            this.mTimer = new UITimer(millis){

                @Override
                public void doOnUIThread() {
                    BannerView.this.next();
                }
            };
            if (this.mHasAttachedToWindow) {
                this.mTimer.start(false);
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return true;
    }

    private void handleSuperTouchEvent(MotionEvent event) {
        int action = event.getAction();
        if (action == 0) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        } else if (this.mSuperHandledTouchEvent) {
            this.mSuperHandledTouchEvent = super.onTouchEvent(event);
        }
    }

    private boolean isClick() {
        return MathHelper.distance((double)this.mTouchDownX, (double)this.mTouchDownY, (double)this.mTouchMoveX, (double)this.mTouchMoveY) < (double)this.mClickDetectRadius;
    }

    public void setOnClickListener(final View.OnClickListener l) {
        View.OnClickListener wrappedOnClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                if (BannerView.this.isClick()) {
                    l.onClick(v);
                }
            }
        };
        super.setOnClickListener(wrappedOnClickListener);
    }

    public void setOnLongClickListener(final View.OnLongClickListener l) {
        View.OnLongClickListener wrappedOnLongClickListener = new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (BannerView.this.isClick()) {
                    return l.onLongClick(v);
                }
                return false;
            }
        };
        super.setOnLongClickListener(wrappedOnLongClickListener);
    }

    private void doScroll(MotionEvent event) {
        float targetScrollX = this.mTouchDownScrollX - this.mTouchDownXOffset;
        int targetScrollXRounded = MathHelper.pixel((float)targetScrollX);
        this.setScrollX(targetScrollXRounded);
    }

    private void adjustScroll(MotionEvent event) {
        this.mVelocityTracker.computeCurrentVelocity(1);
        float xVelocity = this.mVelocityTracker.getXVelocity();
        int index = this.getCurrentIndex();
        if (xVelocity < -3.0f) {
            ++index;
        }
        if (xVelocity > 3.0f) {
            --index;
        }
        this.scrollToIndex(index);
    }

    private void cancelTouchEventIfNeeded() {
        if (this.mWillHandleTouchEvent) {
            if (this.mTimer != null) {
                this.mTimer.start(false);
            }
            this.mVelocityTracker.recycle();
            for (ViewGroup viewGroup : this.mRequestDisallowInterceptTouchEventViewGroups) {
                viewGroup.requestDisallowInterceptTouchEvent(false);
            }
            this.mWillHandleTouchEvent = false;
        }
    }

    private void handleTouchEvent(MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 0: {
                boolean isScrolling;
                if (!this.isScrollable()) break;
                this.mWillHandleTouchEvent = true;
                for (ViewGroup viewGroup : this.mRequestDisallowInterceptTouchEventViewGroups) {
                    viewGroup.requestDisallowInterceptTouchEvent(true);
                }
                this.mTouchDownX = this.mTouchMoveX = event.getX();
                this.mTouchDownY = this.mTouchMoveY = event.getY();
                this.mTouchDownScrollX = this.getScrollX();
                this.mVelocityTracker = VelocityTracker.obtain();
                this.mVelocityTracker.addMovement(event);
                boolean bl = isScrolling = !this.mScroller.isFinished();
                if (isScrolling) {
                    this.mScroller.abortAnimation();
                }
                if (this.mTimer == null) break;
                this.mTimer.stop();
                break;
            }
            case 2: {
                if (!this.mWillHandleTouchEvent) break;
                this.mTouchMoveX = event.getX();
                this.mTouchMoveY = event.getY();
                this.mVelocityTracker.addMovement(event);
                this.mTouchDownXOffset = event.getX() - this.mTouchDownX;
                this.doScroll(event);
                break;
            }
            case 1: 
            case 3: {
                if (!this.mWillHandleTouchEvent) break;
                this.mVelocityTracker.addMovement(event);
                this.adjustScroll(event);
                if (this.mTimer != null) {
                    this.mTimer.start(false);
                }
                this.mVelocityTracker.recycle();
                for (ViewGroup viewGroup : this.mRequestDisallowInterceptTouchEventViewGroups) {
                    viewGroup.requestDisallowInterceptTouchEvent(false);
                }
                this.mWillHandleTouchEvent = false;
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.handleSuperTouchEvent(event);
        this.handleTouchEvent(event);
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        this.setMeasuredDimension(widthSize, heightSize);
    }

    private int getBitmapSourceIndex(int index) {
        if (ArrayHelper.isEmpty((Object[])this.mBitmapSources)) {
            return -1;
        }
        int bitmapSourceIndex = index % this.mBitmapSources.length;
        if (bitmapSourceIndex < 0) {
            bitmapSourceIndex += this.mBitmapSources.length;
        }
        return bitmapSourceIndex;
    }

    private BitmapSource getBitmapSource(int index) {
        if (ArrayHelper.isEmpty((Object[])this.mBitmapSources)) {
            return null;
        }
        int bitmapSourceIndex = this.getBitmapSourceIndex(index);
        return this.mBitmapSources[bitmapSourceIndex];
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mViewWidth = r - l;
        this.mViewHeight = b - t;
        int index = this.getCurrentIndex();
        int base = index * this.mViewWidth;
        this.mBitmapViewLeft.layout(base - this.mViewWidth, 0, base - this.mViewWidth + this.mViewWidth, 0 + this.mViewHeight);
        this.mBitmapViewLeft.loadFromSource(this.getBitmapSource(index - 1));
        this.mBitmapViewCenter.layout(base, 0, base + this.mViewWidth, 0 + this.mViewHeight);
        this.mBitmapViewCenter.loadFromSource(this.getBitmapSource(index));
        this.mBitmapViewRight.layout(base + this.mViewWidth, 0, base + this.mViewWidth + this.mViewWidth, 0 + this.mViewHeight);
        this.mBitmapViewRight.loadFromSource(this.getBitmapSource(index + 1));
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mHasAttachedToWindow = true;
        if (this.mTimer != null) {
            this.mTimer.start(false);
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mTimer != null) {
            this.mTimer.stop();
        }
        this.mHasAttachedToWindow = false;
        super.onDetachedFromWindow();
    }

    public static interface BannerIndexChangedListener {
        public void onBannerIndexChanged(BannerView var1, int var2);
    }
}

