/*
 * Decompiled with CFR 0.152.
 */
package site.iway.androidhelpers;

import android.content.Context;
import java.util.LinkedList;
import java.util.List;

public class ActionTimer {
    private static final Object sSynchronizer = new Object();
    private static Context sApplicationContext;
    private static long sTickSpanMillis;
    private static List<Action> sActions;
    private static Thread sThread;

    public static void initialize(Context context, long tickSpanMillis) {
        sApplicationContext = context;
        sTickSpanMillis = tickSpanMillis;
        sThread.start();
    }

    public static void initialize(Context context) {
        ActionTimer.initialize(context, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAction(Action action) {
        Object object = sSynchronizer;
        synchronized (object) {
            String tag = action.getTag();
            if (tag == null) {
                throw new RuntimeException("Action tag can not be null.");
            }
            if (ActionTimer.hasAction(tag)) {
                throw new RuntimeException("Action with tag " + tag + " already existed.");
            }
            sActions.add(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAction(Action action) {
        Object object = sSynchronizer;
        synchronized (object) {
            sActions.remove(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAction(String tag) {
        Object object = sSynchronizer;
        synchronized (object) {
            int size = sActions.size();
            for (int i = size - 1; i >= 0; --i) {
                Action action = sActions.get(i);
                String actionTag = action.getTag();
                if (actionTag == null) {
                    if (tag != null) continue;
                    sActions.remove(i);
                    continue;
                }
                if (!actionTag.equals(tag)) continue;
                sActions.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAction(Action action) {
        Object object = sSynchronizer;
        synchronized (object) {
            return sActions.contains(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAction(String tag) {
        Object object = sSynchronizer;
        synchronized (object) {
            for (Action action : sActions) {
                String actionTag = action.getTag();
                if (!actionTag.equals(tag)) continue;
                return true;
            }
            return false;
        }
    }

    static {
        sActions = new LinkedList<Action>();
        sThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    LinkedList actions = new LinkedList();
                    Object object = sSynchronizer;
                    synchronized (object) {
                        actions.addAll(sActions);
                    }
                    long now = System.currentTimeMillis();
                    for (Action action : actions) {
                        long runTime = action.getRunTime();
                        if (now < runTime) continue;
                        ActionTimer.removeAction(action);
                        action.run(sApplicationContext);
                    }
                    try {
                        Thread.sleep(sTickSpanMillis);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
    }

    public static abstract class Action {
        private volatile String mTag;
        private volatile long mRunTime;

        public Action(String tag) {
            if (tag == null) {
                throw new RuntimeException("Tag of the action can not be null.");
            }
            this.mTag = tag;
        }

        public String getTag() {
            return this.mTag;
        }

        public long getRunTime() {
            return this.mRunTime;
        }

        public void setRunTime(long runTime) {
            this.mRunTime = runTime;
        }

        public void setRunTimeDelayed(long delay) {
            this.mRunTime = System.currentTimeMillis() + delay;
        }

        public void schedule() {
            ActionTimer.addAction(this);
        }

        public abstract void run(Context var1);
    }
}

