/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ws.Argument;
import com.vmware.vim25.ws.Client;
import com.vmware.vim25.ws.SoapAction;
import com.vmware.vim25.ws.XmlGen;
import com.vmware.vim25.ws.XmlGenDom;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;

public abstract class SoapClient
implements Client {
    private static Logger log = Logger.getLogger(SoapClient.class);
    public String soapAction;
    public URL baseUrl = null;
    public String cookie = null;
    public String thumbprint = null;
    public String vimNameSpace = null;
    public int connectTimeout = 0;
    public int readTimeout = 0;
    protected TrustManager trustManager;
    XmlGen xmlGen = new XmlGenDom();

    @Override
    public void setSoapActionOnApiVersion(String apiVersion) {
        log.trace((Object)("API Version detected: " + apiVersion));
        this.soapAction = "4.0".equals(apiVersion) ? SoapAction.SOAP_ACTION_V40.toString() : ("4.1".equals(apiVersion) ? SoapAction.SOAP_ACTION_V41.toString() : ("5.0".equals(apiVersion) ? SoapAction.SOAP_ACTION_V50.toString() : ("5.1".equals(apiVersion) ? SoapAction.SOAP_ACTION_V51.toString() : ("5.5".equals(apiVersion) ? SoapAction.SOAP_ACTION_V55.toString() : ("6.0".equals(apiVersion) ? SoapAction.SOAP_ACTION_V60.toString() : SoapAction.SOAP_ACTION_V60.toString())))));
        log.trace((Object)("Set soapAction to: " + this.soapAction));
    }

    @Override
    public URL getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBaseUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    @Override
    public String getCookie() {
        return this.cookie;
    }

    public void setServerThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
    }

    public String getServerThumbprint() {
        return this.thumbprint;
    }

    public static String computeX509CertificateThumbprint(X509Certificate cert) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return SoapClient.hexify(md.digest(cert.getEncoded()));
        }
        catch (NoSuchAlgorithmException ignore1) {
            return null;
        }
        catch (CertificateEncodingException ignore2) {
            return null;
        }
    }

    public static String hexify(byte[] bytes) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer buf = new StringBuffer(bytes.length * 3);
        for (int i = 0; i < bytes.length; ++i) {
            if (i != 0) {
                buf.append(':');
            }
            buf.append(hexDigits[(bytes[i] & 0xF0) >> 4]);
            buf.append(hexDigits[bytes[i] & 0xF]);
        }
        return buf.toString();
    }

    @Override
    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    @Override
    public String getVimNameSpace() {
        return this.vimNameSpace;
    }

    @Override
    public void setVimNameSpace(String vimNameSpace) {
        this.vimNameSpace = vimNameSpace;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int timeoutMilliSec) {
        this.connectTimeout = timeoutMilliSec;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public void setReadTimeout(int timeoutMilliSec) {
        this.readTimeout = timeoutMilliSec;
    }

    @Override
    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    @Override
    public StringBuffer readStream(InputStream is) throws IOException {
        String lineStr;
        log.trace((Object)"Building StringBuffer from InputStream response.");
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        while ((lineStr = in.readLine()) != null) {
            sb.append(lineStr);
        }
        in.close();
        return sb;
    }

    @Override
    public String marshall(String methodName, Argument[] paras) {
        String soapMsg = XmlGen.toXML(methodName, paras, this.vimNameSpace);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Marshalled Payload String xml: " + soapMsg));
        }
        return soapMsg;
    }

    @Override
    public Object unMarshall(String returnType, InputStream is) throws Exception {
        return this.xmlGen.fromXML(returnType, is);
    }
}

